/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.exceptions.PDFASNameCapacityException;
import com.adobe.internal.pdf.cos.util.exceptions.PDFEncodingException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ASName {
    private static final int TABLE_START_BITS = 10;
    private static final int TABLE_GROW_BITS = 2;
    private static final int TABLE_MAX_BITS = 24;
    static final int TABLE_CAPACITY = 0x1000000;
    private static int sAtomTableBits = 10;
    private static int sAtomTableMask = ~(-1 << sAtomTableBits);
    private static ASName[] sAtomTable = new ASName[1 << sAtomTableBits];
    private static int sAtomCount = 0;
    private byte[] mContents;
    public static final ASName k_BlackIs1 = ASName.create("BlackIs1");
    public static final ASName CM = ASName.create("cm");
    public static final ASName k_Columns = ASName.create("Columns");
    public static final ASName k_Colors = ASName.create("Colors");
    public static final ASName k_DamagedRowsBeforeError = ASName.create("DamagedRowsBeforeError");
    public static final ASName k_DecodeParms = ASName.create("DecodeParms");
    public static final ASName k_EarlyChange = ASName.create("EarlyChange");
    public static final ASName k_EncodedByteAlign = ASName.create("EncodedByteAlign");
    public static final ASName k_EndOfLine = ASName.create("EndOfLine");
    public static final ASName k_EndOfBlock = ASName.create("EndOfBlock");
    public static final ASName k_First = ASName.create("First");
    public static final ASName k_N = ASName.create("N");
    public static final ASName k_ObjStm = ASName.create("ObjStm");
    public static final ASName k_Open = ASName.create("Open");
    public static final ASName k_Predictor = ASName.create("Predictor");
    public static final ASName k_Rows = ASName.create("Rows");
    public static final ASName k_XRef = ASName.create("XRef");
    public static final ASName k_XRefStm = ASName.create("XRefStm");
    public static final ASName k_Client_Data_PDF = ASName.create("Client_Data_PDF");
    public static final ASName k_Cos_Object_Dirty = ASName.create("Cos_Object_Dirty");
    public static final ASName k_Cos_Object_Cloned = ASName.create("Cos_Object_Cloned");
    public static final ASName k_Btn = ASName.create("Btn");
    public static final ASName k_Opt = ASName.create("Opt");
    public static final ASName k_RV = ASName.create("RV");
    public static final ASName k_C = ASName.create("C");
    public static final ASName k_Text = ASName.create("Text");
    public static final ASName k_L = ASName.create("L");
    public static final ASName k_LE = ASName.create("LE");
    public static final ASName k_Link = ASName.create("Link");
    public static final ASName k_FreeText = ASName.create("FreeText");
    public static final ASName k_Line = ASName.create("Line");
    public static final ASName k_Square = ASName.create("Square");
    public static final ASName k_Circle = ASName.create("Circle");
    public static final ASName k_Highlight = ASName.create("Highlight");
    public static final ASName k_Underline = ASName.create("Underline");
    public static final ASName k_Squiggly = ASName.create("Squiggly");
    public static final ASName k_StrikeOut = ASName.create("StrikeOut");
    public static final ASName k_Stamp = ASName.create("Stamp");
    public static final ASName k_Ink = ASName.create("Ink");
    public static final ASName k_Popup = ASName.create("Popup");
    public static final ASName k_FileAttachment = ASName.create("FileAttachment");
    public static final ASName k_Filespec = ASName.create("Filespec");
    public static final ASName k_Sound = ASName.create("Sound");
    public static final ASName k_Movie = ASName.create("Movie");
    public static final ASName k_NM = ASName.create("NM");
    public static final ASName k_A = ASName.create("A");
    public static final ASName k_AA = ASName.create("AA");
    public static final ASName k_AbsoluteColorimetric = ASName.create("AbsoluteColorimetric");
    public static final ASName k_AcroForm = ASName.create("AcroForm");
    public static final ASName k_Action = ASName.create("Action");
    public static final ASName k_ADBE_AuthType = ASName.create("ADBE_AuthType");
    public static final ASName k_ADBE_Build = ASName.create("ADBE_Build");
    public static final ASName k_ADBE_PwdTime = ASName.create("ADBE_PwdTime");
    public static final ASName k_A85 = ASName.create("A85");
    public static final ASName k_AHx = ASName.create("AHx");
    public static final ASName k_AIS = ASName.create("AIS");
    public static final ASName k_Annot = ASName.create("Annot");
    public static final ASName k_Annots = ASName.create("Annots");
    public static final ASName k_AP = ASName.create("AP");
    public static final ASName k_ArtBox = ASName.create("ArtBox");
    public static final ASName k_AS = ASName.create("AS");
    public static final ASName k_Ascent = ASName.create("Ascent");
    public static final ASName k_ASCII85Decode = ASName.create("ASCII85Decode");
    public static final ASName k_ASCII85Encode = ASName.create("ASCII85Encode");
    public static final ASName k_ASCIIHexDecode = ASName.create("ASCIIHexDecode");
    public static final ASName k_ASCIIHexEncode = ASName.create("ASCIIHexEncode");
    public static final ASName k_Author = ASName.create("Author");
    public static final ASName k_AvgWidth = ASName.create("AvgWidth");
    public static final ASName k_b = ASName.create("b");
    public static final ASName k_B = ASName.create("B");
    public static final ASName k_BaseEncoding = ASName.create("BaseEncoding");
    public static final ASName k_BaseFont = ASName.create("BaseFont");
    public static final ASName k_BDC = ASName.create("BDC");
    public static final ASName k_BI = ASName.create("BI");
    public static final ASName k_BitsPerComponent = ASName.create("BitsPerComponent");
    public static final ASName k_BleedBox = ASName.create("BleedBox");
    public static final ASName k_Border = ASName.create("Border");
    public static final ASName k_BE = ASName.create("BE");
    public static final ASName k_BG = ASName.create("BG");
    public static final ASName k_BG2 = ASName.create("BG2");
    public static final ASName k_BM = ASName.create("BM");
    public static final ASName k_BMC = ASName.create("BMC");
    public static final ASName k_BPC = ASName.create("BPC");
    public static final ASName k_BS = ASName.create("BS");
    public static final ASName k_bStar = ASName.create("b*");
    public static final ASName k_BStar = ASName.create("B*");
    public static final ASName k_BT = ASName.create("BT");
    public static final ASName k_BX = ASName.create("BX");
    public static final ASName k_ByteRange = ASName.create("ByteRange");
    public static final ASName k_c = ASName.create("c");
    public static final ASName k_ca = ASName.create("ca");
    public static final ASName k_Catalog = ASName.create("Catalog");
    public static final ASName k_CCF = ASName.create("CCF");
    public static final ASName k_Cert = ASName.create("Cert");
    public static final ASName k_Ch = ASName.create("Ch");
    public static final ASName k_CharProcs = ASName.create("CharProcs");
    public static final ASName k_CheckSum = ASName.create("CheckSum");
    public static final ASName k_cm = ASName.create("cm");
    public static final ASName k_CA = ASName.create("CA");
    public static final ASName k_CalCMYK = ASName.create("CalCMYK");
    public static final ASName k_CalGray = ASName.create("CalGray");
    public static final ASName k_CalRGB = ASName.create("CalRGB");
    public static final ASName k_CapHeight = ASName.create("CapHeight");
    public static final ASName k_CCITTFaxDecode = ASName.create("CCITTFaxDecode");
    public static final ASName k_CharSet = ASName.create("CharSet");
    public static final ASName k_CIDFontType0 = ASName.create("CIDFontType0");
    public static final ASName k_CIDFontType2 = ASName.create("CIDFontType2");
    public static final ASName k_CIDSet = ASName.create("CIDSet");
    public static final ASName k_CIDSystemInfo = ASName.create("CIDSystemInfo");
    public static final ASName k_CIDToGIDMap = ASName.create("CIDToGIDMap");
    public static final ASName k_CMapName = ASName.create("CMapName");
    public static final ASName k_CMYK = ASName.create("CMYK");
    public static final ASName k_ColorSpace = ASName.create("ColorSpace");
    public static final ASName k_Condensed = ASName.create("Condensed");
    public static final ASName k_Contents = ASName.create("Contents");
    public static final ASName k_Count = ASName.create("Count");
    public static final ASName k_CreationDate = ASName.create("CreationDate");
    public static final ASName k_Creator = ASName.create("Creator");
    public static final ASName k_CropBox = ASName.create("CropBox");
    public static final ASName k_cs = ASName.create("cs");
    public static final ASName k_CS = ASName.create("CS");
    public static final ASName k_d = ASName.create("d");
    public static final ASName k_D = ASName.create("D");
    public static final ASName k_d0 = ASName.create("d0");
    public static final ASName k_d1 = ASName.create("d1");
    public static final ASName k_DA = ASName.create("DA");
    public static final ASName k_DCT = ASName.create("DCT");
    public static final ASName k_DCTDecode = ASName.create("DCTDecode");
    public static final ASName k_DescendantFonts = ASName.create("DescendantFonts");
    public static final ASName k_Descent = ASName.create("Descent");
    public static final ASName k_Differences = ASName.create("Differences");
    public static final ASName k_Do = ASName.create("Do");
    public static final ASName k_DoubleQuote = ASName.create("\"");
    public static final ASName k_Data = ASName.create("Data");
    public static final ASName k_Dest = ASName.create("Dest");
    public static final ASName k_Dests = ASName.create("Dests");
    public static final ASName k_DeviceCMYK = ASName.create("DeviceCMYK");
    public static final ASName k_DeviceGray = ASName.create("DeviceGray");
    public static final ASName k_DeviceN = ASName.create("DeviceN");
    public static final ASName k_DeviceRGB = ASName.create("DeviceRGB");
    public static final ASName k_DOS = ASName.create("DOS");
    public static final ASName k_DP = ASName.create("DP");
    public static final ASName k_DR = ASName.create("DR");
    public static final ASName k_DS = ASName.create("DS");
    public static final ASName k_DV = ASName.create("DV");
    public static final ASName k_DW = ASName.create("DW");
    public static final ASName k_DW2 = ASName.create("DW2");
    public static final ASName k_E = ASName.create("E");
    public static final ASName k_EF = ASName.create("EF");
    public static final ASName k_EI = ASName.create("EI");
    public static final ASName k_EMC = ASName.create("EMC");
    public static final ASName k_Encrypt = ASName.create("Encrypt");
    public static final ASName k_EmbeddedFiles = ASName.create("EmbeddedFiles");
    public static final ASName k_Encoding = ASName.create("Encoding");
    public static final ASName k_ET = ASName.create("ET");
    public static final ASName k_EX = ASName.create("EX");
    public static final ASName k_Expanded = ASName.create("Expanded");
    public static final ASName k_ExtGState = ASName.create("ExtGState");
    public static final ASName k_ExtraCondensed = ASName.create("ExtraConsdensed");
    public static final ASName k_ExtraExpanded = ASName.create("ExtraExpanded");
    public static final ASName k_f = ASName.create("f");
    public static final ASName k_F = ASName.create("F");
    public static final ASName k_F1 = ASName.create("F1");
    public static final ASName k_false = ASName.create("false");
    public static final ASName k_FD = ASName.create("FD");
    public static final ASName k_Ff = ASName.create("Ff");
    public static final ASName k_FT = ASName.create("FT");
    public static final ASName k_FS = ASName.create("FS");
    public static final ASName k_fStar = ASName.create("f*");
    public static final ASName k_Fields = ASName.create("Fields");
    public static final ASName k_Fit = ASName.create("Fit");
    public static final ASName k_FitH = ASName.create("FitH");
    public static final ASName k_FitV = ASName.create("FitV");
    public static final ASName k_FitR = ASName.create("FitR");
    public static final ASName k_FitB = ASName.create("FitB");
    public static final ASName k_FitBH = ASName.create("FitBH");
    public static final ASName k_FitBV = ASName.create("FitBV");
    public static final ASName k_Filter = ASName.create("Filter");
    public static final ASName k_FFilter = ASName.create("FFilter");
    public static final ASName k_FirstChar = ASName.create("FirstChar");
    public static final ASName k_Fl = ASName.create("Fl");
    public static final ASName k_FL = ASName.create("FL");
    public static final ASName k_Flags = ASName.create("Flags");
    public static final ASName k_FlateDecode = ASName.create("FlateDecode");
    public static final ASName k_Font = ASName.create("Font");
    public static final ASName k_FontBBox = ASName.create("FontBBox");
    public static final ASName k_FontDescriptor = ASName.create("FontDescriptor");
    public static final ASName k_FontFamily = ASName.create("FontFamily");
    public static final ASName k_FontFile = ASName.create("FontFile");
    public static final ASName k_FontFile2 = ASName.create("FontFile2");
    public static final ASName k_FontFile3 = ASName.create("FontFile3");
    public static final ASName k_FontMatrix = ASName.create("FontMatrix");
    public static final ASName k_FontName = ASName.create("FontName");
    public static final ASName k_FontStretch = ASName.create("FontStretch");
    public static final ASName k_FontWeight = ASName.create("FontWeight");
    public static final ASName k_g = ASName.create("g");
    public static final ASName k_G = ASName.create("G");
    public static final ASName k_GoTo = ASName.create("GoTo");
    public static final ASName k_GoToR = ASName.create("GoToR");
    public static final ASName k_gs = ASName.create("gs");
    public static final ASName k_h = ASName.create("h");
    public static final ASName k_H = ASName.create("H");
    public static final ASName k_Height = ASName.create("Height");
    public static final ASName k_HT = ASName.create("HT");
    public static final ASName k_i = ASName.create("i");
    public static final ASName k_I = ASName.create("I");
    public static final ASName k_IC = ASName.create("IC");
    public static final ASName k_ICCBased = ASName.create("ICCBased");
    public static final ASName k_ID = ASName.create("ID");
    public static final ASName k_IDS = ASName.create("IDS");
    public static final ASName k_IM = ASName.create("IM");
    public static final ASName k_ImageMask = ASName.create("ImageMask");
    public static final ASName k_Index = ASName.create("Index");
    public static final ASName k_Indexed = ASName.create("Indexed");
    public static final ASName k_IsMap = ASName.create("IsMap");
    public static final ASName k_Info = ASName.create("Info");
    public static final ASName k_ItalicAngle = ASName.create("ItalicAngle");
    public static final ASName k_j = ASName.create("j");
    public static final ASName k_J = ASName.create("J");
    public static final ASName k_JavaScript = ASName.create("JavaScript");
    public static final ASName k_InkList = ASName.create("InkList");
    public static final ASName k_IRT = ASName.create("IRT");
    public static final ASName k_k = ASName.create("k");
    public static final ASName k_K = ASName.create("K");
    public static final ASName k_Kids = ASName.create("Kids");
    public static final ASName k_Keywords = ASName.create("Keywords");
    public static final ASName k_l = ASName.create("l");
    public static final ASName k_Lab = ASName.create("Lab");
    public static final ASName k_Lang = ASName.create("Lang");
    public static final ASName k_LastChar = ASName.create("LastChar");
    public static final ASName k_Launch = ASName.create("Launch");
    public static final ASName k_LC = ASName.create("LC");
    public static final ASName k_Leading = ASName.create("Leading");
    public static final ASName k_Length = ASName.create("Length");
    public static final ASName k_Length1 = ASName.create("Length1");
    public static final ASName k_Length2 = ASName.create("Length2");
    public static final ASName k_Length3 = ASName.create("Length3");
    public static final ASName k_Limits = ASName.create("Limits");
    public static final ASName k_LJ = ASName.create("LJ");
    public static final ASName k_Location = ASName.create("Location");
    public static final ASName k_LW = ASName.create("LW");
    public static final ASName k_LZW = ASName.create("LZW");
    public static final ASName k_LZWDecode = ASName.create("LZWDecode");
    public static final ASName k_LZWEncode = ASName.create("LZWEncode");
    public static final ASName k_m = ASName.create("m");
    public static final ASName k_M = ASName.create("M");
    public static final ASName k_Mac = ASName.create("Mac");
    public static final ASName k_MaxWidth = ASName.create("MaxWidth");
    public static final ASName k_MediaBox = ASName.create("MediaBox");
    public static final ASName k_Metadata = ASName.create("Metadata");
    public static final ASName k_MissingWidth = ASName.create("MissingWidth");
    public static final ASName k_MK = ASName.create("MK");
    public static final ASName k_ML = ASName.create("ML");
    public static final ASName k_MMType1 = ASName.create("MMType1");
    public static final ASName k_ModDate = ASName.create("ModDate");
    public static final ASName k_MP = ASName.create("MP");
    public static final ASName k_n = ASName.create("n");
    public static final ASName k_Name = ASName.create("Name");
    public static final ASName k_Named = ASName.create("Named");
    public static final ASName k_Names = ASName.create("Names");
    public static final ASName k_NewWindow = ASName.create("NewWindow");
    public static final ASName k_NeedAppearances = ASName.create("NeedAppearances");
    public static final ASName k_Normal = ASName.create("Normal");
    public static final ASName k_null = ASName.create("null");
    public static final ASName k_O = ASName.create("O");
    public static final ASName k_op = ASName.create("op");
    public static final ASName k_OP = ASName.create("OP");
    public static final ASName k_OPM = ASName.create("OPM");
    public static final ASName k_Ordering = ASName.create("Ordering");
    public static final ASName k_Outlines = ASName.create("Outlines");
    public static final ASName k_P = ASName.create("P");
    public static final ASName k_Password = ASName.create("Password");
    public static final ASName k_Page = ASName.create("Page");
    public static final ASName k_Pages = ASName.create("Pages");
    public static final ASName k_Params = ASName.create("Params");
    public static final ASName k_Parent = ASName.create("Parent");
    public static final ASName k_Pattern = ASName.create("Pattern");
    public static final ASName k_Perceptual = ASName.create("Perceptual");
    public static final ASName k_Prev = ASName.create("Prev");
    public static final ASName k_ProcSet = ASName.create("ProcSet");
    public static final ASName k_Producer = ASName.create("Producer");
    public static final ASName k_Q = ASName.create("Q");
    public static final ASName k_q = ASName.create("q");
    public static final ASName k_QuadPoints = ASName.create("QuadPoints");
    public static final ASName k_R = ASName.create("R");
    public static final ASName k_RC = ASName.create("RC");
    public static final ASName k_RD = ASName.create("RD");
    public static final ASName k_re = ASName.create("re");
    public static final ASName k_RelativeColorimetric = ASName.create("RelativeColorimetric");
    public static final ASName k_Resources = ASName.create("Resources");
    public static final ASName k_Reason = ASName.create("Reason");
    public static final ASName k_Rect = ASName.create("Rect");
    public static final ASName k_Registry = ASName.create("Registry");
    public static final ASName k_rg = ASName.create("rg");
    public static final ASName k_RG = ASName.create("RG");
    public static final ASName k_RGB = ASName.create("RGB");
    public static final ASName k_ri = ASName.create("ri");
    public static final ASName k_RI = ASName.create("RI");
    public static final ASName k_RL = ASName.create("RL");
    public static final ASName k_Root = ASName.create("Root");
    public static final ASName k_Rotate = ASName.create("Rotate");
    public static final ASName k_RunLengthDecode = ASName.create("RunLengthDecode");
    public static final ASName k_s = ASName.create("s");
    public static final ASName k_S = ASName.create("S");
    public static final ASName k_SA = ASName.create("SA");
    public static final ASName k_Saturation = ASName.create("Saturation");
    public static final ASName k_Separation = ASName.create("Separation");
    public static final ASName k_sc = ASName.create("sc");
    public static final ASName k_SC = ASName.create("SC");
    public static final ASName k_scn = ASName.create("scn");
    public static final ASName k_SCN = ASName.create("SCN");
    public static final ASName k_SemiCondensed = ASName.create("SemiCondensed");
    public static final ASName k_SemiExpanded = ASName.create("SemiExpanded");
    public static final ASName k_sh = ASName.create("sh");
    public static final ASName k_Sig = ASName.create("Sig");
    public static final ASName k_SingleQuote = ASName.create("'");
    public static final ASName k_Size = ASName.create("Size");
    public static final ASName k_SM = ASName.create("SM");
    public static final ASName k_SMask = ASName.create("SMask");
    public static final ASName k_Standard = ASName.create("Standard");
    public static final ASName k_State = ASName.create("State");
    public static final ASName k_StateModel = ASName.create("StateModel");
    public static final ASName k_StemH = ASName.create("StemH");
    public static final ASName k_StemV = ASName.create("StemV");
    public static final ASName k_Style = ASName.create("Style");
    public static final ASName k_Subj = ASName.create("Subj");
    public static final ASName k_Subject = ASName.create("Subject");
    public static final ASName k_SubFilter = ASName.create("SubFilter");
    public static final ASName k_Subtype = ASName.create("Subtype");
    public static final ASName k_Supplement = ASName.create("Supplement");
    public static final ASName k_T = ASName.create("T");
    public static final ASName k_Tc = ASName.create("Tc");
    public static final ASName k_Td = ASName.create("Td");
    public static final ASName k_TD = ASName.create("TD");
    public static final ASName k_Templates = ASName.create("Templates");
    public static final ASName k_Tf = ASName.create("Tf");
    public static final ASName k_Title = ASName.create("Title");
    public static final ASName k_Tj = ASName.create("Tj");
    public static final ASName k_TJ = ASName.create("TJ");
    public static final ASName k_TK = ASName.create("TK");
    public static final ASName k_TL = ASName.create("TL");
    public static final ASName k_Tm = ASName.create("Tm");
    public static final ASName k_TM = ASName.create("TM");
    public static final ASName k_ToUnicode = ASName.create("ToUnicode");
    public static final ASName k_Tr = ASName.create("Tr");
    public static final ASName k_TR = ASName.create("TR");
    public static final ASName k_TR2 = ASName.create("TR2");
    public static final ASName k_TrimBox = ASName.create("TrimBox");
    public static final ASName k_true = ASName.create("true");
    public static final ASName k_TrueType = ASName.create("TrueType");
    public static final ASName k_Ts = ASName.create("Ts");
    public static final ASName k_TStar = ASName.create("T*");
    public static final ASName k_Tw = ASName.create("Tw");
    public static final ASName k_TU = ASName.create("TU");
    public static final ASName k_Tx = ASName.create("Tx");
    public static final ASName k_Type = ASName.create("Type");
    public static final ASName k_Type0 = ASName.create("Type0");
    public static final ASName k_Type1 = ASName.create("Type1");
    public static final ASName k_Type3 = ASName.create("Type3");
    public static final ASName k_Tz = ASName.create("Tz");
    public static final ASName k_U = ASName.create("U");
    public static final ASName k_UCR = ASName.create("UCR");
    public static final ASName k_UCR2 = ASName.create("UCR2");
    public static final ASName k_UltraCondensed = ASName.create("UltraCondensed");
    public static final ASName k_UltraExpanded = ASName.create("UltraExpanded");
    public static final ASName k_Unix = ASName.create("Unix");
    public static final ASName k_URI = ASName.create("URI");
    public static final ASName k_URL = ASName.create("URL");
    public static final ASName k_URLS = ASName.create("URLS");
    public static final ASName k_UseCMap = ASName.create("UseCMap");
    public static final ASName k_v = ASName.create("v");
    public static final ASName k_V = ASName.create("V");
    public static final ASName k_w = ASName.create("w");
    public static final ASName k_W = ASName.create("W");
    public static final ASName k_W2 = ASName.create("W2");
    public static final ASName k_WStar = ASName.create("W*");
    public static final ASName k_Widget = ASName.create("Widget");
    public static final ASName k_Width = ASName.create("Width");
    public static final ASName k_Widths = ASName.create("Widths");
    public static final ASName k_WMode = ASName.create("WMode");
    public static final ASName k_XFA = ASName.create("XFA");
    public static final ASName k_XHeight = ASName.create("XHeight");
    public static final ASName k_XML = ASName.create("XML");
    public static final ASName k_XYZ = ASName.create("XYZ");
    public static final ASName k_XObject = ASName.create("XObject");
    public static final ASName k_y = ASName.create("y");
    public static final ASName k_Form = ASName.create("Form");
    public static final ASName k_Image = ASName.create("Image");
    public static final ASName k_Times_Roman = ASName.create("Times-Roman");
    public static final ASName k_TimesNewRomanPSMT = ASName.create("TimesNewRomanPSMT");
    public static final ASName k_TimesNewRoman = ASName.create("TimesNewRoman");
    public static final ASName k_TimesNewRomanPS = ASName.create("TimesNewRomanPS");
    public static final ASName k_Times_Bold = ASName.create("Times-Bold");
    public static final ASName k_TimesNewRomanPS_BoldMT = ASName.create("TimesNewRomanPS-BoldMT");
    public static final ASName k_TimesNewRomanCommaBold = ASName.create("TimesNewRoman,Bold");
    public static final ASName k_TimesNewRomanPS_Bold = ASName.create("TimesNewRomanPS-Bold");
    public static final ASName k_TimesNewRoman_Bold = ASName.create("TimesNewRoman-Bold");
    public static final ASName k_Times_Italic = ASName.create("Times-Italic");
    public static final ASName k_TimesNewRomanPS_ItalicMT = ASName.create("TimesNewRomanPS-ItalicMT");
    public static final ASName k_TimesNewRomanCommaItalic = ASName.create("TimesNewRoman,Italic");
    public static final ASName k_TimesNewRomanPS_Italic = ASName.create("TimesNewRomanPS-Italic");
    public static final ASName k_TimesNewRoman_Italic = ASName.create("TimesNewRoman-Italic");
    public static final ASName k_Times_BoldItalic = ASName.create("Times-BoldItalic");
    public static final ASName k_TimesNewRomanPS_BoldItalicMT = ASName.create("TimesNewRomanPS-BoldItalicMT");
    public static final ASName k_TimesNewRomanCommaBoldItalic = ASName.create("TimesNewRoman,BoldItalic");
    public static final ASName k_TimesNewRomanPS_BoldItalic = ASName.create("TimesNewRomanPS-BoldItalic");
    public static final ASName k_TimesNewRoman_BoldItalic = ASName.create("TimesNewRoman-BoldItalic");
    public static final ASName k_Helvetica = ASName.create("Helvetica");
    public static final ASName k_ArialMT = ASName.create("ArialMT");
    public static final ASName k_Arial = ASName.create("Arial");
    public static final ASName k_Helvetica_Bold = ASName.create("Helvetica-Bold");
    public static final ASName k_Arial_BoldMT = ASName.create("Arial-BoldMT");
    public static final ASName k_ArialCommaBold = ASName.create("Arial,Bold");
    public static final ASName k_Arial_Bold = ASName.create("Arial-Bold");
    public static final ASName k_HelveticaCommaBold = ASName.create("Helvetica,Bold");
    public static final ASName k_Helvetica_Oblique = ASName.create("Helvetica-Oblique");
    public static final ASName k_Arial_ItalicMT = ASName.create("Arial-ItalicMT");
    public static final ASName k_ArialCommaItalic = ASName.create("Arial,Italic");
    public static final ASName k_Arial_Italic = ASName.create("Arial-Italic");
    public static final ASName k_HelveticaCommaItalic = ASName.create("Helvetica,Italic");
    public static final ASName k_Helvetica_Italic = ASName.create("Helvetica-Italic");
    public static final ASName k_Helvetica_BoldOblique = ASName.create("Helvetica-BoldOblique");
    public static final ASName k_Arial_BoldItalicMT = ASName.create("Arial-BoldItalicMT");
    public static final ASName k_ArialCommaBoldItalic = ASName.create("Arial,BoldItalic");
    public static final ASName k_Arial_BoldItalic = ASName.create("Arial-BoldItalic");
    public static final ASName k_HelveticaCommaBoldItalic = ASName.create("Helvetica,BoldItalic");
    public static final ASName k_Helvetica_BoldItalic = ASName.create("Helvetica-BoldItalic");
    public static final ASName k_Courier = ASName.create("Courier");
    public static final ASName k_CourierNew = ASName.create("CourierNew");
    public static final ASName k_CourierNewPSMT = ASName.create("CourierNewPSMT");
    public static final ASName k_Courier_Bold = ASName.create("Courier-Bold");
    public static final ASName k_CourierNewCommaBold = ASName.create("CourierNew,Bold");
    public static final ASName k_CourierCommaBold = ASName.create("Courier,Bold");
    public static final ASName k_CourierNewPS_BoldMT = ASName.create("CourierNewPS-BoldMT");
    public static final ASName k_CourierNew_Bold = ASName.create("CourierNew-Bold");
    public static final ASName k_Courier_Oblique = ASName.create("Courier-Oblique");
    public static final ASName k_CourierNewCommaItalic = ASName.create("CourierNew,Italic");
    public static final ASName k_CourierCommaItalic = ASName.create("Courier,Italic");
    public static final ASName k_CourierNewPS_ItalicMT = ASName.create("CourierNewPS-ItalicMT");
    public static final ASName k_CourierNew_Italic = ASName.create("CourierNew-Italic");
    public static final ASName k_Courier_BoldOblique = ASName.create("Courier-BoldOblique");
    public static final ASName k_CourierNewCommaBoldItalic = ASName.create("CourierNew,BoldItalic");
    public static final ASName k_CourierCommaBoldItalic = ASName.create("Courier,BoldItalic");
    public static final ASName k_CourierNewPS_BoldItalicMT = ASName.create("CourierNewPS-BoldItalicMT");
    public static final ASName k_CourierNew_BoldItalic = ASName.create("CourierNew-BoldItalic");
    public static final ASName k_Symbol = ASName.create("Symbol");
    public static final ASName k_ZapfDingbats = ASName.create("ZapfDingbats");
    public static final ASName k_StandardEncoding = ASName.create("StandardEncoding");
    public static final ASName k_MacRomanEncoding = ASName.create("MacRomanEncoding");
    public static final ASName k_WinAnsiEncoding = ASName.create("WinAnsiEncoding");
    public static final ASName k_PDFDocEncoding = ASName.create("PDFDocEncoding");
    public static final ASName k_MacExpertEncoding = ASName.create("MacExpertEncoding");
    public static final ASName k_SymbolEncoding = ASName.create("SymbolEncoding");
    public static final ASName k_ZapfDingbatsEncoding = ASName.create("ZapfDingbatsEncoding");
    public static final ASName k_Identity_H = ASName.create("Identity-H");
    public static final ASName k_Identity_V = ASName.create("Identity-V");
    public static final ASName k_begincmap = ASName.create("begincmap");
    public static final ASName k_endcmap = ASName.create("endcmap");
    public static final ASName k_usecmap = ASName.create("usecmap");
    public static final ASName k_begincodespacerange = ASName.create("begincodespacerange");
    public static final ASName k_endcodespacerange = ASName.create("endcodespacerange");
    public static final ASName k_beginbfchar = ASName.create("beginbfchar");
    public static final ASName k_endbfchar = ASName.create("endbfchar");
    public static final ASName k_beginbfrange = ASName.create("beginbfrange");
    public static final ASName k_endbfrange = ASName.create("endbfrange");
    public static final ASName k_begincidchar = ASName.create("begincidchar");
    public static final ASName k_endcidchar = ASName.create("endcidchar");
    public static final ASName k_begincidrange = ASName.create("begincidrange");
    public static final ASName k_endcidrange = ASName.create("endcidrange");

    private ASName(byte[] byArray, int n, int n2) {
        this.mContents = new byte[n2];
        for (int i = 0; i < this.mContents.length; ++i) {
            this.mContents[i] = byArray[n + i];
        }
    }

    public static ASName create(String string) {
        byte[] byArray = PDFDocEncoding.toUTF8(string);
        return ASName.getName(byArray, 0, byArray.length);
    }

    public String toString() {
        String string;
        try {
            string = new String(this.mContents, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PDFEncodingException("platform does not support UTF-8");
        }
        return string;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(47);
        for (int i = 0; i < this.mContents.length; ++i) {
            byte by = this.mContents[i];
            if (!(by == 0 || by != 35 && ByteOps.isRegular(by) && by >= 33 && by <= 126)) {
                String string = Integer.toHexString(by).toUpperCase();
                char[] cArray = string.toCharArray();
                outputStream.write(35);
                if (cArray.length == 1) {
                    outputStream.write(0);
                    outputStream.write((byte)cArray[0]);
                    continue;
                }
                outputStream.write((byte)cArray[0]);
                outputStream.write((byte)cArray[1]);
                continue;
            }
            outputStream.write(by);
        }
    }

    private boolean equals(byte[] byArray, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.mContents.length == n2;
        if (bl) {
            for (int i = 0; bl && i < this.mContents.length; ++i) {
                bl = this.mContents[i] == byArray[n + i];
            }
        }
        return bl;
    }

    private static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 ^= byArray[i] * -1640531527;
        }
        return n3;
    }

    public static synchronized ASName getName(byte[] byArray, int n, int n2) throws PDFASNameCapacityException {
        ASName aSName;
        int n3 = ASName.hashCode(byArray, n, n2);
        int n4 = n3 >>> 32 - sAtomTableBits;
        int n5 = n3 >>> 32 - sAtomTableBits - sAtomTableBits + 1 | 1;
        while ((aSName = sAtomTable[(n4 += n5) & sAtomTableMask]) != null && !aSName.equals(byArray, n, n2)) {
        }
        if (aSName == null) {
            if (sAtomCount >= 0x1000000) {
                throw new PDFASNameCapacityException(sAtomCount);
            }
            ASName.sAtomTable[n4 & ASName.sAtomTableMask] = aSName = new ASName(byArray, n, n2);
            if (sAtomTableBits + 2 <= 24 && ++sAtomCount >= sAtomTable.length / 4) {
                ASName.growAtomTable();
            }
        }
        return aSName;
    }

    private static void growAtomTable() {
        ASName[] aSNameArray = sAtomTable;
        sAtomTableMask = ~(-1 << (sAtomTableBits += 2));
        sAtomTable = new ASName[1 << sAtomTableBits];
        for (int i = 0; i < aSNameArray.length; ++i) {
            ASName aSName = aSNameArray[i];
            if (aSName == null) continue;
            int n = ASName.hashCode(aSName.mContents, 0, aSName.mContents.length);
            int n2 = n >>> 32 - sAtomTableBits;
            int n3 = n >>> 32 - sAtomTableBits - sAtomTableBits + 1 | 1;
            while (sAtomTable[(n2 += n3) & sAtomTableMask] != null) {
            }
            ASName.sAtomTable[n2 & ASName.sAtomTableMask] = aSName;
        }
    }
}

