/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

public class ASMatrix
implements Cloneable {
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected double x;
    protected double y;
    protected ASMatrix inverseTransform;
    private static ASMatrix gIdentityMatrix = new ASMatrix();
    private static double Deg2Rad = Math.PI / 180;

    public static ASMatrix createIdentityMatrix() {
        return gIdentityMatrix;
    }

    private ASMatrix() {
        this.d = 1.0;
        this.a = 1.0;
        this.y = 0.0;
        this.x = 0.0;
        this.c = 0.0;
        this.b = 0.0;
        this.inverseTransform = this;
    }

    public ASMatrix(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.x = d5;
        this.y = d6;
        this.inverseTransform = null;
    }

    public ASMatrix(double[] dArray) {
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[3];
        this.x = dArray[4];
        this.y = dArray[5];
        this.inverseTransform = null;
    }

    public ASMatrix(ASMatrix aSMatrix) {
        this.a = aSMatrix.a;
        this.b = aSMatrix.b;
        this.c = aSMatrix.c;
        this.d = aSMatrix.d;
        this.x = aSMatrix.x;
        this.y = aSMatrix.y;
        this.inverseTransform = aSMatrix.inverseTransform;
    }

    public double geta() {
        return this.a;
    }

    public double getb() {
        return this.b;
    }

    public double getc() {
        return this.c;
    }

    public double getd() {
        return this.d;
    }

    public double getx() {
        return this.x;
    }

    public double gety() {
        return this.y;
    }

    public boolean equals(ASMatrix aSMatrix) {
        return aSMatrix != null && this.a == aSMatrix.a && this.b == aSMatrix.b && this.c == aSMatrix.c && this.d == aSMatrix.d && this.x == aSMatrix.x && this.y == aSMatrix.y;
    }

    public boolean isIdentity() {
        return this.a == 1.0 && this.d == 1.0 && this.b == 0.0 && this.c == 0.0;
    }

    public boolean isInvertable() {
        double d = this.b * this.c - this.a * this.d;
        return !Double.isNaN(d) && !Double.isInfinite(d) && d != 0.0;
    }

    public ASMatrix rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return this.concat(new ASMatrix(d2, d3, -d3, d2, 0.0, 0.0));
    }

    public ASMatrix scale(double d, double d2) {
        return new ASMatrix(this.a * d, this.b * d2, this.c * d, this.d * d2, this.x * d, this.y * d2);
    }

    public ASMatrix scale(double d) {
        return this.scale(d, d);
    }

    public ASMatrix preScale(double d, double d2) {
        return new ASMatrix(this.a * d, this.b * d, this.c * d2, this.d * d2, this.x, this.y);
    }

    public ASMatrix preScale(double d) {
        return this.preScale(d, d);
    }

    public ASMatrix translate(double d, double d2) {
        return new ASMatrix(this.a, this.b, this.c, this.d, this.x + d, this.y + d2);
    }

    public ASMatrix preMultiply(double d, double d2) {
        return new ASMatrix(this.a, this.b, this.c, this.d, this.x + this.a * d + this.c * d2, this.y + this.b * d + this.d * d2);
    }

    public ASMatrix setTranslate(double d, double d2) {
        return new ASMatrix(this.a, this.b, this.c, this.d, d, d2);
    }

    public ASMatrix setItalicDegrees(double d) {
        if (d == 0.0) {
            return this;
        }
        return new ASMatrix(this.a, this.b, Math.sin(d * Deg2Rad) * this.a + this.c, this.d, this.x, this.y);
    }

    public void mult(double d, double d2, double[] dArray) {
        dArray[0] = this.a * d + this.c * d2 + this.x;
        dArray[1] = this.b * d + this.d * d2 + this.y;
    }

    public ASMatrix concat(ASMatrix aSMatrix) {
        double d = this.a * aSMatrix.a + this.b * aSMatrix.c;
        double d2 = this.c * aSMatrix.a + this.d * aSMatrix.c;
        double d3 = this.x * aSMatrix.a + this.y * aSMatrix.c + aSMatrix.x;
        double d4 = this.a * aSMatrix.b + this.b * aSMatrix.d;
        double d5 = this.c * aSMatrix.b + this.d * aSMatrix.d;
        double d6 = this.x * aSMatrix.b + this.y * aSMatrix.d + aSMatrix.y;
        return new ASMatrix(d, d4, d2, d5, d3, d6);
    }

    public ASMatrix getInverse() {
        if (this.inverseTransform == null) {
            double d = 1.0 / (this.b * this.c - this.a * this.d);
            double d2 = -this.d * d;
            double d3 = this.b * d;
            double d4 = this.c * d;
            double d5 = -this.a * d;
            double d6 = -(this.x * d2 + this.y * d4);
            double d7 = -(this.x * d3 + this.y * d5);
            if (Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3) || Double.isNaN(d4) || Double.isInfinite(d4) || Double.isNaN(d5) || Double.isInfinite(d5) || Double.isNaN(d6) || Double.isInfinite(d6) || Double.isNaN(d7) || Double.isInfinite(d7)) {
                throw new ArithmeticException("Singular matrix passed to invert: " + this.a + " " + this.b + " " + this.c + " " + this.d + " " + this.x + " " + this.y);
            }
            this.inverseTransform = new ASMatrix(d2, d3, d4, d5, d6, d7);
            this.inverseTransform.inverseTransform = this;
        }
        return this.inverseTransform;
    }

    public String toString() {
        return "[ " + this.a + " " + this.b + " " + this.c + " " + this.d + " " + this.x + " " + this.y + " ]";
    }

    public Object clone() {
        return new ASMatrix(this);
    }
}

