/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.pdf.exceptions.PDFParseException;
import java.text.DecimalFormat;

public class ASDate {
    private int mYear;
    private int mMonth;
    private int mDay;
    private int mHour;
    private int mMinute;
    private int mSecond;
    private int mOffsetGMTHour;
    private int mOffsetGMTMinute;
    private ASString mDate;

    public ASDate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.mYear = n;
        this.mMonth = n2;
        this.mDay = n3;
        this.mHour = n4;
        this.mSecond = n6;
        this.mOffsetGMTHour = n7;
        this.mOffsetGMTMinute = n8;
        this.mDate = new ASString(this.makeString());
    }

    public ASDate(ASString aSString) {
        this.mDate = aSString;
        this.convert(aSString.getBytes());
    }

    public String asString() {
        return this.mDate.asString();
    }

    private ASDate convert(byte[] byArray) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (byArray[n9] == 68) {
            if (byArray[++n9] == 58) {
                ++n9;
            } else {
                throw new PDFParseException("Bad Date format");
            }
        }
        n = ASDate.readYear(byArray, n9);
        if ((n9 += 4) < byArray.length && ByteOps.isDigit(byArray[n9])) {
            n2 = ByteOps.readField(byArray, n9);
            if ((n9 += 2) < byArray.length && ByteOps.isDigit(byArray[n9])) {
                n3 = ByteOps.readField(byArray, n9);
                if ((n9 += 2) < byArray.length && ByteOps.isDigit(byArray[n9])) {
                    n4 = ByteOps.readField(byArray, n9);
                    if ((n9 += 2) < byArray.length && ByteOps.isDigit(byArray[n9])) {
                        n5 = ByteOps.readField(byArray, n9);
                        if ((n9 += 2) < byArray.length && ByteOps.isDigit(byArray[n9])) {
                            n6 = ByteOps.readField(byArray, n9);
                            n9 += 2;
                        }
                    }
                }
            }
        }
        if (n9 < byArray.length) {
            int n10 = 1;
            if (byArray[n9] == 45) {
                n10 = -1;
            }
            if (++n9 + 3 < byArray.length) {
                n7 = ByteOps.readField(byArray, n9);
                if (byArray[n9 + 2] != 39) {
                    throw new PDFParseException("Bad Date format at " + n9 + 2);
                }
                if (n9 + 5 < byArray.length) {
                    n8 = ByteOps.readField(byArray, n9 + 3);
                    if (byArray[n9 + 5] != 39) {
                        throw new PDFParseException("Bad Date format at " + n9 + 6);
                    }
                }
            }
        }
        return new ASDate(n, n2, n3, n4, n5, n6, n7, n8);
    }

    private static int readYear(byte[] byArray, int n) {
        return ByteOps.readField(byArray, n) * 100 + ByteOps.readField(byArray, n + 2);
    }

    private String formatInt(int n) {
        if (n < 10) {
            DecimalFormat decimalFormat = new DecimalFormat("#");
            return "0" + new String(decimalFormat.format(this.mDay));
        }
        DecimalFormat decimalFormat = new DecimalFormat("##");
        return new String(decimalFormat.format(this.mDay));
    }

    private String makeString() {
        String string = "D:";
        DecimalFormat decimalFormat = new DecimalFormat("####");
        string = string + new String(decimalFormat.format(this.mYear));
        string = string + this.formatInt(this.mDay);
        string = string + this.formatInt(this.mMonth);
        string = string + this.formatInt(this.mMinute);
        string = string + this.formatInt(this.mSecond);
        if (this.mOffsetGMTHour == 0 && this.mOffsetGMTMinute == 0) {
            string = string + "Z00'00'";
            return string;
        }
        string = this.mOffsetGMTHour < 0 ? string + "-" + this.formatInt(-this.mOffsetGMTHour) : string + "+" + this.formatInt(this.mOffsetGMTHour);
        string = string + "'" + this.formatInt(this.mOffsetGMTMinute) + "'";
        return string;
    }
}

