/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos.util;

import com.adobe.internal.pdf.cos.util.ASMatrix;
import com.adobe.pdf.Point;

public class ASCoordinate
implements Point {
    private double x;
    private double y;

    public ASCoordinate(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public ASCoordinate(ASCoordinate aSCoordinate) {
        this.x = aSCoordinate.x();
        this.y = aSCoordinate.y();
    }

    public ASCoordinate translate(double d, double d2) {
        return new ASCoordinate(this.x + d, this.y + d2);
    }

    public ASCoordinate transform(ASMatrix aSMatrix) {
        ASMatrix aSMatrix2 = aSMatrix.preMultiply(this.x, this.y);
        return new ASCoordinate(aSMatrix2.getx(), aSMatrix2.gety());
    }

    public double distanceTo(ASCoordinate aSCoordinate) {
        double d = aSCoordinate.x - this.x;
        double d2 = aSCoordinate.y - this.y;
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
    }

    public double angleTo(ASCoordinate aSCoordinate) {
        double d = aSCoordinate.x - this.x;
        double d2 = aSCoordinate.y - this.y;
        double d3 = Math.atan2(d, d2);
        return d3;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }
}

