/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosObjectStream;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosToken;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.pdf.exceptions.PDFParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class XRefTable {
    static final int tTable = 0;
    static final int tStream = 1;
    static final int tHybrid = 2;
    private int mXrefType;
    private ByteStream mBuf;
    private CosDocument mDoc;
    private List mXRefSubSections;
    private CosDictionary mTrailer;

    XRefTable(CosDocument cosDocument, ByteStream byteStream) {
        this.mBuf = byteStream;
        this.mDoc = cosDocument;
        this.mXRefSubSections = new ArrayList();
        int n = this.getLastXRefSectionPosition();
        this.mBuf.setPosition(n);
        byte by = CosToken.skipWhitespace(this.mBuf);
        this.mBuf.unget();
        if (by == 120) {
            this.mXrefType = 0;
            this.ParseTableXrefChain(n);
        } else if (ByteOps.isDigit(by)) {
            this.mXrefType = 1;
            this.ParseStreamXrefChain(n);
        } else {
            throw new PDFParseException("could not find xref section");
        }
    }

    private void ParseTableXrefChain(long l) {
        CosDictionary cosDictionary;
        CosNumeric cosNumeric;
        do {
            CosNumeric cosNumeric2;
            this.mBuf.setPosition(l);
            byte by = this.readTableXRefTable();
            cosDictionary = this.readTrailer(by);
            if (this.mTrailer == null) {
                this.mTrailer = cosDictionary;
            }
            if ((cosNumeric2 = (CosNumeric)cosDictionary.get(ASName.k_XRefStm)) == null) continue;
            this.readStreamXRefTable(cosNumeric2.intValue());
            this.mXrefType = 2;
        } while ((l = (cosNumeric = (CosNumeric)cosDictionary.get(ASName.k_Prev)) != null ? (long)cosNumeric.intValue() : 0L) != 0L);
    }

    private byte readTableXRefTable() {
        CosToken.skipWhitespace(this.mBuf);
        this.mBuf.unget();
        if (!CosToken.readLine(this.mBuf).equals("xref")) {
            throw new PDFParseException(this.mBuf.getPosition());
        }
        byte by = this.mBuf.get();
        while (ByteOps.isDigit(by)) {
            this.mXRefSubSections.add(new TableXRefSubSection(by));
            by = CosToken.skipWhitespace(this.mBuf);
        }
        return by;
    }

    CosDictionary getTrailer() {
        return this.mTrailer;
    }

    ByteStream getObjectBytes(CosObjectID cosObjectID) {
        int n = cosObjectID.getObjNum();
        int n2 = cosObjectID.getGeneration();
        Iterator iterator = this.mXRefSubSections.iterator();
        ByteStream byteStream = null;
        while (iterator.hasNext() && byteStream == null) {
            XRefSubSection xRefSubSection = (XRefSubSection)iterator.next();
            int n3 = xRefSubSection.getBegin();
            if (n3 > n || n >= xRefSubSection.getEnd() || xRefSubSection.getXRefGeneration(n - n3) != n2) continue;
            byteStream = xRefSubSection.getXRefBytes(n - n3, cosObjectID);
        }
        return byteStream;
    }

    private CosDictionary readTrailer(byte by) {
        if (by != 116 || this.mBuf.get() != 114 || this.mBuf.get() != 97 || this.mBuf.get() != 105 || this.mBuf.get() != 108 || this.mBuf.get() != 101 || this.mBuf.get() != 114) {
            throw new PDFParseException(this.mBuf.getPosition() - 1L);
        }
        CosDictionary cosDictionary = (CosDictionary)CosToken.readObject(this.mDoc, this.mBuf, CosObjectID.NULL);
        return cosDictionary;
    }

    int getLastXRefSectionPosition() {
        byte by;
        long l = this.getEOFPosition();
        do {
            this.mBuf.setPosition(--l);
        } while (!ByteOps.isDigit(by = this.mBuf.get()));
        int n = 0;
        int n2 = 1;
        do {
            n += ((char)by - 48) * n2;
            n2 *= 10;
            this.mBuf.setPosition(--l);
        } while (ByteOps.isDigit(by = this.mBuf.get()));
        return n;
    }

    private long getEOFPosition() {
        long l = this.mBuf.limit();
        int n = 4;
        while (n != -1) {
            if (--l < 0L) {
                throw new PDFParseException("could not find %%EOF");
            }
            this.mBuf.setPosition(l);
            byte by = this.mBuf.get();
            if ("%%EOF".charAt(n) == by) {
                --n;
                continue;
            }
            if (by == 70) {
                n = 3;
                continue;
            }
            n = 4;
        }
        return l;
    }

    private void ParseStreamXrefChain(long l) {
        CosStream cosStream;
        CosNumeric cosNumeric;
        do {
            cosStream = this.readStreamXRefTable(l);
            if (this.mTrailer != null) continue;
            this.mTrailer = cosStream;
        } while ((l = (cosNumeric = (CosNumeric)cosStream.get(ASName.k_Prev)) != null ? (long)cosNumeric.intValue() : 0L) != 0L);
    }

    private CosStream readStreamXRefTable(long l) {
        int n;
        ByteStream byteStream = new ByteStream(this.mBuf, l);
        CosObjectID cosObjectID = CosToken.readObjID(byteStream, CosToken.skipWhitespace(byteStream));
        CosObject cosObject = CosToken.readIndirectObject(this.mDoc, byteStream, cosObjectID);
        this.mDoc.cacheObject(cosObjectID, cosObject);
        if (!(cosObject instanceof CosStream)) {
            throw new PDFParseException(l);
        }
        CosStream cosStream = (CosStream)cosObject;
        CosObject cosObject2 = cosStream.get(ASName.k_Type);
        if (cosObject2 == null || !(cosObject2 instanceof CosName) || !((CosName)cosObject2).nameValue().equals(ASName.k_XRef)) {
            throw new PDFParseException(l);
        }
        CosObject cosObject3 = cosStream.get(ASName.k_Index);
        CosObject cosObject4 = cosStream.get(ASName.k_W);
        if (!(cosObject4 instanceof CosArray) || ((CosArray)cosObject4).size() != 3) {
            throw new PDFParseException(l);
        }
        CosArray cosArray = (CosArray)cosObject4;
        int[] nArray = new int[3];
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            nArray[n] = ((CosNumeric)cosArray.get(n)).intValue();
            n2 += nArray[n];
        }
        if (cosObject3 == null) {
            n = ((CosNumeric)cosStream.get(ASName.k_Size)).intValue();
            this.mXRefSubSections.add(new StreamXRefSubSection(0, n, cosStream, 0L, nArray, n2));
        } else {
            if (!(cosObject3 instanceof CosArray)) {
                throw new PDFParseException(l);
            }
            CosArray cosArray2 = (CosArray)cosObject3;
            long l2 = 0L;
            for (int i = 0; i < cosArray2.size(); i += 2) {
                int n3 = ((CosNumeric)cosArray2.get(i)).intValue();
                int n4 = ((CosNumeric)cosArray2.get(i + 1)).intValue();
                this.mXRefSubSections.add(new StreamXRefSubSection(n3, n4, cosStream, l2, nArray, n2));
                l2 += (long)(n4 * n2);
            }
        }
        return cosStream;
    }

    private static int readInt(ByteStream byteStream, byte by) {
        int n = 1;
        if (by == 43) {
            n = 1;
            by = byteStream.get();
        }
        if (!ByteOps.isDigit(by)) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        int n2 = 0;
        while (ByteOps.isDigit(by)) {
            n2 += by - 48;
            n2 *= 10;
            by = byteStream.get();
        }
        n2 /= 10;
        byteStream.unget();
        return n2 *= n;
    }

    int getType() {
        return this.mXrefType;
    }

    class StreamXRefSubSection
    extends XRefSubSection {
        long mXrefPos;
        CosStream mXStm;
        int[] mW;
        int mTotalW;

        StreamXRefSubSection(int n, int n2, CosStream cosStream, long l, int[] nArray, int n3) {
            this.mBegin = n;
            this.mEnd = n + n2;
            this.mXStm = cosStream;
            this.mXrefPos = l;
            this.mW = nArray;
            this.mTotalW = n3;
        }

        private long getNumberFromStream(ByteStream byteStream, int n) {
            long l = 0L;
            while (n > 0) {
                l = 256L * l;
                int n2 = byteStream.get();
                if (n2 < 0) {
                    n2 += 256;
                }
                l += (long)n2;
                --n;
            }
            return l;
        }

        final int getXRefGeneration(int n) {
            int n2;
            if (this.mW[2] == 0) {
                n2 = 0;
            } else {
                long l = this.mXrefPos + (long)(n * this.mTotalW);
                ByteStream byteStream = new ByteStream(this.mXStm.getStream(), l);
                long l2 = this.getNumberFromStream(byteStream, this.mW[0]);
                if (l2 == 2L) {
                    n2 = 0;
                } else {
                    byteStream.setPosition(l + (long)this.mW[0] + (long)this.mW[1]);
                    n2 = (int)this.getNumberFromStream(byteStream, this.mW[2]);
                }
            }
            return n2;
        }

        final ByteStream getXRefBytes(int n, CosObjectID cosObjectID) {
            ByteStream byteStream;
            long l = this.mXrefPos + (long)(n * this.mTotalW);
            ByteStream byteStream2 = new ByteStream(this.mXStm.getStream(), l);
            long l2 = this.getNumberFromStream(byteStream2, this.mW[0]);
            if (l2 == 1L) {
                long l3 = this.getNumberFromStream(byteStream2, this.mW[1]);
                byteStream = new ByteStream(XRefTable.this.mBuf, l3);
                CosObjectID cosObjectID2 = CosToken.readObjID(byteStream, CosToken.skipWhitespace(byteStream));
                if (!cosObjectID2.equals(cosObjectID)) {
                    throw new PDFParseException(l3);
                }
            } else if (l2 == 2L) {
                CosObjectStream cosObjectStream;
                int n2 = (int)this.getNumberFromStream(byteStream2, this.mW[1]);
                CosObjectID cosObjectID3 = new CosObjectID(n2, 0);
                CosObject cosObject = XRefTable.this.mDoc.getObject(cosObjectID3);
                if (cosObject == null || !(cosObject instanceof CosStream)) {
                    throw new PDFParseException(l);
                }
                if (cosObject instanceof CosObjectStream) {
                    cosObjectStream = (CosObjectStream)cosObject;
                } else {
                    cosObjectStream = new CosObjectStream((CosStream)cosObject);
                    XRefTable.this.mDoc.cacheObject(cosObjectID3, cosObjectStream);
                }
                int n3 = (int)this.getNumberFromStream(byteStream2, this.mW[2]);
                byteStream = cosObjectStream.getBytesForObject(n3, cosObjectID.getObjNum());
            } else {
                throw new PDFParseException(l);
            }
            return byteStream;
        }

        final boolean getXRefUsed(int n) {
            long l = this.mXrefPos + (long)(n * this.mTotalW);
            ByteStream byteStream = new ByteStream(this.mXStm.getStream(), l);
            long l2 = this.getNumberFromStream(byteStream, this.mW[0]);
            return l2 != 0L;
        }
    }

    private class TableXRefSubSection
    extends XRefSubSection {
        private static final int ENTRY_SIZE = 20;
        private static final int ENTRY_OFFSET_OFFSET = 0;
        private static final int ENTRY_GENERATION_OFFSET = 11;
        private static final int ENTRY_IN_USE_OFFSET = 17;
        private long mXRefPos;

        TableXRefSubSection(byte by) {
            this.mBegin = XRefTable.readInt(XRefTable.this.mBuf, by);
            by = CosToken.skipWhitespace(XRefTable.this.mBuf);
            this.mEnd = this.mBegin + XRefTable.readInt(XRefTable.this.mBuf, by);
            by = CosToken.skipWhitespace(XRefTable.this.mBuf);
            this.mXRefPos = XRefTable.this.mBuf.getPosition() - 1L;
            XRefTable.this.mBuf.setPosition(this.mXRefPos + (long)(20 * (this.mEnd - this.mBegin)));
        }

        final ByteStream getXRefBytes(int n, CosObjectID cosObjectID) {
            ByteStream byteStream = new ByteStream(XRefTable.this.mBuf, this.mXRefPos + (long)(20 * n) + 0L);
            long l = 0L;
            l = XRefTable.readInt(byteStream, byteStream.get());
            byteStream.setPosition(l);
            CosObjectID cosObjectID2 = CosToken.readObjID(byteStream, CosToken.skipWhitespace(byteStream));
            if (!cosObjectID2.equals(cosObjectID)) {
                throw new PDFParseException(byteStream.getPosition() - 1L);
            }
            return byteStream;
        }

        final int getXRefGeneration(int n) {
            ByteStream byteStream = new ByteStream(XRefTable.this.mBuf, this.mXRefPos + (long)(20 * n) + 11L);
            int n2 = XRefTable.readInt(byteStream, byteStream.get());
            return n2;
        }

        final boolean getXRefUsed(int n) {
            ByteStream byteStream = new ByteStream(XRefTable.this.mBuf, this.mXRefPos + (long)(20 * n) + 17L);
            return byteStream.get() == 110;
        }

        public String toString() {
            return "TableXRefSubSection (base=" + this.mBegin + " end=" + this.mEnd + ")";
        }
    }

    private abstract class XRefSubSection {
        int mBegin;
        int mEnd;

        private XRefSubSection() {
        }

        final int getBegin() {
            return this.mBegin;
        }

        final int getEnd() {
            return this.mEnd;
        }

        abstract ByteStream getXRefBytes(int var1, CosObjectID var2);

        abstract int getXRefGeneration(int var1);

        abstract boolean getXRefUsed(int var1);
    }
}

