/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosWriterXRefSort;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.QSort;
import java.io.IOException;
import java.io.OutputStream;

class CosWriter {
    CosWriter() {
    }

    static void write(long l, OutputStream outputStream) throws IOException {
        CosWriter.write(Long.toString(l), outputStream);
    }

    static void write(long l, int n, OutputStream outputStream) throws IOException {
        int n2;
        char[] cArray = Long.toString(l).toCharArray();
        byte[] byArray = new byte[n];
        int n3 = Math.max(n - cArray.length, 0);
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = 48;
        }
        while (n2 < byArray.length) {
            byArray[n2] = (byte)cArray[n2 - n3];
            ++n2;
        }
        outputStream.write(byArray);
    }

    static void write(int n, OutputStream outputStream) throws IOException {
        CosWriter.write(Integer.toString(n), outputStream);
    }

    static void write(int n, int n2, OutputStream outputStream) throws IOException {
        int n3;
        char[] cArray = Integer.toString(n).toCharArray();
        byte[] byArray = new byte[n2];
        int n4 = Math.max(n2 - cArray.length, 0);
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n3] = 48;
        }
        while (n3 < byArray.length) {
            byArray[n3] = (byte)cArray[n3 - n4];
            ++n3;
        }
        outputStream.write(byArray);
    }

    static void write(String string, OutputStream outputStream) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        outputStream.write(byArray);
    }

    static void write(char c, OutputStream outputStream) throws IOException {
        outputStream.write(c);
    }

    static void writeIndirectObject(CosObject cosObject, OutputStream outputStream) throws IOException {
        CosWriter.write(cosObject.getID().getObjNum(), outputStream);
        CosWriter.write(" ", outputStream);
        CosWriter.write(cosObject.getID().getGeneration(), outputStream);
        CosWriter.write(" obj ", outputStream);
        cosObject.write(outputStream);
        CosWriter.write(" endobj\n", outputStream);
    }

    static void writeTableXRef(CosObjectID[] cosObjectIDArray, OutputStream outputStream) throws IOException {
        int n;
        CosWriter.write("xref\n", outputStream);
        QSort.sort(cosObjectIDArray, new CosWriterXRefSort());
        for (int i = 0; i < cosObjectIDArray.length; i += n) {
            int n2 = cosObjectIDArray[i].getObjNum();
            n = 0;
            while (i + n < cosObjectIDArray.length && n2 + n == cosObjectIDArray[i + n].getObjNum()) {
                ++n;
            }
            CosWriter.write(n2, outputStream);
            CosWriter.write(' ', outputStream);
            CosWriter.write(n, outputStream);
            CosWriter.write(' ', outputStream);
            CosWriter.write('\n', outputStream);
            for (int j = i; j < i + n; ++j) {
                CosWriter.write(cosObjectIDArray[j].getPos(), 10, outputStream);
                CosWriter.write(' ', outputStream);
                CosWriter.write(cosObjectIDArray[j].getGeneration(), 5, outputStream);
                CosWriter.write(" n \n", outputStream);
            }
        }
    }

    static void writeStreamXRef(CosObjectID[] cosObjectIDArray, OutputStream outputStream, CosStream cosStream) throws IOException {
        int n;
        int n2;
        QSort.sort(cosObjectIDArray, new CosWriterXRefSort());
        CosDocument cosDocument = cosStream.getDocument();
        long l = 0L;
        int n3 = 0;
        CosArray cosArray = cosDocument.newArray();
        for (int i = 0; i < cosObjectIDArray.length; i += n2) {
            int n4 = cosObjectIDArray[i].getObjNum();
            n2 = 0;
            while (i + n2 < cosObjectIDArray.length && n4 + n2 == cosObjectIDArray[i + n2].getObjNum()) {
                int n5;
                CosObjectID cosObjectID = cosObjectIDArray[i + n2];
                long l2 = cosObjectID.getPos();
                if (l2 > l) {
                    l = l2;
                }
                if ((n5 = cosObjectID.getGeneration()) > n3) {
                    n3 = n5;
                }
                ++n2;
            }
            cosArray.add(cosDocument.newNumeric(n4));
            cosArray.add(cosDocument.newNumeric(n2));
        }
        cosStream.put(ASName.k_Index, cosArray);
        CosArray cosArray2 = cosDocument.newArray();
        cosArray2.add(cosDocument.newNumeric(1));
        long l3 = 256L;
        for (n = 1; n < 8 && l >= l3; ++n, l3 <<= 8) {
        }
        cosArray2.add(cosDocument.newNumeric(n));
        int n6 = 0;
        if (n3 > 0) {
            n6 = 1;
            for (l3 = 256L; n6 < 4 && (long)n3 >= l3; ++n6, l3 <<= 8) {
            }
        }
        cosArray2.add(cosDocument.newNumeric(n6));
        cosStream.put(ASName.k_W, cosArray2);
        OutputStream outputStream2 = cosStream.newData();
        for (int i = 0; i < cosObjectIDArray.length; ++i) {
            CosWriter.writeNumberToStream(outputStream2, 1L, 1);
            CosObjectID cosObjectID = cosObjectIDArray[i];
            CosWriter.writeNumberToStream(outputStream2, cosObjectID.getPos(), n);
            if (n6 <= 0) continue;
            CosWriter.writeNumberToStream(outputStream2, cosObjectID.getGeneration(), n6);
        }
        outputStream2.close();
        CosWriter.writeIndirectObject(cosStream, outputStream);
    }

    private static void writeNumberToStream(OutputStream outputStream, long l, int n) throws IOException {
        if (n > 1) {
            CosWriter.writeNumberToStream(outputStream, l >> 8, n - 1);
        }
        outputStream.write((byte)l & 0xFF);
    }

    static void writeTrailer(CosObject cosObject, OutputStream outputStream) throws IOException {
        CosWriter.write("trailer\n", outputStream);
        cosObject.write(outputStream);
        CosWriter.write("\n", outputStream);
    }

    static void writeEOF(long l, OutputStream outputStream) throws IOException {
        CosWriter.write("startxref\n", outputStream);
        CosWriter.write(l, outputStream);
        CosWriter.write("\n%%EOF\n", outputStream);
    }
}

