/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.ByteArrayUtility;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosBoolean;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNull;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosObjectRef;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.CleanByteRepository;
import com.adobe.pdf.exceptions.PDFParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CosToken {
    private static byte[] sReadBuffer = new byte[128];
    public static final int RSLT_END = -1;
    public static final int RSLT_NUMBER = 0;
    public static final int RSLT_OPERATOR = 1;
    public static final int RSLT_OBJECT = 2;

    static CosObjectID readObjID(ByteStream byteStream, byte by) {
        int n = CosToken.readNumber(byteStream, by).intValue();
        int n2 = CosToken.readNumber(byteStream, CosToken.skipWhitespace(byteStream)).intValue();
        if (CosToken.skipWhitespace(byteStream) != 111 || byteStream.get() != 98 || byteStream.get() != 106) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return new CosObjectID(n, n2);
    }

    static CosObject readIndirectObject(CosDocument cosDocument, ByteStream byteStream, CosObjectID cosObjectID) {
        byte by;
        CosObject cosObject = CosToken.readObject(cosDocument, byteStream, cosObjectID);
        if (!byteStream.eof() && (by = CosToken.skipWhitespace(byteStream)) == 115) {
            if (byteStream.get() != 116 || byteStream.get() != 114 || byteStream.get() != 101 || byteStream.get() != 97 || byteStream.get() != 109) {
                throw new PDFParseException(byteStream.getPosition() - 1L);
            }
            by = byteStream.get();
            if (by == 13) {
                by = byteStream.get();
                if (by != 10) {
                    byteStream.unget();
                }
            } else if (by != 10) {
                byteStream.unget();
            }
            cosObject = new CosStream((CosDictionary)cosObject, byteStream.getPosition());
        }
        return cosObject;
    }

    static CosObject readObject(CosDocument cosDocument, ByteStream byteStream, CosObjectID cosObjectID) {
        return CosToken.readObject(cosDocument, byteStream, CosToken.skipWhitespace(byteStream), cosObjectID);
    }

    static ArrayList readArray(CosDocument cosDocument, ByteStream byteStream, CosObjectID cosObjectID) {
        return CosToken.readObjectList(cosDocument, byteStream, (byte)93, cosObjectID);
    }

    static Map readDictionary(CosDocument cosDocument, ByteStream byteStream, CosObjectID cosObjectID) {
        ArrayList arrayList = CosToken.readObjectList(cosDocument, byteStream, (byte)62, cosObjectID);
        byte by = byteStream.get();
        if (by != 62) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ASName aSName = ((CosName)iterator.next()).nameValue();
            Object e = iterator.next();
            if (e instanceof CosNull) continue;
            hashMap.put(aSName, e);
        }
        return hashMap;
    }

    static byte readHexDigit(ByteStream byteStream) {
        return CosToken.toHexDigit(byteStream.get());
    }

    static byte[] readHexString(ByteStream byteStream) {
        ByteBuffer byteBuffer = new ByteBuffer(new CleanByteRepository());
        byte by = byteStream.get();
        while (by != 62) {
            if (!ByteOps.isWhitespace(by)) {
                byte by2 = CosToken.toHexDigit(by);
                byte by3 = CosToken.toHexDigit(byteStream.get());
                byteBuffer.appendByte((byte)(by2 * 16 + by3));
            }
            by = byteStream.get();
        }
        long l = byteBuffer.getLength();
        byte[] byArray = new byte[(int)l];
        byteBuffer.getBytes(0L, l, byArray);
        return byArray;
    }

    public static byte toHexDigit(byte by) {
        int n = 0;
        if (by >= 48 && by <= 57) {
            n = by - 48;
        } else if (by >= 65 && by <= 70) {
            n = by - 65 + 10;
        } else if (by >= 97 && by <= 102) {
            n = by - 97 + 10;
        } else {
            throw new PDFParseException("byte not a HexDigit");
        }
        return (byte)n;
    }

    static ASName readName(ByteStream byteStream) {
        int n = 0;
        int n2 = byteStream.get();
        while (ByteOps.isRegular((byte)n2)) {
            if (n2 == 35) {
                n2 = CosToken.readHexDigit(byteStream) * 16 + CosToken.readHexDigit(byteStream);
            }
            CosToken.sReadBuffer[n++] = (byte)n2;
            n2 = byteStream.get();
        }
        byteStream.unget();
        return ASName.getName(sReadBuffer, 0, n);
    }

    public static Number readNumber(ByteStream byteStream, byte by) {
        int n = 1;
        long l = 0L;
        long l2 = 0L;
        long l3 = 1L;
        boolean bl = false;
        if (by == 45) {
            n = -1;
            by = byteStream.get();
        }
        if (by == 43) {
            n = 1;
            by = byteStream.get();
        }
        while (ByteOps.isDigit(by)) {
            l *= 10L;
            l += (long)(by - 48);
            by = byteStream.get();
        }
        if (by == 46) {
            bl = true;
            by = byteStream.get();
            while (ByteOps.isDigit(by)) {
                l2 *= 10L;
                l2 += (long)(by - 48);
                l3 *= 10L;
                by = byteStream.get();
            }
        }
        Number number = !bl ? (Number)(l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? (Number)new Integer((int)l * n) : (Number)new Long(l * (long)n)) : (Number)new Double(((double)l + (double)l2 / (double)l3) * (double)n);
        if (ByteOps.isRegular(by)) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        byteStream.unget();
        return number;
    }

    static String readLine(ByteStream byteStream) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = byteStream.get();
        while (by != 13 && by != 10) {
            stringBuffer.append((char)by);
            by = byteStream.get();
        }
        if (by == 13 && !byteStream.eof() && byteStream.get() != 10) {
            byteStream.unget();
        }
        return stringBuffer.toString();
    }

    public static byte skipWhitespace(ByteStream byteStream) {
        byte by = 32;
        while (ByteOps.isWhitespace(by) && !byteStream.eof()) {
            by = byteStream.get();
            if (by != 37) continue;
            while (by != 13 && by != 10 && !byteStream.eof()) {
                by = byteStream.get();
            }
        }
        return by;
    }

    private static CosObject readObject(CosDocument cosDocument, ByteStream byteStream, byte by, CosObjectID cosObjectID) {
        CosObject cosObject = null;
        if (ByteOps.isDigit(by) || by == 43 || by == 45 || by == 46) {
            long l = byteStream.getPosition() - 1L;
            cosObject = new CosNumeric(cosDocument, CosToken.readNumber(byteStream, by), cosObjectID);
            int n = (int)(byteStream.getPosition() - l);
            byte[] byArray = new byte[n];
            byteStream.getByteBuffer().getBytes(l, n, byArray);
            cosObject.setInputRep(byArray);
        } else if (by == 82) {
            cosObject = new CosObjectRef(cosDocument, cosObjectID);
        } else if (by == 47) {
            cosObject = new CosName(cosDocument, CosToken.readName(byteStream), cosObjectID);
        } else if (by == 40) {
            byte[] byArray = ByteArrayUtility.readLiteral(byteStream);
            cosObject = new CosString(cosDocument, byArray, 0, byArray.length, true, cosObjectID);
        } else if (by == 60) {
            by = byteStream.get();
            if (by == 60) {
                cosObject = new CosDictionary(cosDocument, CosToken.readDictionary(cosDocument, byteStream, cosObjectID), cosObjectID);
            } else {
                byteStream.unget();
                byte[] byArray = CosToken.readHexString(byteStream);
                cosObject = new CosString(cosDocument, byArray, 0, byArray.length, true, cosObjectID, true);
            }
        } else if (by == 91) {
            cosObject = new CosArray(cosDocument, CosToken.readArray(cosDocument, byteStream, cosObjectID), cosObjectID);
        } else if (by == 116) {
            cosObject = new CosBoolean(cosDocument, CosToken.readTrue(byteStream), cosObjectID);
        } else if (by == 102) {
            cosObject = new CosBoolean(cosDocument, CosToken.readFalse(byteStream), cosObjectID);
        } else if (by == 110) {
            CosToken.readNull(byteStream);
            cosObject = new CosNull(cosDocument, cosObjectID);
        } else {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return cosObject;
    }

    private static ArrayList readObjectList(CosDocument cosDocument, ByteStream byteStream, byte by, CosObjectID cosObjectID) {
        ArrayList<CosObject> arrayList = new ArrayList<CosObject>();
        byte by2 = CosToken.skipWhitespace(byteStream);
        while (by2 != by) {
            CosObject cosObject = CosToken.readObject(cosDocument, byteStream, by2, cosObjectID);
            if (cosObject != null && cosObject instanceof CosObjectRef) {
                int n = ((CosNumeric)arrayList.remove(arrayList.size() - 1)).intValue();
                int n2 = ((CosNumeric)arrayList.remove(arrayList.size() - 1)).intValue();
                CosObjectID cosObjectID2 = new CosObjectID(n2, n);
                ((CosObjectRef)cosObject).initialize(cosObjectID2);
            }
            arrayList.add(cosObject);
            by2 = CosToken.skipWhitespace(byteStream);
        }
        return arrayList;
    }

    private static Boolean readTrue(ByteStream byteStream) {
        if (byteStream.get() != 114) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 117) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 101) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return Boolean.TRUE;
    }

    private static Boolean readFalse(ByteStream byteStream) {
        if (byteStream.get() != 97) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 108) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 115) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 101) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return Boolean.FALSE;
    }

    private static Boolean readNull(ByteStream byteStream) {
        if (byteStream.get() != 117) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 108) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        if (byteStream.get() != 108) {
            throw new PDFParseException(byteStream.getPosition() - 1L);
        }
        return null;
    }

    public static int readContentStreamObject(CosDocument cosDocument, ByteStream byteStream, RefNumber refNumber, RefOperator refOperator, RefObject refObject) {
        CosObjectID cosObjectID = CosObjectID.NULL;
        int n = -1;
        byte by = CosToken.skipWhitespace(byteStream);
        if (!byteStream.eof()) {
            if (ByteOps.isDigit(by) || by == 43 || by == 45 || by == 46) {
                refNumber.mData = CosToken.readNumber(byteStream, by);
                n = 0;
            } else if (by == 47) {
                refObject.mData = new CosName(cosDocument, CosToken.readName(byteStream), cosObjectID);
                n = 2;
            } else if (by == 40) {
                refObject.mData = ByteArrayUtility.readLiteral(cosDocument, cosObjectID, byteStream);
                n = 2;
            } else if (by != 60 && by != 91) {
                byteStream.unget();
                ASName aSName = CosToken.readName(byteStream);
                if (aSName == ASName.k_true) {
                    refObject.mData = new CosBoolean(cosDocument, true, cosObjectID);
                    n = 2;
                } else if (aSName == ASName.k_false) {
                    refObject.mData = new CosBoolean(cosDocument, false, cosObjectID);
                    n = 2;
                } else if (aSName == ASName.k_null) {
                    refObject.mData = new CosNull(cosDocument, cosObjectID);
                    n = 2;
                } else {
                    refOperator.mData = aSName;
                    n = 1;
                }
            } else if (by == 60) {
                by = byteStream.get();
                if (by == 60) {
                    refObject.mData = new CosDictionary(cosDocument, CosToken.readDictionary(cosDocument, byteStream, cosObjectID), cosObjectID);
                } else {
                    byteStream.unget();
                    byte[] byArray = ByteArrayUtility.readHex(byteStream);
                    refObject.mData = new CosString(cosDocument, byArray, 0, byArray.length, true, cosObjectID, true);
                }
                n = 2;
            } else if (by == 91) {
                refObject.mData = new CosArray(cosDocument, CosToken.readArray(cosDocument, byteStream, cosObjectID), cosObjectID);
                n = 2;
            } else {
                throw new PDFParseException(byteStream.getPosition());
            }
        }
        return n;
    }

    public static class RefObject {
        public CosObject mData;
    }

    public static class RefOperator {
        public ASName mData;
    }

    public static class RefNumber {
        public Number mData;
    }
}

