/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.util.ASDate;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.exceptions.PDFEncodingException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class CosString
extends CosObject {
    private static byte[] hexrep = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private byte[] mValue;
    private boolean mIsEncrypted;
    private byte[] mBase;
    private int mBegin;
    private int mLength;
    private boolean mWriteHex;

    private void init(CosDocument cosDocument, byte[] byArray, int n, int n2, boolean bl, CosObjectID cosObjectID, boolean bl2) {
        this.mValue = null;
        this.mBase = byArray;
        this.mBegin = n;
        this.mLength = n2;
        this.mIsEncrypted = bl;
        this.mWriteHex = bl2;
    }

    CosString(CosDocument cosDocument, byte[] byArray, int n, int n2, boolean bl, CosObjectID cosObjectID, boolean bl2) {
        super(cosDocument, cosObjectID);
        this.init(cosDocument, byArray, n, n2, bl, cosObjectID, bl2);
    }

    CosString(CosDocument cosDocument, byte[] byArray, int n, int n2, boolean bl, CosObjectID cosObjectID) {
        super(cosDocument, cosObjectID);
        this.init(cosDocument, byArray, n, n2, bl, cosObjectID, false);
    }

    public CosObject clone(CosDocument cosDocument) {
        return cosDocument.newString(this.byteArrayValue());
    }

    public boolean equivalent(CosObject cosObject) {
        if (!this.baseEquivalence(cosObject)) {
            return false;
        }
        ASString aSString = ((CosString)cosObject).stringValue();
        return this.stringValue().compareTo(aSString) == 0;
    }

    public int getType() {
        return 4;
    }

    public boolean isContainer() {
        return false;
    }

    private void initValue() {
        if (this.mBegin == 0 && this.mLength == this.mBase.length) {
            this.mValue = this.mBase;
        } else {
            this.mValue = new byte[this.mLength];
            System.arraycopy(this.mBase, this.mBegin, this.mValue, 0, this.mLength);
        }
        this.mBase = null;
    }

    public byte[] byteArrayValue() {
        if (this.mValue == null) {
            this.initValue();
        }
        return this.mValue;
    }

    public ASString stringValue() {
        return new ASString(this.byteArrayValue());
    }

    public String toString() {
        return this.stringValue().asString();
    }

    public String textValue() {
        String string = "";
        byte[] byArray = this.byteArrayValue();
        boolean bl = byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1;
        try {
            string = new String(byArray, bl ? "UTF16" : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PDFEncodingException("Can not convert byte array to String");
        }
        return string;
    }

    void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, this.mWriteHex);
    }

    void write(OutputStream outputStream, boolean bl) throws IOException {
        byte[] byArray = this.byteArrayValue();
        if (bl) {
            outputStream.write(60);
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                outputStream.write(hexrep[by >> 4 & 0xF]);
                outputStream.write(hexrep[by & 0xF]);
            }
            outputStream.write(62);
        } else {
            outputStream.write(40);
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                if (by == 10) {
                    outputStream.write(92);
                    outputStream.write(110);
                    continue;
                }
                if (by == 13) {
                    outputStream.write(92);
                    outputStream.write(114);
                    continue;
                }
                if (by == 40) {
                    outputStream.write(92);
                    outputStream.write(40);
                    continue;
                }
                if (by == 41) {
                    outputStream.write(92);
                    outputStream.write(41);
                    continue;
                }
                if (by == 92) {
                    outputStream.write(92);
                    outputStream.write(92);
                    continue;
                }
                outputStream.write(by);
            }
            outputStream.write(41);
        }
    }

    public ASDate asDate() {
        return new ASDate(new ASString(this.byteArrayValue()));
    }

    public void setWriteHex(boolean bl) {
        this.mWriteHex = bl;
    }
}

