/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosWriter;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.CleanByteRepository;
import com.adobe.internal.pdf.cos.util.DataAccess;
import com.adobe.internal.pdf.cos.util.DataAccessByteRepository;
import com.adobe.internal.pdf.cos.util.IO;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.filter.FilterParams;
import com.adobe.internal.pdf.cos.util.filter.FilterStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CosStream
extends CosDictionary {
    private boolean mDataInPDF;
    private long mPos;
    private ByteStream mDecodedStream;
    private ByteStream mEncodedStream;

    CosStream(CosDictionary cosDictionary, long l) {
        super(cosDictionary);
        this.mDataInPDF = true;
        this.mPos = l;
        this.mEncodedStream = null;
        this.mDecodedStream = null;
    }

    public int getType() {
        return 7;
    }

    CosStream(CosDocument cosDocument, CosObjectID cosObjectID) {
        super(cosDocument, new HashMap(), cosObjectID);
        this.mDataInPDF = false;
        this.mPos = 0L;
        this.mEncodedStream = null;
        this.mDecodedStream = null;
    }

    CosStream(CosDocument cosDocument, CosObjectID cosObjectID, InputStream inputStream) {
        super(cosDocument, new HashMap(), cosObjectID);
        this.mDecodedStream = new ByteStream(inputStream);
        this.mEncodedStream = null;
        this.mDataInPDF = false;
        this.mPos = 0L;
    }

    CosStream(CosDocument cosDocument, CosObjectID cosObjectID, DataAccess dataAccess) {
        super(cosDocument, new HashMap(), cosObjectID);
        DataAccessByteRepository dataAccessByteRepository = new DataAccessByteRepository(dataAccess);
        this.mDataInPDF = false;
        this.mDecodedStream = new ByteStream(dataAccessByteRepository);
        this.mEncodedStream = null;
        this.mPos = 0L;
    }

    public byte[] getByteArray() {
        byte[] byArray;
        int n;
        ByteBuffer byteBuffer = this.getStream().getByteBuffer();
        long l = byteBuffer.getBytes(0L, n = (int)byteBuffer.getLength(), byArray = new byte[n]);
        return (byte[])(l > 0L ? byArray : null);
    }

    public byte[] getByteArrayEncoded() {
        byte[] byArray;
        int n;
        ByteBuffer byteBuffer = this.getStreamEncoded().getByteBuffer();
        long l = byteBuffer.getBytes(0L, n = (int)byteBuffer.getLength(), byArray = new byte[n]);
        return (byte[])(l > 0L ? byArray : null);
    }

    public ByteStream getStream() {
        return this.getStream(false);
    }

    public void getStream(OutputStream outputStream) throws IOException {
        this.getStream(outputStream, false);
    }

    public ByteStream getStreamEncoded() {
        return this.getStream(true);
    }

    public void getStreamEncoded(OutputStream outputStream) throws IOException {
        this.getStream(outputStream, true);
    }

    private ByteStream getStream(boolean bl) {
        InputStream inputStream;
        ByteStream byteStream = inputStream = bl ? this.mEncodedStream : this.mDecodedStream;
        if (inputStream == null) {
            if (!this.mDataInPDF) {
                return null;
            }
            ByteStream byteStream2 = this.getDocument().getBuffer();
            long l = this.getLong(ASName.k_Length);
            InputStream inputStream2 = byteStream2.slice(this.mPos, l);
            if (!bl) {
                inputStream2 = this.applyInputFilters(inputStream2);
            }
            inputStream = inputStream2 instanceof ByteStream ? inputStream2 : new ByteStream(inputStream2);
            if (bl) {
                this.mEncodedStream = inputStream;
            } else {
                this.mDecodedStream = inputStream;
            }
        }
        return inputStream;
    }

    public void getStream(OutputStream outputStream, boolean bl) throws IOException {
        ByteStream byteStream = this.getStream(bl);
        IO.copy(byteStream, outputStream);
    }

    public void newData(InputStream inputStream) {
        this.newData(inputStream, false);
    }

    public void newData(DataAccess dataAccess) {
        this.newData(dataAccess, false);
    }

    public OutputStream newData() {
        return this.newData(false);
    }

    public void newDataEncoded(InputStream inputStream) {
        this.newData(inputStream, true);
    }

    public void newDataEncoded(DataAccess dataAccess) {
        this.newData(dataAccess, true);
    }

    public OutputStream newDataEncoded() {
        return this.newData(true);
    }

    private void newData(InputStream inputStream, boolean bl) {
        ByteStream byteStream = new ByteStream(inputStream);
        this.mDataInPDF = false;
        this.makeDirty();
        if (bl) {
            this.mEncodedStream = byteStream;
        } else {
            this.mDecodedStream = byteStream;
        }
    }

    private void newData(DataAccess dataAccess, boolean bl) {
        ByteStream byteStream = new ByteStream(new DataAccessByteRepository(dataAccess));
        this.mDataInPDF = false;
        this.makeDirty();
        if (bl) {
            this.mEncodedStream = byteStream;
        } else {
            this.mDecodedStream = byteStream;
        }
    }

    private OutputStream newData(boolean bl) {
        CleanByteRepository cleanByteRepository = new CleanByteRepository();
        ByteStream byteStream = new ByteStream(cleanByteRepository);
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer(byteStream.getByteBuffer());
        this.mDataInPDF = false;
        this.makeDirty();
        if (bl) {
            this.mEncodedStream = byteStream;
        } else {
            this.mDecodedStream = byteStream;
        }
        return outputByteBuffer;
    }

    public boolean isASCIIEncoded() {
        return this.isASCII(this.getStreamEncoded());
    }

    public boolean isASCII() {
        return this.isASCII(this.getStream());
    }

    private boolean isASCII(ByteStream byteStream) {
        while (byteStream.bytesAvailable() > 0L) {
            byte by = byteStream.get();
            if (by >= 32 || ByteOps.isWhitespace((char)by)) continue;
            return false;
        }
        return true;
    }

    private InputStream applyInputFilters(InputStream inputStream) {
        Iterator iterator;
        Object object;
        CosObject cosObject = this.get(ASName.k_Filter);
        FilterParams filterParams = FilterStream.buildFilterParams(this.get(ASName.k_DecodeParms));
        if (cosObject instanceof CosName) {
            object = new ArrayList<CosObject>();
            object.add(cosObject);
            iterator = object.iterator();
        } else {
            iterator = cosObject == null ? new ArrayList().iterator() : ((CosArray)cosObject).iterator();
        }
        while (iterator.hasNext()) {
            object = ((CosName)iterator.next()).nameValue();
            inputStream = FilterStream.applyFilter(inputStream, (ASName)object, filterParams);
        }
        return inputStream;
    }

    private OutputStream applyOutputFilters(OutputStream outputStream) {
        Iterator iterator;
        Object object;
        CosObject cosObject = this.get(ASName.k_Filter);
        FilterParams filterParams = FilterStream.buildFilterParams(this.get(ASName.k_DecodeParms));
        if (cosObject instanceof CosName) {
            object = new ArrayList<CosObject>();
            object.add(cosObject);
            iterator = object.iterator();
        } else {
            iterator = cosObject == null ? new ArrayList().iterator() : ((CosArray)cosObject).iterator();
        }
        while (iterator.hasNext()) {
            object = ((CosName)iterator.next()).nameValue();
            outputStream = FilterStream.applyFilter(outputStream, (ASName)object, filterParams);
        }
        return outputStream;
    }

    void write(OutputStream outputStream) throws IOException {
        ByteStream byteStream = this.mEncodedStream != null ? this.mEncodedStream : this.mDecodedStream;
        ByteStream byteStream2 = byteStream != null ? new ByteStream(byteStream, 0L) : null;
        ByteStream byteStream3 = byteStream2;
        if (this.mDataInPDF) {
            int n = this.getInt(ASName.k_Length);
            ByteStream byteStream4 = this.getDocument().getBuffer();
            byteStream3 = byteStream4.slice(this.mPos, n);
        } else if (byteStream2 != null) {
            if (this.get(ASName.k_Filter) != null && byteStream != this.mEncodedStream) {
                CleanByteRepository cleanByteRepository = new CleanByteRepository();
                byteStream3 = new ByteStream(cleanByteRepository);
                OutputStream outputStream2 = new OutputByteBuffer(byteStream3.getByteBuffer());
                outputStream2 = this.applyOutputFilters(outputStream2);
                IO.copy(byteStream2, outputStream2);
                outputStream2.flush();
                outputStream2.close();
            }
            this.put(ASName.k_Length, byteStream3.limit());
        }
        super.write(outputStream);
        CosWriter.write("stream\n", outputStream);
        if (byteStream3 != null) {
            IO.copy(byteStream3, outputStream);
        }
        CosWriter.write("endstream\n", outputStream);
    }

    long getPos() {
        return this.mPos;
    }
}

