/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosToken;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.pdf.exceptions.PDFParseException;

public class CosObjectStream
extends CosStream {
    long[] mObjOffset;
    int[] mObjNumber;

    public CosObjectStream(CosStream cosStream) {
        super(cosStream, cosStream.getPos());
        if (!cosStream.containsKey(ASName.k_Type) || !cosStream.getName(ASName.k_Type).equals(ASName.k_ObjStm)) {
            throw new IllegalArgumentException("ObjectStream required fields missing");
        }
        int n = this.get(ASName.k_N).intValue();
        long l = this.get(ASName.k_First).intValue();
        ByteStream byteStream = this.getStream();
        this.mObjOffset = new long[n];
        this.mObjNumber = new int[n];
        byteStream.setPosition(0L);
        for (int i = 0; i < n; ++i) {
            this.mObjNumber[i] = CosToken.readNumber(byteStream, CosToken.skipWhitespace(byteStream)).intValue();
            int n2 = CosToken.readNumber(byteStream, CosToken.skipWhitespace(byteStream)).intValue();
            this.mObjOffset[i] = l + (long)n2;
        }
    }

    public ByteStream getBytesForObject(int n, int n2) {
        if (n >= this.mObjNumber.length || this.mObjNumber[n] != n2) {
            throw new PDFParseException(this.getPos());
        }
        return new ByteStream(this.getStream(), this.mObjOffset[n]);
    }
}

