/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosWriter;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIllegalStateException;
import java.io.IOException;
import java.io.OutputStream;

class CosObjectRef
extends CosObject {
    private CosObjectID mRefID = CosObjectID.NULL;

    CosObjectRef(CosDocument cosDocument, CosObjectID cosObjectID) {
        super(cosDocument, cosObjectID);
    }

    public CosObject clone(CosDocument cosDocument) {
        return new CosObjectRef(cosDocument, this.getRefID());
    }

    public int getType() {
        return 8;
    }

    public boolean isContainer() {
        return false;
    }

    boolean equivalent(CosObject cosObject) {
        return true;
    }

    void initialize(CosObjectID cosObjectID) {
        if (this.mRefID != CosObjectID.NULL) {
            throw new PDFIllegalStateException("CosObjectID already set");
        }
        this.mRefID = cosObjectID;
    }

    CosObjectID getRefID() {
        return this.mRefID;
    }

    void write(OutputStream outputStream) throws IOException {
        CosWriter.write(this.mRefID.getObjNum(), outputStream);
        CosWriter.write(' ', outputStream);
        CosWriter.write(this.mRefID.getGeneration(), outputStream);
        CosWriter.write(' ', outputStream);
        CosWriter.write('R', outputStream);
    }
}

