/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

class CosObjectID {
    static final CosObjectID NULL = new CosObjectID(0, 0);
    private int mID;
    private int mGeneration;
    private long mPos;

    CosObjectID(int n, int n2) {
        this.init(n, n2, 0L);
    }

    CosObjectID(int n, int n2, long l) {
        this.init(n, n2, l);
    }

    private void init(int n, int n2, long l) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid id value");
        }
        if (n2 < 0 || n2 > 99999) {
            throw new IllegalArgumentException("invalid generation value");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("invalid position value");
        }
        this.mID = n;
        this.mGeneration = n2;
        this.mPos = l;
    }

    int getObjNum() {
        return this.mID;
    }

    int getGeneration() {
        return this.mGeneration;
    }

    long getPos() {
        return this.mPos;
    }

    void setPos(long l) {
        this.mPos = l;
    }

    public boolean equals(Object object) {
        return object instanceof CosObjectID ? this.mID == ((CosObjectID)object).mID && this.mGeneration == ((CosObjectID)object).mGeneration : false;
    }

    public int hashCode() {
        return (int)(((long)this.mID * 2654435769L ^ (long)this.mGeneration * 2654435769L * 2654435769L) >> 16);
    }

    public String toString() {
        return "[objnum=" + this.mID + ",gen=" + this.mGeneration + ",pos=" + this.mPos + "]";
    }

    static CosObjectID nullID() {
        return NULL;
    }
}

