/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosObjectRef;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.exceptions.PDFCosCastException;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIllegalStateException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CosObject {
    public static final int t_Null = 0;
    public static final int t_Numeric = 1;
    public static final int t_Boolean = 2;
    public static final int t_Name = 3;
    public static final int t_String = 4;
    public static final int t_Array = 5;
    public static final int t_Dictionary = 6;
    public static final int t_Stream = 7;
    public static final int t_ObjectRef = 8;
    public static final int t_KeyAbsent = 9;
    private CosDocument mDoc;
    private CosObjectID mID;
    private boolean mUsedDirectly;
    private ASDictionary mUserData;

    CosObject(CosDocument cosDocument, CosObjectID cosObjectID) {
        this.mDoc = cosDocument;
        this.mID = cosObjectID;
        this.mUsedDirectly = false;
        this.mUserData = new ASDictionary();
    }

    public abstract CosObject clone(CosDocument var1);

    public abstract int getType();

    public abstract boolean isContainer();

    CosObject(CosObject cosObject) {
        this.mDoc = cosObject.mDoc;
        this.mID = cosObject.mID;
        this.mUserData = (ASDictionary)cosObject.mUserData.clone();
    }

    public int intValue() {
        throw new PDFCosCastException("expected CosNumeric");
    }

    public long longValue() {
        throw new PDFCosCastException("expected CosNumeric");
    }

    public double doubleValue() {
        throw new PDFCosCastException("expected CosNumeric");
    }

    public boolean booleanValue() {
        throw new PDFCosCastException("expected CosBoolean");
    }

    public ASName nameValue() {
        throw new PDFCosCastException("expected CosName");
    }

    public ASString stringValue() {
        throw new PDFCosCastException("expected CosName");
    }

    public String textValue() {
        throw new PDFCosCastException("expected CosString or CosName");
    }

    void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public CosDocument getDocument() {
        return this.mDoc;
    }

    public Object getUserData(ASName aSName) {
        return this.mUserData.get(aSName);
    }

    public void setUserData(ASName aSName, Object object) {
        this.mUserData.replace(aSName, object);
    }

    public void mark(ASName aSName) {
        Number number = (Number)this.getUserData(aSName);
        number = number == null ? new Integer(0) : new Integer(number.intValue() + 1);
        this.setUserData(aSName, number);
    }

    public boolean isMarked(ASName aSName) {
        return this.getUserData(aSName) != null;
    }

    CosObjectID getID() {
        return this.mID;
    }

    public boolean makeDirty() {
        CosObjectID cosObjectID = this.getID();
        if (cosObjectID == CosObjectID.NULL) {
            return false;
        }
        CosObject cosObject = this.mDoc.getObject(cosObjectID);
        this.getDocument().dirty(cosObject);
        cosObject.setUserData(ASName.k_Cos_Object_Dirty, null);
        return true;
    }

    public boolean isDirty() {
        return this.mUserData.exists(ASName.k_Cos_Object_Dirty);
    }

    void setID(CosObjectID cosObjectID) {
        if (!this.mID.equals(CosObjectID.NULL)) {
            throw new PDFIllegalStateException("CosObject is alredy a direct reference of another CosObject");
        }
        this.mID = cosObjectID;
    }

    abstract boolean equivalent(CosObject var1);

    boolean baseEquivalence(CosObject cosObject) {
        if (cosObject == null) {
            return false;
        }
        if (this.equals(cosObject)) {
            return true;
        }
        return cosObject.getType() == this.getType();
    }

    CosObject obtainDirectReference() {
        CosObject cosObject = this;
        if (cosObject instanceof CosStream) {
            throw new PDFIllegalStateException("stream objects cannot be direct");
        }
        CosObjectID cosObjectID = cosObject.getID();
        if (cosObjectID != null && !cosObjectID.equals(CosObjectID.NULL)) {
            cosObject = CosDictionary.copySingleValue(this, CosObjectID.NULL);
        }
        return cosObject;
    }

    CosObject obtainIndirectReference() {
        if (this.mUsedDirectly) {
            throw new PDFIllegalStateException("object cannot be direct and indirect");
        }
        CosObjectID cosObjectID = this.getID();
        if (cosObjectID.equals(CosObjectID.NULL)) {
            cosObjectID = this.mDoc.newObjectID();
            this.setID(cosObjectID);
            this.mDoc.cacheObject(cosObjectID, this);
            this.makeDirty();
        }
        CosObjectRef cosObjectRef = new CosObjectRef(this.getDocument(), CosObjectID.NULL);
        cosObjectRef.initialize(this.getID());
        return cosObjectRef;
    }

    CosObject obtainReference() {
        if (this instanceof CosDictionary) {
            return this.obtainIndirectReference();
        }
        return this.obtainDirectReference();
    }
}

