/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosScalar;
import com.adobe.internal.pdf.cos.CosWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class CosNumeric
extends CosScalar {
    private byte[] mInputRep = null;
    private Number mValue;

    CosNumeric(CosDocument cosDocument, Number number, CosObjectID cosObjectID) {
        super(cosDocument, cosObjectID);
        this.mValue = number;
    }

    public CosObject clone(CosDocument cosDocument) {
        return cosDocument.newNumeric(this.numberValue());
    }

    public int getType() {
        return 1;
    }

    public int intValue() {
        return this.mValue.intValue();
    }

    public long longValue() {
        return this.mValue.longValue();
    }

    public double doubleValue() {
        return this.mValue.doubleValue();
    }

    public Number numberValue() {
        return this.mValue;
    }

    boolean equivalent(CosObject cosObject) {
        if (!this.baseEquivalence(cosObject)) {
            return false;
        }
        Number number = ((CosNumeric)cosObject).numberValue();
        return this.numberValue().equals(number);
    }

    public String asString() {
        if (this.mInputRep != null) {
            return new String(this.mInputRep);
        }
        if (this.mValue instanceof Double) {
            DecimalFormat decimalFormat = new DecimalFormat("#############0.#####");
            return new String(decimalFormat.format(this.mValue));
        }
        return this.mValue.toString();
    }

    void write(OutputStream outputStream) throws IOException {
        CosWriter.write(this.asString(), outputStream);
    }

    void setInputRep(byte[] byArray) {
        this.mInputRep = byArray;
    }
}

