/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosBoolean;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNull;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosObjectRef;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.CosToken;
import com.adobe.internal.pdf.cos.CosWriter;
import com.adobe.internal.pdf.cos.XRefTable;
import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.CountingOutputStream;
import com.adobe.internal.pdf.cos.util.DataAccess;
import com.adobe.internal.pdf.cos.util.DataAccessByteRepository;
import com.adobe.internal.pdf.cos.util.IO;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIOException;
import com.adobe.internal.pdf.cos.util.exceptions.PDFNoSuchAlgorithmException;
import com.adobe.internal.pdf.cos.util.filter.Base64Engine;
import com.adobe.pdf.exceptions.PDFParseException;
import com.adobe.pdf.exceptions.PDFSecurityException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CosDocument {
    static final CosDocument NULL = new CosDocument();
    private ByteStream mBuf;
    private XRefTable mXRef;
    private HashMap mObjects;
    private ASDictionary mUserData;
    private List mDirty;
    private int mNumObjects;

    private CosDocument() {
        this.mUserData = null;
    }

    private long headerPos(ByteStream byteStream) {
        byte[] byArray = new byte[]{37, 80, 68, 70, 45};
        int n = 1024;
        if ((long)n > byteStream.limit()) {
            n = (int)byteStream.limit();
        }
        ByteStream byteStream2 = byteStream.slice(0L, n);
        return byteStream2.indexOf(byArray);
    }

    private void init(ByteStream byteStream) {
        long l = this.headerPos(byteStream);
        if (l < 0L) {
            throw new PDFParseException("Stream does not represent a PDF document.");
        }
        this.mBuf = l == 0L ? byteStream : byteStream.slice(l, byteStream.limit() - l);
        this.mUserData = new ASDictionary();
        this.mObjects = new HashMap((int)(byteStream.limit() / 100L), 0.5f);
        this.mXRef = new XRefTable(this, this.mBuf);
        this.mDirty = new ArrayList();
        CosDictionary cosDictionary = this.mXRef.getTrailer();
        if (cosDictionary.containsKey(ASName.k_Encrypt)) {
            throw new PDFSecurityException("Encrypted file");
        }
        CosObject cosObject = cosDictionary.get(ASName.k_Size);
        this.mNumObjects = ((CosNumeric)cosObject).intValue();
    }

    public CosDocument(InputStream inputStream) {
        ByteStream byteStream = new ByteStream(inputStream);
        this.init(byteStream);
    }

    public CosDocument(DataAccess dataAccess) {
        ByteStream byteStream;
        if (dataAccess instanceof ByteBuffer) {
            byteStream = new ByteStream((ByteBuffer)dataAccess);
        } else {
            DataAccessByteRepository dataAccessByteRepository = new DataAccessByteRepository(dataAccess);
            byteStream = new ByteStream(dataAccessByteRepository);
        }
        this.init(byteStream);
    }

    public String getVersion() {
        byte[] byArray = new byte[]{37, 80, 68, 70, 45};
        long l = 1024L;
        if (l > this.mBuf.limit()) {
            l = this.mBuf.limit();
        }
        ByteStream byteStream = this.mBuf.slice(0L, l);
        long l2 = byteStream.indexOf(byArray);
        return CosToken.readLine(byteStream.setPosition(l2));
    }

    CosDictionary getTrailer() {
        return this.mXRef.getTrailer();
    }

    public CosDictionary getRoot() {
        return (CosDictionary)this.getTrailer().get(ASName.k_Root);
    }

    public CosDictionary getInfo() {
        return (CosDictionary)this.getTrailer().get(ASName.k_Info);
    }

    public CosObjectID newObjectID() {
        return new CosObjectID(this.mNumObjects++, 0);
    }

    public Object getUserData(ASName aSName) {
        return this.mUserData.get(aSName);
    }

    public void setUserData(ASName aSName, Object object) {
        this.mUserData.replace(aSName, object);
    }

    public CosNull newNull() {
        return new CosNull(this, CosObjectID.NULL);
    }

    public CosString newString(ASString aSString) {
        byte[] byArray = aSString.getBytes();
        return this.newString(byArray);
    }

    public CosString newString(byte[] byArray) {
        return new CosString(this, byArray, 0, byArray.length, false, CosObjectID.NULL);
    }

    public CosString newString(String string) {
        byte[] byArray = PDFDocEncoding.fromUnicodeString(string);
        return new CosString(this, byArray, 0, byArray.length, false, CosObjectID.NULL);
    }

    public CosBoolean newBoolean(boolean bl) {
        return new CosBoolean(this, bl, CosObjectID.NULL);
    }

    public CosNumeric newNumeric(Number number) {
        return new CosNumeric(this, number, CosObjectID.NULL);
    }

    public CosName newName(ASName aSName) {
        return new CosName(this, aSName, CosObjectID.NULL);
    }

    public CosNumeric newNumeric(int n) {
        return new CosNumeric(this, new Integer(n), CosObjectID.NULL);
    }

    public CosNumeric newNumeric(long l) {
        return new CosNumeric(this, new Long(l), CosObjectID.NULL);
    }

    public CosNumeric newNumeric(double d) {
        return new CosNumeric(this, new Double(d), CosObjectID.NULL);
    }

    public CosArray newArray(ArrayList arrayList) {
        CosArray cosArray = new CosArray(this, arrayList, CosObjectID.NULL);
        return cosArray;
    }

    public CosArray newArray() {
        return this.newArray(new ArrayList());
    }

    public CosDictionary newDictionary() {
        CosDictionary cosDictionary = new CosDictionary(this, new HashMap(), CosObjectID.NULL);
        return cosDictionary;
    }

    public CosStream newStream() {
        CosObjectID cosObjectID = this.newObjectID();
        CosStream cosStream = new CosStream(this, cosObjectID);
        this.cacheObject(cosObjectID, cosStream);
        cosStream.makeDirty();
        return cosStream;
    }

    public CosStream newStream(DataAccess dataAccess) {
        CosObjectID cosObjectID = new CosObjectID(this.mNumObjects++, 0);
        CosStream cosStream = new CosStream(this, cosObjectID, dataAccess);
        this.cacheObject(cosObjectID, cosStream);
        cosStream.makeDirty();
        return cosStream;
    }

    public CosStream newStream(InputStream inputStream) {
        CosObjectID cosObjectID = new CosObjectID(this.mNumObjects++, 0);
        CosStream cosStream = new CosStream(this, cosObjectID, inputStream);
        this.cacheObject(cosObjectID, cosStream);
        cosStream.makeDirty();
        return cosStream;
    }

    boolean isIndirect(CosObject cosObject) {
        return this.getObject(cosObject.getID()) == cosObject;
    }

    public CosObjectRef newReference(CosObject cosObject) {
        if (!this.isIndirect(cosObject)) {
            throw new RuntimeException();
        }
        CosObjectRef cosObjectRef = new CosObjectRef(this, CosObjectID.NULL);
        cosObjectRef.initialize(cosObject.getID());
        return cosObjectRef;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.mBuf.setPosition(0L);
        IO.copy(this.mBuf, outputStream);
        this.writeIncrementalSave(outputStream);
    }

    public DataAccess save() throws IOException {
        this.mBuf.setPosition(0L);
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        IO.copy(this.mBuf, outputByteBuffer);
        this.writeIncrementalSave(outputByteBuffer);
        return outputByteBuffer;
    }

    public InputStream save(boolean bl) throws IOException {
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        this.mBuf.setPosition(0L);
        IO.copy(this.mBuf, outputByteBuffer);
        this.writeIncrementalSave(outputByteBuffer);
        if (bl) {
            return new Base64Engine.InputEncodeStream(new ByteStream(outputByteBuffer.getBuffer()));
        }
        return new ByteStream(outputByteBuffer.getBuffer());
    }

    void writeIncrementalSave(OutputStream outputStream) throws IOException {
        int n = this.mDirty.size();
        if (n == 0) {
            return;
        }
        if (this.mXRef.getType() == 1) {
            ++n;
        }
        CosObjectID[] cosObjectIDArray = new CosObjectID[n];
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        Iterator iterator = this.mDirty.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            CosObject cosObject = (CosObject)iterator.next();
            CosObjectID cosObjectID = cosObject.getID();
            cosObjectID.setPos(countingOutputStream.getCount() + (int)this.mBuf.limit());
            cosObjectIDArray[n2++] = cosObjectID;
            CosWriter.writeIndirectObject(cosObject, countingOutputStream);
        }
        long l = countingOutputStream.getCount() + (int)this.mBuf.limit();
        if (this.mXRef.getType() == 1) {
            CosStream cosStream = this.newStream();
            CosObjectID cosObjectID = cosStream.getID();
            cosObjectID.setPos(l);
            cosObjectIDArray[n2++] = cosObjectID;
            CosDictionary cosDictionary = this.getTrailer();
            HashMap<ASName, Object> hashMap = new HashMap<ASName, Object>();
            hashMap.put(ASName.k_Prev, null);
            hashMap.put(ASName.k_Length, null);
            hashMap.put(ASName.k_Size, null);
            hashMap.put(ASName.k_Type, null);
            hashMap.put(ASName.k_Filter, null);
            cosStream.copyDictionaryValues(cosDictionary, hashMap);
            this.UpdateID(cosStream);
            int n3 = this.mXRef.getLastXRefSectionPosition();
            cosStream.put(ASName.k_Prev, new CosNumeric(this, new Long(n3), CosObjectID.NULL));
            cosStream.put(ASName.k_Size, new CosNumeric(this, new Integer(this.mNumObjects), CosObjectID.NULL));
            cosStream.put(ASName.k_Type, new CosName(this, ASName.k_XRef, CosObjectID.NULL));
            CosWriter.writeStreamXRef(cosObjectIDArray, countingOutputStream, cosStream);
        } else {
            CosWriter.writeTableXRef(cosObjectIDArray, countingOutputStream);
            int n4 = this.mXRef.getLastXRefSectionPosition();
            this.getTrailer().put(ASName.k_Prev, new CosNumeric(this, new Long(n4), CosObjectID.NULL));
            this.getTrailer().put(ASName.k_Size, new CosNumeric(this, new Integer(this.mNumObjects), CosObjectID.NULL));
            CosDictionary cosDictionary = this.getTrailer();
            this.UpdateID(cosDictionary);
            CosWriter.writeTrailer(cosDictionary, countingOutputStream);
        }
        CosWriter.writeEOF(l, countingOutputStream);
    }

    CosObject getObject(CosObjectID cosObjectID) {
        CosObject cosObject = (CosObject)this.mObjects.get(cosObjectID);
        if (cosObject == null) {
            ByteStream byteStream = this.mXRef.getObjectBytes(cosObjectID);
            if (byteStream == null) {
                return null;
            }
            cosObject = CosToken.readIndirectObject(this, byteStream, cosObjectID);
            this.mObjects.put(cosObjectID, cosObject);
        }
        return cosObject;
    }

    void cacheObject(CosObjectID cosObjectID, CosObject cosObject) {
        this.mObjects.put(cosObjectID, cosObject);
    }

    void dirty(CosObject cosObject) {
        if (cosObject.isDirty()) {
            return;
        }
        this.mDirty.add(cosObject);
    }

    ByteStream getBuffer() {
        return this.mBuf;
    }

    XRefTable getXRef() {
        return this.mXRef;
    }

    void UpdateID(CosDictionary cosDictionary) {
        Object object;
        CosObject cosObject = cosDictionary.get(ASName.k_ID);
        IDProducer iDProducer = new IDProducer();
        DataOutputStream dataOutputStream = new DataOutputStream(iDProducer);
        UID uID = new UID();
        try {
            uID.write(dataOutputStream);
            if (cosObject != null) {
                object = ((CosArray)cosObject).getString(1);
                iDProducer.write(((ASString)object).getBytes());
            }
        }
        catch (IOException iOException) {
            throw new PDFIOException(iOException.getMessage());
        }
        object = iDProducer.getDigest();
        if (cosObject == null) {
            cosObject = this.newArray();
            cosDictionary.put(ASName.k_ID, cosObject);
            ((CosArray)cosObject).addString(new ASString((byte[])object));
            ((CosArray)cosObject).add(this.newNull());
        }
        ((CosArray)cosObject).setString(1, new ASString((byte[])object));
        for (int i = 0; i < 2; ++i) {
            CosString cosString = ((CosArray)cosObject).getCosString(i);
            cosString.setWriteHex(true);
        }
    }

    public static CosDocument nullDocument() {
        return NULL;
    }

    class IDProducer
    extends OutputStream {
        MessageDigest mDigest;

        IDProducer() {
            try {
                this.mDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PDFNoSuchAlgorithmException("no MD5 available");
            }
        }

        public void write(int n) throws IOException {
            this.mDigest.update((byte)n);
        }

        byte[] getDigest() {
            return this.mDigest.digest();
        }
    }
}

