/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosBoolean;
import com.adobe.internal.pdf.cos.CosContainer;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNull;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosObjectRef;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIllegalStateException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CosDictionary
extends CosContainer {
    private static final ASName equivMarker = ASName.create("Cos_Object_Equivalent");
    private Map mData;

    CosDictionary(CosDocument cosDocument, Map map, CosObjectID cosObjectID) {
        super(cosDocument, cosObjectID);
        this.mData = map;
    }

    CosDictionary(CosDictionary cosDictionary) {
        super(cosDictionary);
        this.mData = cosDictionary.mData;
    }

    public CosObject clone(CosDocument cosDocument) {
        if (this.isMarked(ASName.k_Cos_Object_Cloned)) {
            return (CosObject)this.getUserData(ASName.k_Cos_Object_Cloned);
        }
        CosDictionary cosDictionary = cosDocument.newDictionary();
        this.setUserData(ASName.k_Cos_Object_Cloned, cosDictionary);
        Iterator iterator = this.keyIterator();
        while (iterator.hasNext()) {
            ASName aSName = (ASName)iterator.next();
            CosObject cosObject = this.get(aSName);
            cosDictionary.put(aSName, cosObject.clone(cosDocument));
        }
        return cosDictionary;
    }

    public ArrayList getKeys() {
        ArrayList<ASName> arrayList = new ArrayList<ASName>();
        Iterator iterator = this.keyIterator();
        while (iterator.hasNext()) {
            ASName aSName = (ASName)iterator.next();
            arrayList.add(aSName);
        }
        return arrayList;
    }

    boolean equivalent(CosObject cosObject) {
        Object object;
        ASName aSName;
        int n;
        if (!this.baseEquivalence(cosObject)) {
            return false;
        }
        if (this.isMarked(equivMarker)) {
            return true;
        }
        this.mark(equivMarker);
        ArrayList arrayList = this.getKeys();
        ArrayList arrayList2 = ((CosDictionary)cosObject).getKeys();
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            aSName = (ASName)arrayList.get(n);
            object = (ASName)arrayList2.get(n);
            if (aSName.toString().compareTo(((ASName)object).toString()) == 0) continue;
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            CosObject cosObject2;
            aSName = (ASName)arrayList.get(n);
            object = this.get(aSName);
            if (((CosObject)object).equivalent(cosObject2 = ((CosDictionary)cosObject).get(aSName))) continue;
            return false;
        }
        return true;
    }

    public int getType() {
        return 6;
    }

    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    public int size() {
        return this.mData.size();
    }

    public boolean containsKey(Object object) {
        return this.mData.containsKey(object);
    }

    public CosObject get(ASName aSName) {
        CosObject cosObject = this.resolveRef((CosObject)this.mData.get(aSName));
        if (cosObject instanceof CosNull) {
            cosObject = null;
        }
        return cosObject;
    }

    public int getType(ASName aSName) {
        if (!this.mData.containsKey(aSName)) {
            return 9;
        }
        CosObject cosObject = (CosObject)this.mData.get(aSName);
        if (cosObject == null) {
            return 0;
        }
        return cosObject.getType();
    }

    public ASName getName(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return cosObject.nameValue();
    }

    public boolean getBoolean(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return cosObject.booleanValue();
    }

    public double getDouble(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return cosObject.doubleValue();
    }

    public int getInt(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return cosObject.intValue();
    }

    public long getLong(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return cosObject.longValue();
    }

    public ASString getString(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return cosObject.stringValue();
    }

    public CosString getCosString(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return (CosString)cosObject;
    }

    public CosArray getCosArray(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return (CosArray)cosObject;
    }

    public CosDictionary getCosDictionary(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return (CosDictionary)cosObject;
    }

    public CosStream getCosStream(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return (CosStream)cosObject;
    }

    public ByteStream getStream(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        return ((CosStream)cosObject).getStream();
    }

    public CosObject put(ASName aSName, CosObject cosObject) {
        CosObject cosObject2 = this.get(aSName);
        CosObject cosObject3 = cosObject.obtainReference();
        this.mData.put(aSName, cosObject3);
        cosObject3.setID(this.getID());
        this.makeDirty();
        return cosObject2;
    }

    public CosObject put(ASName aSName, ASName aSName2) {
        CosName cosName = this.getDocument().newName(aSName2);
        return this.put(aSName, cosName);
    }

    public CosObject put(ASName aSName, boolean bl) {
        CosBoolean cosBoolean = this.getDocument().newBoolean(bl);
        return this.put(aSName, cosBoolean);
    }

    public CosObject put(ASName aSName, double d) {
        CosNumeric cosNumeric = this.getDocument().newNumeric(d);
        return this.put(aSName, cosNumeric);
    }

    public CosObject put(ASName aSName, long l) {
        CosNumeric cosNumeric = this.getDocument().newNumeric(l);
        return this.put(aSName, cosNumeric);
    }

    public CosObject put(ASName aSName, int n) {
        CosNumeric cosNumeric = this.getDocument().newNumeric(n);
        return this.put(aSName, cosNumeric);
    }

    public CosObject put(ASName aSName, ASString aSString) {
        CosString cosString = this.getDocument().newString(aSString);
        return this.put(aSName, cosString);
    }

    public CosObject put(ASName aSName, String string) {
        CosString cosString = this.getDocument().newString(string);
        return this.put(aSName, cosString);
    }

    public CosObject put(ASName aSName, double[] dArray) {
        CosArray cosArray = this.getDocument().newArray();
        for (int i = 0; i < dArray.length; ++i) {
            cosArray.addDouble(dArray[i]);
        }
        return this.put(aSName, cosArray);
    }

    public CosObject put(ASName aSName, long[] lArray) {
        CosArray cosArray = this.getDocument().newArray();
        for (int i = 0; i < lArray.length; ++i) {
            cosArray.addLong(lArray[i]);
        }
        return this.put(aSName, cosArray);
    }

    public CosObject put(ASName aSName, ASName[] aSNameArray) {
        CosArray cosArray = this.getDocument().newArray();
        for (int i = 0; i < aSNameArray.length; ++i) {
            cosArray.addName(aSNameArray[i]);
        }
        return this.put(aSName, cosArray);
    }

    public CosObject put(ASName aSName, int[] nArray) {
        CosArray cosArray = this.getDocument().newArray();
        for (int i = 0; i < nArray.length; ++i) {
            cosArray.addInt(nArray[i]);
        }
        return this.put(aSName, cosArray);
    }

    public CosObject put(ASName aSName, String[] stringArray) {
        CosArray cosArray = this.getDocument().newArray();
        for (int i = 0; i < stringArray.length; ++i) {
            cosArray.addString(stringArray[i]);
        }
        return this.put(aSName, cosArray);
    }

    public CosObject put(ASName aSName, boolean[] blArray) {
        CosArray cosArray = this.getDocument().newArray();
        for (int i = 0; i < blArray.length; ++i) {
            cosArray.addBoolean(blArray[i]);
        }
        return this.put(aSName, cosArray);
    }

    public CosObject remove(ASName aSName) {
        CosObject cosObject = this.get(aSName);
        if (cosObject != null) {
            this.mData.remove(aSName);
        }
        this.makeDirty();
        return cosObject;
    }

    public Set keySet() {
        return this.mData.keySet();
    }

    public Iterator keyIterator() {
        return this.mData.keySet().iterator();
    }

    void write(OutputStream outputStream) throws IOException {
        outputStream.write(60);
        outputStream.write(60);
        outputStream.write(32);
        Iterator iterator = this.mData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((ASName)entry.getKey()).write(outputStream);
            outputStream.write(32);
            ((CosObject)entry.getValue()).write(outputStream);
            outputStream.write(32);
        }
        outputStream.write(62);
        outputStream.write(62);
    }

    CosObject unfilteredGet(ASName aSName) {
        return (CosObject)this.mData.get(aSName);
    }

    void copyDictionaryValues(CosDictionary cosDictionary, Map map) {
        Iterator iterator = cosDictionary.keyIterator();
        while (iterator.hasNext()) {
            ASName aSName = (ASName)iterator.next();
            if (map != null && map.containsKey(aSName)) continue;
            CosObject cosObject = cosDictionary.unfilteredGet(aSName);
            CosObject cosObject2 = CosDictionary.copySingleValue(cosObject, this.getID());
            this.mData.put(aSName, cosObject2);
        }
    }

    static CosObject copySingleValue(CosObject cosObject, CosObjectID cosObjectID) {
        CosObject cosObject2;
        if (cosObject == null) {
            cosObject2 = null;
        } else {
            CosDocument cosDocument = cosObject.getDocument();
            if (cosObject instanceof CosArray) {
                cosObject2 = new CosArray(cosDocument, new ArrayList(), cosObjectID);
                CosArray.CosArrayIterator cosArrayIterator = (CosArray.CosArrayIterator)((CosArray)cosObject).iterator();
                while (cosArrayIterator.hasNext()) {
                    CosObject cosObject3 = (CosObject)cosArrayIterator.unfilteredNext();
                    ((CosArray)cosObject2).unfilteredAdd(CosDictionary.copySingleValue(cosObject3, cosObjectID));
                }
            } else if (cosObject instanceof CosBoolean) {
                cosObject2 = new CosBoolean(cosDocument, cosObject.booleanValue(), cosObjectID);
            } else if (cosObject instanceof CosStream) {
                cosObject2 = new CosStream(cosDocument, cosObjectID);
                ((CosDictionary)cosObject2).copyDictionaryValues((CosDictionary)cosObject, null);
                ((CosStream)cosObject2).newData(new ByteStream(((CosStream)cosObject).getStream(), 0L));
            } else if (cosObject instanceof CosDictionary) {
                cosObject2 = new CosDictionary(cosDocument, new HashMap(), cosObjectID);
                ((CosDictionary)cosObject2).copyDictionaryValues((CosDictionary)cosObject, null);
            } else if (cosObject instanceof CosNumeric) {
                cosObject2 = new CosNumeric(cosDocument, ((CosNumeric)cosObject).numberValue(), cosObjectID);
            } else if (cosObject instanceof CosObjectRef) {
                cosObject2 = new CosObjectRef(cosDocument, cosObjectID);
                ((CosObjectRef)cosObject2).initialize(((CosObjectRef)cosObject).getRefID());
            } else if (cosObject instanceof CosName) {
                cosObject2 = new CosName(cosDocument, ((CosName)cosObject).nameValue(), cosObjectID);
            } else if (cosObject instanceof CosString) {
                byte[] byArray = ((CosString)cosObject).byteArrayValue();
                cosObject2 = new CosString(cosDocument, byArray, 0, byArray.length, false, cosObjectID);
            } else {
                throw new PDFIllegalStateException("strange value in dictionary");
            }
        }
        return cosObject2;
    }
}

