/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosScalar;
import com.adobe.internal.pdf.cos.CosWriter;
import java.io.IOException;
import java.io.OutputStream;

public class CosBoolean
extends CosScalar {
    private boolean mValue;

    CosBoolean(CosDocument cosDocument, boolean bl, CosObjectID cosObjectID) {
        super(cosDocument, cosObjectID);
        this.mValue = bl;
    }

    public CosObject clone(CosDocument cosDocument) {
        return cosDocument.newBoolean(this.booleanValue());
    }

    public int getType() {
        return 2;
    }

    public boolean booleanValue() {
        return this.mValue;
    }

    public String asString() {
        if (this.mValue) {
            return new String("true");
        }
        return new String("false");
    }

    boolean equivalent(CosObject cosObject) {
        if (!this.baseEquivalence(cosObject)) {
            return false;
        }
        boolean bl = ((CosBoolean)cosObject).booleanValue();
        return bl == this.booleanValue();
    }

    void write(OutputStream outputStream) throws IOException {
        CosWriter.write(this.asString(), outputStream);
    }
}

