/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosContainer;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosObjectRef;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class CosArray
extends CosContainer {
    private static final ASName equivMarker = ASName.create("Cos_Object_Equivalent");
    private ArrayList mData;

    CosArray(CosDocument cosDocument, ArrayList arrayList, CosObjectID cosObjectID) {
        super(cosDocument, cosObjectID);
        this.mData = arrayList;
    }

    public CosObject clone(CosDocument cosDocument) {
        if (this.isMarked(ASName.k_Cos_Object_Cloned)) {
            return (CosObject)this.getUserData(ASName.k_Cos_Object_Cloned);
        }
        CosArray cosArray = cosDocument.newArray();
        this.setUserData(ASName.k_Cos_Object_Cloned, cosArray);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CosObject cosObject = (CosObject)iterator.next();
            cosArray.add(cosObject.clone(cosDocument));
        }
        return cosArray;
    }

    public int getType() {
        return 5;
    }

    public int size() {
        return this.mData.size();
    }

    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    public Iterator iterator() {
        return new CosArrayIterator();
    }

    public ListIterator listIterator() {
        return new CosArrayIterator();
    }

    boolean equivalent(CosObject cosObject) {
        if (!this.baseEquivalence(cosObject)) {
            return false;
        }
        if (this.isMarked(equivMarker)) {
            return true;
        }
        this.mark(equivMarker);
        CosArray cosArray = (CosArray)cosObject;
        if (this.size() != cosArray.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            CosObject cosObject2;
            CosObject cosObject3 = this.get(i);
            if (cosObject3.equivalent(cosObject2 = cosArray.get(i))) continue;
            return false;
        }
        return true;
    }

    public CosObject get(int n) {
        return this.resolveRef((CosObject)this.mData.get(n));
    }

    public int getType(int n) {
        CosObject cosObject = (CosObject)this.mData.get(n);
        if (cosObject == null) {
            return 0;
        }
        return cosObject.getType();
    }

    public ASName getName(int n) {
        CosObject cosObject = this.get(n);
        return cosObject.nameValue();
    }

    public boolean getBoolean(int n) {
        CosObject cosObject = this.get(n);
        return cosObject.booleanValue();
    }

    public double getDouble(int n) {
        CosObject cosObject = this.get(n);
        return cosObject.doubleValue();
    }

    public double[] getArrayDouble() {
        double[] dArray = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            dArray[i] = this.getDouble(i);
        }
        return dArray;
    }

    public int getInt(int n) {
        CosObject cosObject = this.get(n);
        return cosObject.intValue();
    }

    public int[] getArrayInt() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            nArray[i] = this.getInt(i);
        }
        return nArray;
    }

    public ASString getString(int n) {
        CosObject cosObject = this.get(n);
        return cosObject.stringValue();
    }

    public String getText(int n) {
        CosObject cosObject = this.get(n);
        return cosObject.textValue();
    }

    public CosString getCosString(int n) {
        CosObject cosObject = this.get(n);
        return (CosString)cosObject;
    }

    public CosArray getCosArray(int n) {
        CosObject cosObject = this.get(n);
        return (CosArray)cosObject;
    }

    public CosDictionary getCosDictionary(int n) {
        CosObject cosObject = this.get(n);
        return (CosDictionary)cosObject;
    }

    public CosStream getCosStream(int n) {
        CosObject cosObject = this.get(n);
        return (CosStream)cosObject;
    }

    public ByteStream getStream(int n) {
        CosObject cosObject = this.get(n);
        return ((CosStream)cosObject).getStream();
    }

    public CosObject remove(int n) {
        this.makeDirty();
        return (CosObject)this.mData.remove(n);
    }

    public boolean remove(CosObject cosObject) {
        CosObjectID cosObjectID = cosObject.getID();
        for (int i = 0; i < this.size(); ++i) {
            CosObject cosObject2 = this.get(i);
            CosObjectID cosObjectID2 = cosObject2.getID();
            if (cosObject2 instanceof CosObjectRef) {
                cosObjectID2 = ((CosObjectRef)cosObject2).getRefID();
            }
            if (cosObjectID != cosObjectID2) continue;
            this.mData.remove(i);
            this.makeDirty();
            return true;
        }
        return false;
    }

    public boolean add(CosObject cosObject) {
        CosObject cosObject2 = cosObject.obtainReference();
        this.mData.add(cosObject2);
        cosObject2.setID(this.getID());
        this.makeDirty();
        return true;
    }

    public boolean addName(ASName aSName) {
        return this.add(this.getDocument().newName(aSName));
    }

    public boolean addBoolean(boolean bl) {
        return this.add(this.getDocument().newBoolean(bl));
    }

    public boolean addDouble(double d) {
        return this.add(this.getDocument().newNumeric(d));
    }

    public boolean addLong(long l) {
        return this.add(this.getDocument().newNumeric(l));
    }

    public boolean addInt(int n) {
        return this.add(this.getDocument().newNumeric(n));
    }

    public boolean addString(String string) {
        return this.add(this.getDocument().newString(string));
    }

    public boolean addString(ASString aSString) {
        return this.add(this.getDocument().newString(aSString));
    }

    public void add(int n, CosObject cosObject) {
        CosObject cosObject2 = cosObject.obtainReference();
        this.mData.add(n, cosObject2);
        cosObject2.setID(this.getID());
        this.makeDirty();
    }

    public void addName(int n, ASName aSName) {
        this.add(n, this.getDocument().newName(aSName));
    }

    public void addBoolean(int n, boolean bl) {
        this.add(n, this.getDocument().newBoolean(bl));
    }

    public void addDouble(int n, double d) {
        this.add(n, this.getDocument().newNumeric(d));
    }

    public void addLong(int n, long l) {
        this.add(n, this.getDocument().newNumeric(l));
    }

    public void addInt(int n, int n2) {
        this.add(n, this.getDocument().newNumeric(n2));
    }

    public void addString(int n, String string) {
        this.add(n, this.getDocument().newString(string));
    }

    public void addString(int n, ASString aSString) {
        this.add(n, this.getDocument().newString(aSString));
    }

    public boolean set(int n, CosObject cosObject) {
        CosObject cosObject2 = cosObject.obtainReference();
        this.mData.set(n, cosObject2);
        cosObject2.setID(this.getID());
        this.makeDirty();
        return true;
    }

    public boolean setName(int n, ASName aSName) {
        return this.set(n, this.getDocument().newName(aSName));
    }

    public boolean setName(int n, String string) {
        return this.set(n, this.getDocument().newName(ASName.create(string)));
    }

    public boolean setBoolean(int n, boolean bl) {
        return this.set(n, this.getDocument().newBoolean(bl));
    }

    public boolean setDouble(int n, double d) {
        return this.set(n, this.getDocument().newNumeric(d));
    }

    public boolean setInt(int n, int n2) {
        return this.set(n, this.getDocument().newNumeric(n2));
    }

    public boolean setLong(int n, long l) {
        return this.set(n, this.getDocument().newNumeric(l));
    }

    public boolean setString(int n, ASString aSString) {
        return this.set(n, this.getDocument().newString(aSString));
    }

    public boolean setText(int n, String string) {
        return this.set(n, this.getDocument().newString(string));
    }

    public CosArray splitBefore(int n) {
        int n2;
        CosArray cosArray = this.getDocument().newArray();
        int n3 = this.size();
        for (n2 = n; n2 < n3; ++n2) {
            cosArray.add(this.get(n2));
        }
        for (n2 = n; n2 < n3; ++n2) {
            this.remove(n);
        }
        return cosArray;
    }

    public CosArray splitAfter(int n) {
        return this.splitBefore(n + 1);
    }

    void write(OutputStream outputStream) throws IOException {
        outputStream.write(91);
        outputStream.write(32);
        Iterator iterator = this.mData.iterator();
        while (iterator.hasNext()) {
            ((CosObject)iterator.next()).write(outputStream);
            outputStream.write(32);
        }
        outputStream.write(93);
    }

    CosObject unfilteredGet(int n) {
        return (CosObject)this.mData.get(n);
    }

    void unfilteredAdd(CosObject cosObject) {
        this.mData.add(cosObject);
    }

    public class CosArrayIterator
    implements ListIterator {
        private ListIterator mIter;

        CosArrayIterator() {
            this.mIter = CosArray.this.mData.listIterator();
        }

        public int nextIndex() {
            return this.mIter.nextIndex();
        }

        public int previousIndex() {
            return this.mIter.previousIndex();
        }

        public boolean hasNext() {
            return this.mIter.hasNext();
        }

        public boolean hasPrevious() {
            return this.mIter.hasPrevious();
        }

        public Object next() {
            CosObject cosObject = CosArray.this.resolveRef((CosObject)this.mIter.next());
            return cosObject;
        }

        public Object unfilteredNext() {
            return this.mIter.next();
        }

        public Object previous() {
            CosObject cosObject = CosArray.this.resolveRef((CosObject)this.mIter.previous());
            return cosObject;
        }

        public Object unfilteredPrevious() {
            return this.mIter.previous();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

