/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf.cos;

import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosObjectID;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.CosToken;
import com.adobe.internal.pdf.cos.util.ByteOps;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.pdf.exceptions.PDFParseException;

public class ByteArrayUtility {
    public static byte[] readLiteral(ByteStream byteStream) {
        byte[] byArray = ByteArrayUtility.readLiteral(CosDocument.NULL, CosObjectID.NULL, byteStream).byteArrayValue();
        return byArray;
    }

    public static CosString readLiteral(CosDocument cosDocument, CosObjectID cosObjectID, ByteStream byteStream) {
        byte[] byArray = new byte[16];
        int n = 0;
        int n2 = 1;
        do {
            int n3;
            if ((n3 = byteStream.get()) == 40) {
                ++n2;
            } else if (n3 == 41) {
                --n2;
            } else if (n3 == 92) {
                n3 = byteStream.get();
                if (n3 == 13) continue;
                if (n3 >= 48 && n3 <= 55) {
                    n3 = (byte)(n3 - 48);
                    byte by = byteStream.get();
                    if (by >= 48 && by <= 55) {
                        by = (byte)(by - 48);
                        byte by2 = byteStream.get();
                        if (by2 >= 48 && by2 <= 55) {
                            by2 = (byte)(by2 - 48);
                            n3 = (byte)(n3 * 64 + by * 8 + by2);
                            byteStream.get();
                        } else {
                            n3 = (byte)(n3 * 8 + by);
                        }
                    }
                    byteStream.unget();
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 98) {
                    n3 = 8;
                } else if (n3 == 102) {
                    n3 = 12;
                } else if (n3 == 40) {
                    n3 = 40;
                } else if (n3 == 41) {
                    n3 = 41;
                } else if (n3 == 92) {
                    n3 = 92;
                }
            }
            if (n == byArray.length) {
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            byArray[n++] = n3;
        } while (n2 != 0);
        return new CosString(cosDocument, byArray, 0, n - 1, true, cosObjectID);
    }

    public static byte[] readHex(ByteStream byteStream) {
        byte by = byteStream.get();
        int n = (int)byteStream.getPosition() - 1;
        while (by != 62) {
            if (!ByteOps.isHexDigit(by)) {
                throw new PDFParseException((int)byteStream.getPosition() - 1);
            }
            by = byteStream.get();
        }
        int n2 = (int)byteStream.getPosition() - 1;
        return ByteArrayUtility.hexToByteArray(byteStream, n, n2);
    }

    private static byte[] hexToByteArray(ByteStream byteStream, int n, int n2) {
        byte[] byArray = new byte[(n2 - n) / 2];
        int n3 = 0;
        byteStream.setPosition(n);
        for (int i = n; i < n2; i += 2) {
            byte by = CosToken.toHexDigit(byteStream.get());
            byte by2 = CosToken.toHexDigit(byteStream.get());
            byArray[n3++] = (byte)(by * 16 + by2);
        }
        byteStream.setPosition(byteStream.getPosition() + 1L);
        return byArray;
    }

    public static byte[] toByteStringASCII(String string) {
        byte[] byArray = ByteArrayUtility.readLiteral(Utility.toByteStreamASCII(string + ") "));
        return byArray;
    }

    private static byte[] hexStringToByteArray(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (ByteOps.isHexDigit((byte)n)) {
                ++n2;
                continue;
            }
            if (n2 <= 0) continue;
            n3 += (n2 + 1) / 2;
            n2 = 0;
        }
        if (n2 > 0) {
            n3 += (n2 + 1) / 2;
        }
        byte[] byArray = new byte[n3];
        n = 0;
        boolean bl = false;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            byte by = (byte)string.charAt(i);
            if (ByteOps.isHexDigit(by)) {
                n4 = 16 * n4 + CosToken.toHexDigit(by);
                if (bl) {
                    byArray[n++] = (byte)n4;
                    n4 = 0;
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (!bl) continue;
            byArray[n++] = (byte)n4;
            bl = false;
        }
        return byArray;
    }
}

