/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosNumeric;
import java.util.Iterator;

class WidthEntry {
    private int startCID;
    private int endCID;
    private CosArray widths;
    private double width;

    WidthEntry(int n, CosArray cosArray) {
        this.startCID = n;
        this.endCID = n + cosArray.size() - 1;
        this.widths = cosArray;
        this.width = 0.0;
    }

    WidthEntry(int n, int n2, double d) {
        this.startCID = n;
        this.endCID = n2;
        this.widths = null;
        this.width = d;
    }

    public String toString() {
        String string;
        if (this.widths != null) {
            string = this.startCID + " [ ";
            Iterator iterator = this.widths.iterator();
            while (iterator.hasNext()) {
                string = string.concat(((CosNumeric)iterator.next()).intValue() + " ");
            }
            string = string + "]";
        } else {
            string = this.startCID + " " + this.endCID + " ";
            string = string + this.width;
        }
        return string;
    }

    int getStartCID() {
        return this.startCID;
    }

    int getEndCID() {
        return this.endCID;
    }

    boolean contains(int n) {
        return n >= this.startCID && n <= this.endCID;
    }

    double getWidth(int n) {
        if (this.widths != null) {
            return this.widths.getDouble(n - this.startCID);
        }
        return this.width;
    }
}

