/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.CMapCodeMapping;
import com.adobe.internal.pdf.cos.CosToken;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.exceptions.PDFCMapException;
import com.adobe.internal.pdf.cos.util.exceptions.PDFCMapParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashSet;

class ToUnicodeCMapParser {
    private StreamTokenizer tokenizer;
    private double lastNumber = 0.0;

    private ToUnicodeCMapParser(ByteStream byteStream) {
        byteStream.setPosition(0L);
        InputStreamReader inputStreamReader = new InputStreamReader(byteStream);
        this.tokenizer = new StreamTokenizer(inputStreamReader);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(60, 60);
        this.tokenizer.wordChars(62, 62);
        this.tokenizer.ordinaryChar(91);
        this.tokenizer.ordinaryChar(93);
    }

    static HashSet parseCMap(ByteStream byteStream) {
        ToUnicodeCMapParser toUnicodeCMapParser = new ToUnicodeCMapParser(byteStream);
        toUnicodeCMapParser.parseRequiredToken(ASName.k_begincmap.toString());
        return toUnicodeCMapParser.parseToUnicodeMappings();
    }

    private String nextStringToken() {
        String string = null;
        boolean bl = false;
        try {
            while (!bl && this.tokenizer.nextToken() != -1) {
                switch (this.tokenizer.ttype) {
                    case -2: 
                    case 10: {
                        this.lastNumber = this.tokenizer.nval;
                        break;
                    }
                    case -3: {
                        bl = true;
                        string = this.tokenizer.sval;
                        break;
                    }
                    case 91: {
                        bl = true;
                        string = "[";
                        break;
                    }
                    case 93: {
                        bl = true;
                        string = "]";
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new PDFCMapException("CMap could not be parsed");
        }
        return string;
    }

    private void parseRequiredToken(String string) {
        String string2;
        while ((string2 = this.nextStringToken()) != null) {
            if (!string2.equals(string)) continue;
            return;
        }
        throw new PDFCMapParseException("CMap could not be parsed: missing token \"" + string + "\"");
    }

    private HashSet parseToUnicodeMappings() {
        String string;
        HashSet hashSet = new HashSet();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(ASName.k_begincodespacerange.toString());
        hashSet2.add(ASName.k_endcodespacerange.toString());
        hashSet2.add(ASName.k_beginbfchar.toString());
        hashSet2.add(ASName.k_endbfchar.toString());
        hashSet2.add(ASName.k_beginbfrange.toString());
        hashSet2.add(ASName.k_endbfrange.toString());
        hashSet2.add(ASName.k_endcmap.toString());
        while ((string = this.nextStringToken()) != null) {
            if (!hashSet2.contains(string) || string.equalsIgnoreCase(ASName.k_begincodespacerange.toString())) continue;
            if (string.equalsIgnoreCase(ASName.k_beginbfchar.toString())) {
                this.parseCharMapping((int)this.lastNumber, hashSet);
                continue;
            }
            if (string.equalsIgnoreCase(ASName.k_beginbfrange.toString())) {
                this.parseRangeMapping((int)this.lastNumber, hashSet);
                continue;
            }
            if (!string.equalsIgnoreCase(ASName.k_endcmap.toString())) continue;
            break;
        }
        return hashSet;
    }

    private void parseCharMapping(int n, HashSet hashSet) {
        for (int i = 0; i < n; ++i) {
            String string = this.nextStringToken();
            int n2 = this.hexStringToInt(string);
            CMapCodeMapping cMapCodeMapping = new CMapCodeMapping(n2);
            String string2 = this.nextStringToken();
            if (this.isHexString(string2)) {
                byte[] byArray = this.hexStringToByteArray(string2);
                cMapCodeMapping.addHexData(byArray);
            } else {
                cMapCodeMapping.addCharName(string2);
            }
            hashSet.add(cMapCodeMapping);
        }
    }

    private void parseRangeMapping(int n, HashSet hashSet) {
        for (int i = 0; i < n; ++i) {
            String string = this.nextStringToken();
            int n2 = this.hexStringToInt(string);
            String string2 = this.nextStringToken();
            int n3 = this.hexStringToInt(string2);
            CMapCodeMapping cMapCodeMapping = new CMapCodeMapping(n2, n3);
            String string3 = this.nextStringToken();
            if (string3.equals("[")) {
                for (int j = n2; j <= n3; ++j) {
                    string3 = this.nextStringToken();
                    if (this.isHexString(string3)) {
                        byte[] byArray = this.hexStringToByteArray(string3);
                        cMapCodeMapping.addHexData(byArray);
                        continue;
                    }
                    cMapCodeMapping.addCharName(string3);
                }
            } else if (this.isHexString(string3)) {
                byte[] byArray = this.hexStringToByteArray(string3);
                cMapCodeMapping.addHexData(byArray);
            } else {
                cMapCodeMapping.addCharName(string3);
            }
            hashSet.add(cMapCodeMapping);
        }
    }

    private boolean isHexString(String string) {
        boolean bl = true;
        if (string.charAt(0) != '<') {
            bl = false;
        }
        if (string.charAt(string.length() - 1) != '>') {
            bl = false;
        }
        return bl;
    }

    private void ensureHexString(String string) {
        if (!this.isHexString(string)) {
            throw new PDFCMapParseException("error parsing cmap hexadecimal string");
        }
    }

    private int hexStringToInt(String string) {
        this.ensureHexString(string);
        int n = string.length() - 2;
        String string2 = string.substring(1, n + 1);
        return Integer.valueOf(string2, 16);
    }

    private byte[] hexStringToByteArray(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[(byArray.length - 2) / 2];
        int n = 1;
        int n2 = byArray.length - 1;
        int n3 = 0;
        for (int i = n; i < n2; i += 2) {
            byte by = CosToken.toHexDigit(byArray[i]);
            byte by2 = CosToken.toHexDigit(byArray[i + 1]);
            byArray2[n3++] = (byte)(by * 16 + by2);
        }
        return byArray2;
    }
}

