/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;

public class PDFWritingMode {
    private final int mode;
    public static final PDFWritingMode HORIZONTAL = new PDFWritingMode(0);
    public static final PDFWritingMode VERTICAL = new PDFWritingMode(1);

    private PDFWritingMode(int n) {
        this.mode = n;
    }

    public String toString() {
        String string = null;
        switch (this.mode) {
            case 0: {
                string = "horizontal writing mode";
                break;
            }
            case 1: {
                string = "vertical writing mode";
            }
        }
        return string;
    }

    int getValue() {
        return this.mode;
    }

    public static final PDFWritingMode getWritingModeForValue(int n) {
        PDFWritingMode pDFWritingMode = null;
        switch (n) {
            case 0: {
                pDFWritingMode = HORIZONTAL;
                break;
            }
            case 1: {
                pDFWritingMode = VERTICAL;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("illegal writing mode value");
            }
        }
        return pDFWritingMode;
    }
}

