/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCIDSystemInfo;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFWritingMode;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.exceptions.PDFUnsupportedCMapException;

public class PDFType0FontEncoding
extends PDFCosObject
implements PDFInstantiate {
    PDFType0FontEncoding(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFType0FontEncoding", cosObject);
    }

    public boolean isPredefinedCMap() {
        return this.mCosObject instanceof CosName;
    }

    public ASName getCMapName() {
        if (this.mCosObject instanceof CosName) {
            return ((CosName)this.mCosObject).nameValue();
        }
        return this.getCosDictionary().getName(ASName.k_CMapName);
    }

    public PDFCIDSystemInfo getCIDSystemInfo() {
        if (this.mCosObject instanceof CosName) {
            throw new PDFUnsupportedCMapException("need to handle pre-defined CMaps");
        }
        CosObject cosObject = this.getCosDictionary().get(ASName.k_CIDSystemInfo);
        return (PDFCIDSystemInfo)PDFCIDSystemInfo.instantiate(cosObject);
    }

    public PDFWritingMode getWMode() {
        if (this.mCosObject instanceof CosName) {
            if (((CosName)this.mCosObject).nameValue() == ASName.k_Identity_H) {
                return PDFWritingMode.HORIZONTAL;
            }
            if (((CosName)this.mCosObject).nameValue() == ASName.k_Identity_V) {
                return PDFWritingMode.VERTICAL;
            }
            throw new PDFUnsupportedCMapException("need to handle pre-defined CMaps");
        }
        if (this.getCosDictionary().containsKey(ASName.k_WMode)) {
            int n = this.getCosDictionary().getInt(ASName.k_WMode);
            return PDFWritingMode.getWritingModeForValue(n);
        }
        return PDFWritingMode.HORIZONTAL;
    }

    public PDFType0FontEncoding getUseCMap() {
        if (this.mCosObject instanceof CosName) {
            throw new PDFUnsupportedCMapException("need to handle pre-defined CMaps");
        }
        if (this.getCosDictionary().containsKey(ASName.k_UseCMap)) {
            CosObject cosObject = this.getCosDictionary().get(ASName.k_UseCMap);
            return (PDFType0FontEncoding)PDFType0FontEncoding.instantiate(cosObject);
        }
        return null;
    }
}

