/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.CMapCodeMapping;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.ToUnicodeCMapParser;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.AdobeGlyphList;
import com.adobe.internal.pdf.cos.util.exceptions.PDFUnsupportedCMapException;
import java.util.HashSet;
import java.util.Iterator;

public class PDFToUnicodeCMap
extends PDFCosObject
implements PDFInstantiate {
    private HashSet toUnicodeMaps;

    PDFToUnicodeCMap(CosObject cosObject) {
        super(cosObject);
        if (cosObject instanceof CosStream) {
            this.toUnicodeMaps = ToUnicodeCMapParser.parseCMap(this.getCosStream().getStream());
        } else if (cosObject instanceof CosName) {
            throw new PDFUnsupportedCMapException("we currently don't handle pre-defined cmaps");
        }
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFToUnicodeCMap", cosObject);
    }

    public String toUnicode(ASString aSString, boolean bl) {
        String string = null;
        if (bl) {
            char[] cArray = aSString.getChars();
            string = this.toUnicode(cArray, 0, cArray.length);
        } else {
            byte[] byArray = aSString.getBytes();
            string = this.toUnicode(byArray, 0, byArray.length);
        }
        return string;
    }

    public String toUnicode(byte[] byArray, int n, int n2) {
        if (n2 > 0 && byArray != null) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(this.toUnicode(byArray[i]));
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toUnicode(char[] cArray, int n, int n2) {
        if (n2 > 0 && cArray != null) {
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(this.toUnicode(cArray[i]));
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public char[] toUnicode(int n) {
        char[] cArray = new char[]{'\ufffd'};
        Iterator iterator = this.toUnicodeMaps.iterator();
        while (iterator.hasNext()) {
            CMapCodeMapping cMapCodeMapping = (CMapCodeMapping)iterator.next();
            if (!cMapCodeMapping.contains(n)) continue;
            if (cMapCodeMapping.isHexData(n)) {
                return cMapCodeMapping.getHexDataAsCharArray(n);
            }
            AdobeGlyphList adobeGlyphList = AdobeGlyphList.get();
            ASName aSName = ASName.create(cMapCodeMapping.getCharName(n));
            return adobeGlyphList.toUnicode(aSName);
        }
        return cArray;
    }

    public int fromUnicode(char c) {
        int n = 0;
        Iterator iterator = this.toUnicodeMaps.iterator();
        while (iterator.hasNext()) {
            CMapCodeMapping cMapCodeMapping = (CMapCodeMapping)iterator.next();
            int n2 = cMapCodeMapping.getStartCode();
            int n3 = cMapCodeMapping.getEndCode();
            for (n = n2; n <= n3; ++n) {
                char[] cArray = null;
                if (cMapCodeMapping.isHexData(n)) {
                    cArray = cMapCodeMapping.getHexDataAsCharArray(n);
                } else {
                    AdobeGlyphList adobeGlyphList = AdobeGlyphList.get();
                    ASName aSName = ASName.create(cMapCodeMapping.getCharName(n));
                    cArray = adobeGlyphList.toUnicode(aSName);
                }
                if (cArray.length != 1 || cArray[0] != c) continue;
                return n;
            }
        }
        return n;
    }

    PDFToUnicodeCMap getUseCMap() {
        return (PDFToUnicodeCMap)PDFToUnicodeCMap.instantiate(this.getValue(ASName.k_UseCMap));
    }
}

