/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ByteArrayByteRepository;
import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import com.adobe.internal.pdf.cos.util.exceptions.PDFIllegalStateException;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;

public class PDFText
extends PDFCosObject {
    PDFText(CosObject cosObject) {
        super(cosObject);
        int n = cosObject.getType();
        if (n != 7 && n != 4) {
            throw new PDFInvalidParameterException("attempt to construct PDF text from non-text object");
        }
    }

    private PDFText(String string, PDFDocument pDFDocument) {
        super(pDFDocument.getDocument().newString(string));
    }

    private PDFText(PDFDocument pDFDocument, String string) {
        super(pDFDocument.getDocument().newStream(new ByteBuffer(new ByteArrayByteRepository(PDFDocEncoding.fromUnicodeString(string)))));
    }

    public static PDFText create(PDFDocument pDFDocument, String string) {
        if (string.length() > 32000) {
            return new PDFText(pDFDocument, string);
        }
        return new PDFText(string, pDFDocument);
    }

    public static PDFText createString(PDFDocument pDFDocument, String string) {
        return new PDFText(string, pDFDocument);
    }

    public static PDFText createStream(PDFDocument pDFDocument, String string) {
        return new PDFText(pDFDocument, string);
    }

    public String stringValue() {
        int n = this.mCosObject.getType();
        byte[] byArray = null;
        if (n == 4) {
            byArray = ((CosString)this.mCosObject).byteArrayValue();
        } else if (n == 7) {
            CosStream cosStream = (CosStream)this.mCosObject;
            byArray = cosStream.getByteArray();
        } else {
            throw new PDFIllegalStateException("attempt to get PDF text from non-text object");
        }
        return PDFDocEncoding.toUnicodeString(byArray, 0, byArray.length);
    }

    public byte[] byteArrayValue() {
        int n = this.mCosObject.getType();
        if (n == 4) {
            return ((CosString)this.mCosObject).byteArrayValue();
        }
        if (n == 7) {
            return ((CosStream)this.mCosObject).getByteArray();
        }
        return null;
    }
}

