/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFEncodingDifferences;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.AdobeGlyphList;
import com.adobe.internal.pdf.cos.util.encodings.CharSetEncoding;
import com.adobe.internal.pdf.cos.util.encodings.Encoding;
import com.adobe.internal.pdf.cos.util.encodings.StandardCharSetEncodings;

public class PDFSimpleFontEncoding
extends PDFCosObject
implements PDFInstantiate,
Encoding {
    private CharSetEncoding fontBaseEncoding;

    PDFSimpleFontEncoding(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFSimpleFontEncoding", cosObject);
    }

    CharSetEncoding getBaseEncoding() {
        CharSetEncoding charSetEncoding = null;
        if (this.mCosObject instanceof CosName) {
            charSetEncoding = StandardCharSetEncodings.get(((CosName)this.mCosObject).nameValue());
        } else if (this.mCosObject instanceof CosDictionary && this.getCosDictionary().containsKey(ASName.k_BaseEncoding)) {
            ASName aSName = this.getCosDictionary().getName(ASName.k_BaseEncoding);
            charSetEncoding = StandardCharSetEncodings.get(aSName);
        }
        if (charSetEncoding == null) {
            charSetEncoding = this.getFontBaseEncoding();
        }
        return charSetEncoding;
    }

    PDFEncodingDifferences getDifferences() {
        PDFEncodingDifferences pDFEncodingDifferences = null;
        if (this.mCosObject instanceof CosDictionary) {
            if (this.getCosDictionary().containsKey(ASName.k_Differences)) {
                CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_Differences);
                return (PDFEncodingDifferences)PDFEncodingDifferences.instantiate(cosArray);
            }
            return null;
        }
        return pDFEncodingDifferences;
    }

    public String toUnicode(ASString aSString) {
        byte[] byArray = aSString.getBytes();
        return this.toUnicode(byArray, 0, byArray.length);
    }

    public String toUnicode(byte[] byArray, int n, int n2) {
        CharSetEncoding charSetEncoding = this.getBaseEncoding();
        PDFEncodingDifferences pDFEncodingDifferences = this.getDifferences();
        if (charSetEncoding == null) {
            charSetEncoding = this.fontBaseEncoding != null ? this.fontBaseEncoding : StandardCharSetEncodings.get(ASName.k_StandardEncoding);
        }
        if (n2 > 0 && byArray != null) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            for (int i = n; i < n2; ++i) {
                char[] cArray = new char[1];
                int n3 = byArray[i] & 0xFF;
                if (pDFEncodingDifferences != null && pDFEncodingDifferences.contains(n3)) {
                    cArray = pDFEncodingDifferences.toUnicode(n3);
                } else if (charSetEncoding != null) {
                    cArray = charSetEncoding.toUnicode(byArray[i]);
                } else {
                    cArray[0] = 65533;
                }
                stringBuffer.append(cArray);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public char[] toUnicode(byte by) {
        CharSetEncoding charSetEncoding = this.getBaseEncoding();
        PDFEncodingDifferences pDFEncodingDifferences = this.getDifferences();
        char[] cArray = new char[1];
        if (pDFEncodingDifferences != null && pDFEncodingDifferences.contains(by)) {
            cArray = pDFEncodingDifferences.toUnicode(by);
        } else if (charSetEncoding != null) {
            cArray = charSetEncoding.toUnicode(by);
        } else {
            cArray[0] = 65533;
        }
        return cArray;
    }

    public int fromUnicode(char c) {
        AdobeGlyphList adobeGlyphList;
        ASName[] aSNameArray;
        CharSetEncoding charSetEncoding = this.getBaseEncoding();
        PDFEncodingDifferences pDFEncodingDifferences = this.getDifferences();
        boolean bl = false;
        int n = 0;
        if (pDFEncodingDifferences != null && pDFEncodingDifferences.contains((aSNameArray = (adobeGlyphList = AdobeGlyphList.get()).fromUnicode(c))[0])) {
            n = pDFEncodingDifferences.fromGlyphName(aSNameArray[0]);
            bl = true;
        }
        if (!bl) {
            if (charSetEncoding == null) {
                charSetEncoding = StandardCharSetEncodings.get(ASName.k_StandardEncoding);
            }
            n = charSetEncoding.fromUnicode(c);
        }
        return n;
    }

    CharSetEncoding getFontBaseEncoding() {
        return this.fontBaseEncoding;
    }

    void setFontBaseEncoding(CharSetEncoding charSetEncoding) {
        this.fontBaseEncoding = charSetEncoding;
    }
}

