/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;

public final class PDFRenderingIntent {
    private final ASName intent;
    public static final PDFRenderingIntent ABSOLUTE_COLORIMETRIC = new PDFRenderingIntent(ASName.k_AbsoluteColorimetric);
    public static final PDFRenderingIntent RELATIVE_COLORIMETRIC = new PDFRenderingIntent(ASName.k_RelativeColorimetric);
    public static final PDFRenderingIntent SATURATION = new PDFRenderingIntent(ASName.k_Saturation);
    public static final PDFRenderingIntent PERCEPTUAL = new PDFRenderingIntent(ASName.k_Perceptual);

    private PDFRenderingIntent(ASName aSName) {
        this.intent = aSName;
    }

    public String toString() {
        return this.intent.toString();
    }

    ASName getValue() {
        return this.intent;
    }

    public static final PDFRenderingIntent getIntentForValue(ASName aSName) {
        PDFRenderingIntent pDFRenderingIntent = null;
        if (aSName == ASName.k_AbsoluteColorimetric) {
            pDFRenderingIntent = ABSOLUTE_COLORIMETRIC;
        } else if (aSName == ASName.k_RelativeColorimetric) {
            pDFRenderingIntent = RELATIVE_COLORIMETRIC;
        } else if (aSName == ASName.k_Saturation) {
            pDFRenderingIntent = SATURATION;
        } else if (aSName == ASName.k_Perceptual) {
            pDFRenderingIntent = PERCEPTUAL;
        } else {
            throw new PDFInvalidParameterException("illegal rendering intent value");
        }
        return pDFRenderingIntent;
    }
}

