/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;

public class PDFRectangle
extends PDFCosObject
implements PDFInstantiate {
    PDFRectangle(CosObject cosObject) {
        super((CosArray)cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFRectangle", cosObject);
    }

    static PDFRectangle create(PDFDocument pDFDocument, double d, double d2, double d3, double d4) {
        PDFRectangle pDFRectangle = (PDFRectangle)PDFCosFactory.newArray(pDFDocument, "PDFRectangle");
        CosArray cosArray = pDFRectangle.getCosArray();
        cosArray.addDouble(d);
        cosArray.addDouble(d2);
        cosArray.addDouble(d3);
        cosArray.addDouble(d4);
        return pDFRectangle;
    }

    double[] getValues() {
        CosArray cosArray = this.getCosArray();
        double[] dArray = new double[]{cosArray.getDouble(0), cosArray.getDouble(1), cosArray.getDouble(2), cosArray.getDouble(3)};
        return dArray;
    }

    public double llx() {
        return this.getCosArray().getDouble(0);
    }

    public double lly() {
        return this.getCosArray().getDouble(1);
    }

    public double urx() {
        return this.getCosArray().getDouble(2);
    }

    public double ury() {
        return this.getCosArray().getDouble(3);
    }

    public double left() {
        return this.llx();
    }

    public double bottom() {
        return this.lly();
    }

    public double right() {
        return this.urx();
    }

    public double top() {
        return this.ury();
    }

    public double width() {
        return Math.abs(this.urx() - this.llx());
    }

    public double height() {
        return Math.abs(this.ury() - this.lly());
    }
}

