/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFAnnotationList;
import com.adobe.internal.pdf.PDFAnnotationPopup;
import com.adobe.internal.pdf.PDFContents;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.pdf.PDFPageTreeNode;
import com.adobe.internal.pdf.PDFRectangle;
import com.adobe.internal.pdf.PDFResources;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.pdf.exceptions.PDFParseException;

public class PDFPage
extends PDFCosObject
implements PDFInstantiate {
    PDFPage(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFPage", cosObject);
    }

    public PDFPageTreeNode getParent() {
        return (PDFPageTreeNode)PDFPageTreeNode.instantiate(this.getValue(ASName.k_Parent));
    }

    public int getIndex() {
        PDFPage pDFPage;
        int n = 0;
        PDFPageTree pDFPageTree = this.getPDFDocument().requirePages();
        while ((pDFPage = pDFPageTree.getPage(n++)) != null) {
            if (!pDFPage.equals(this)) continue;
            return n - 1;
        }
        throw new PDFParseException("Cannot calculate the PDF page ordinal number");
    }

    public PDFAnnotationList getAnnotationList() {
        return (PDFAnnotationList)PDFAnnotationList.instantiate(this.getValue(ASName.k_Annots));
    }

    public void setAnnotationList(PDFAnnotationList pDFAnnotationList) {
        this.setValue(ASName.k_Annots, pDFAnnotationList.getCosObject());
    }

    public void deleteAnnotationList() {
        CosArray cosArray = this.getPDFDocument().getDocument().newArray();
        this.setValue(ASName.k_Annots, cosArray);
    }

    public PDFResources getResources() {
        return (PDFResources)PDFResources.instantiate(this.getValue(ASName.k_Resources));
    }

    public PDFContents getContents() {
        return (PDFContents)PDFContents.instantiate(this.getValue(ASName.k_Contents));
    }

    public PDFRectangle getMediaBox() {
        if (this.getCosDictionary().containsKey(ASName.k_MediaBox)) {
            return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_MediaBox));
        }
        return this.getParent().getMediaBox();
    }

    public PDFRectangle getCropBox() {
        if (this.getCosDictionary().containsKey(ASName.k_CropBox)) {
            return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_CropBox));
        }
        PDFRectangle pDFRectangle = this.getParent().getCropBox();
        if (pDFRectangle != null) {
            return pDFRectangle;
        }
        return this.getMediaBox();
    }

    public PDFRectangle getBleedBox() {
        if (this.getCosDictionary().containsKey(ASName.k_BleedBox)) {
            return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_BleedBox));
        }
        return this.getCropBox();
    }

    public PDFRectangle getTrimBox() {
        if (this.getCosDictionary().containsKey(ASName.k_TrimBox)) {
            return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_TrimBox));
        }
        return this.getCropBox();
    }

    public PDFRectangle getArtBox() {
        if (this.getCosDictionary().containsKey(ASName.k_ArtBox)) {
            return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_ArtBox));
        }
        return this.getCropBox();
    }

    public void addAnnotation(PDFAnnotation pDFAnnotation) {
        PDFAnnotation pDFAnnotation2;
        PDFAnnotationList pDFAnnotationList = this.getAnnotationList();
        if (pDFAnnotationList == null) {
            pDFAnnotationList = PDFAnnotationList.create(this.getPDFDocument());
            this.setAnnotationList(pDFAnnotationList);
        }
        if (pDFAnnotation.hasName() && (pDFAnnotation2 = pDFAnnotationList.findAnnotation(pDFAnnotation.getName())) != null) {
            PDFAnnotationPopup pDFAnnotationPopup = pDFAnnotation2.getAnnotationPopup();
            pDFAnnotationList.remove(pDFAnnotation2);
            if (pDFAnnotationPopup != null) {
                pDFAnnotationList.remove(pDFAnnotationPopup);
            }
        }
        if (!pDFAnnotation.hasParent()) {
            pDFAnnotation.setParent(this);
        }
        pDFAnnotationList.add(pDFAnnotation);
    }
}

