/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFNameTreeList;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import java.util.Iterator;

public class PDFNameTreeNode
extends PDFCosObject
implements PDFInstantiate {
    private final int kSplitNumber = 6;

    PDFNameTreeNode(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFNameTreeNode", cosObject);
    }

    static PDFNameTreeNode create(PDFDocument pDFDocument, PDFNameTreeList pDFNameTreeList) {
        PDFNameTreeNode pDFNameTreeNode = (PDFNameTreeNode)PDFCosFactory.newDictionary(pDFDocument, "PDFNameTreeNode");
        pDFNameTreeNode.getCosDictionary().put(ASName.k_Kids, pDFNameTreeList.getCosObject());
        pDFNameTreeNode.resetLimits();
        return pDFNameTreeNode;
    }

    PDFNameTreeList getChildren() {
        return (PDFNameTreeList)PDFNameTreeList.instantiate(this.getValue(ASName.k_Kids));
    }

    void resetLimits() {
        PDFNameTreeList pDFNameTreeList = this.getChildren();
        PDFNameTreeNode pDFNameTreeNode = (PDFNameTreeNode)pDFNameTreeList.get(0);
        this.setLimitLower(pDFNameTreeNode.getLimitLower());
        pDFNameTreeNode = (PDFNameTreeNode)pDFNameTreeList.get(pDFNameTreeList.size() - 1);
        this.setLimitUpper(pDFNameTreeNode.getLimitUpper());
    }

    ASString getLimitLower() {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Limits);
        if (cosArray == null) {
            return null;
        }
        return cosArray.getString(0);
    }

    ASString getLimitUpper() {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Limits);
        if (cosArray == null) {
            return null;
        }
        return cosArray.getString(1);
    }

    void setLimits(ASString aSString, ASString aSString2) {
        this.setLimitLower(aSString);
        this.setLimitUpper(aSString2);
    }

    void setLimitLower(ASString aSString) {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Limits);
        if (cosArray != null) {
            cosArray.setString(0, aSString);
            return;
        }
        cosArray = this.getCosObject().getDocument().newArray();
        cosArray.addString(aSString);
        cosArray.addString(aSString);
        this.setValue(ASName.k_Limits, cosArray);
    }

    void setLimitUpper(ASString aSString) {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Limits);
        if (cosArray != null) {
            cosArray.setString(1, aSString);
            return;
        }
        cosArray = this.getCosObject().getDocument().newArray();
        cosArray.setString(0, aSString);
        cosArray.setString(1, aSString);
        this.setValue(ASName.k_Limits, cosArray);
    }

    int inRange(ASString aSString) {
        ASString aSString2 = this.getLimitLower();
        if (aSString2 != null && aSString.compareTo(aSString2) < 0) {
            return -1;
        }
        ASString aSString3 = this.getLimitUpper();
        if (aSString3 != null && aSString.compareTo(aSString3) > 0) {
            return 1;
        }
        return 0;
    }

    CosObject getValue(ASString aSString) {
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            PDFNameTreeNode pDFNameTreeNode = (PDFNameTreeNode)iterator.next();
            if (pDFNameTreeNode.inRange(aSString) != 0) continue;
            return pDFNameTreeNode.getValue(aSString);
        }
        return null;
    }

    boolean removeKid(PDFNameTreeNode pDFNameTreeNode) {
        PDFNameTreeList pDFNameTreeList = this.getChildren();
        if (pDFNameTreeList == null) {
            return false;
        }
        return pDFNameTreeList.remove(pDFNameTreeNode);
    }

    boolean isEmpty() {
        PDFNameTreeList pDFNameTreeList = this.getChildren();
        if (pDFNameTreeList == null) {
            return true;
        }
        return pDFNameTreeList.isEmpty();
    }

    boolean deleteValue(ASString aSString) {
        PDFNameTreeList pDFNameTreeList = this.getChildren();
        if (pDFNameTreeList == null) {
            return false;
        }
        Iterator iterator = pDFNameTreeList.iterator();
        while (iterator.hasNext()) {
            PDFNameTreeNode pDFNameTreeNode = (PDFNameTreeNode)iterator.next();
            if (pDFNameTreeNode.inRange(aSString) != 0 || !pDFNameTreeNode.deleteValue(aSString)) continue;
            if (pDFNameTreeNode.isEmpty()) {
                this.removeKid(pDFNameTreeNode);
                if (!this.isEmpty()) {
                    this.resetLimits();
                }
            }
            return true;
        }
        return false;
    }

    PDFNameTreeNode putValue(ASString aSString, CosObject cosObject, boolean bl) {
        PDFNameTreeList pDFNameTreeList = this.getChildren().putValue(aSString, cosObject, bl);
        this.resetLimits();
        if (pDFNameTreeList == null) {
            return null;
        }
        PDFNameTreeNode pDFNameTreeNode = PDFNameTreeNode.create(this.getPDFDocument(), pDFNameTreeList);
        this.getChildren().add(pDFNameTreeNode);
        this.resetLimits();
        return null;
    }

    Iterator iterator() {
        return new PDFNameTreeNodeKeyIterator(this.getChildren());
    }

    class PDFNameTreeNodeKeyIterator
    implements Iterator {
        private Iterator mKids;
        private PDFNameTreeNode mKid;
        private Iterator mKidIterator;

        PDFNameTreeNodeKeyIterator(PDFNameTreeList pDFNameTreeList) {
            if (pDFNameTreeList == null) {
                return;
            }
            this.mKid = null;
            this.mKids = pDFNameTreeList.iterator();
            if (this.mKids.hasNext()) {
                this.mKid = (PDFNameTreeNode)this.mKids.next();
                this.mKidIterator = this.mKid.iterator();
            }
        }

        public boolean hasNext() {
            if (this.mKid == null) {
                return false;
            }
            if (this.mKidIterator.hasNext()) {
                return true;
            }
            if (!this.mKids.hasNext()) {
                return false;
            }
            this.mKid = (PDFNameTreeNode)this.mKids.next();
            this.mKidIterator = this.mKid.iterator();
            return this.mKidIterator.hasNext();
        }

        public Object next() {
            return this.mKidIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

