/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosArrayList;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFNameTreeLeaf;
import com.adobe.internal.pdf.PDFNameTreeNode;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import java.util.Iterator;

public class PDFNameTreeList
extends PDFCosArrayList
implements PDFInstantiate {
    private final int kSplitNumber = 4;

    PDFNameTreeList(CosObject cosObject) {
        super((CosArray)cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFNameTreeList", cosObject);
    }

    static PDFNameTreeList create(PDFDocument pDFDocument, CosArray cosArray) {
        PDFNameTreeList pDFNameTreeList = (PDFNameTreeList)PDFCosFactory.newObject(cosArray, "PDFNameTreeList");
        return pDFNameTreeList;
    }

    static PDFNameTreeList create(PDFDocument pDFDocument) {
        PDFNameTreeList pDFNameTreeList = (PDFNameTreeList)PDFCosFactory.newArray(pDFDocument, "PDFNameTreeList");
        return pDFNameTreeList;
    }

    static PDFNameTreeList create(PDFDocument pDFDocument, PDFNameTreeNode pDFNameTreeNode) {
        PDFNameTreeList pDFNameTreeList = (PDFNameTreeList)PDFCosFactory.newArray(pDFDocument, "PDFNameTreeList");
        pDFNameTreeList.add(pDFNameTreeNode);
        return pDFNameTreeList;
    }

    Object itemInstantiator(CosObject cosObject) {
        CosDictionary cosDictionary = (CosDictionary)cosObject;
        if (cosDictionary.containsKey(ASName.k_Names)) {
            return PDFNameTreeLeaf.instantiate(cosObject);
        }
        return PDFNameTreeNode.instantiate(cosObject);
    }

    PDFNameTreeList split() {
        if (this.size() <= 4) {
            return null;
        }
        CosArray cosArray = this.getCosArray().splitBefore(this.size() / 2);
        PDFNameTreeList pDFNameTreeList = PDFNameTreeList.create(this.getPDFDocument(), cosArray);
        return pDFNameTreeList;
    }

    PDFNameTreeList putValue(ASString aSString, CosObject cosObject, boolean bl) {
        int n = 0;
        PDFNameTreeNode pDFNameTreeNode = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            pDFNameTreeNode = (PDFNameTreeNode)iterator.next();
            if (pDFNameTreeNode.inRange(aSString) <= 0) {
                PDFNameTreeNode pDFNameTreeNode2 = pDFNameTreeNode.putValue(aSString, cosObject, bl);
                if (pDFNameTreeNode2 != null) {
                    this.add(n + 1, pDFNameTreeNode2);
                }
                return this.split();
            }
            ++n;
        }
        PDFNameTreeNode pDFNameTreeNode3 = pDFNameTreeNode.putValue(aSString, cosObject, bl);
        if (pDFNameTreeNode3 != null) {
            this.add(pDFNameTreeNode3);
        }
        return this.split();
    }

    class PDFNameTreeListKeyIterator
    implements Iterator {
        private Iterator mKids;
        private Iterator mKid;

        PDFNameTreeListKeyIterator() {
            this.mKids = PDFNameTreeList.this.iterator();
            PDFNameTreeNode pDFNameTreeNode = (PDFNameTreeNode)this.mKids.next();
            this.mKid = pDFNameTreeNode.iterator();
        }

        public boolean hasNext() {
            if (this.mKid.hasNext()) {
                return true;
            }
            if (!this.mKids.hasNext()) {
                return false;
            }
            PDFNameTreeNode pDFNameTreeNode = (PDFNameTreeNode)this.mKids.next();
            this.mKid = pDFNameTreeNode.iterator();
            return this.mKid.hasNext();
        }

        public Object next() {
            return this.mKid.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

