/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFNameTreeNode;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosNull;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;
import java.util.Iterator;

public class PDFNameTreeLeaf
extends PDFNameTreeNode
implements PDFInstantiate {
    private final int kSplitNumber = 4;

    PDFNameTreeLeaf(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFNameTreeLeaf", cosObject);
    }

    static PDFNameTreeLeaf create(PDFDocument pDFDocument, ASString aSString, CosObject cosObject) {
        PDFNameTreeLeaf pDFNameTreeLeaf = (PDFNameTreeLeaf)PDFCosFactory.newDictionary(pDFDocument, "PDFNameTreeLeaf");
        pDFNameTreeLeaf.setLimits(aSString, aSString);
        pDFNameTreeLeaf.addValue(aSString, cosObject);
        return pDFNameTreeLeaf;
    }

    static PDFNameTreeLeaf create(PDFDocument pDFDocument, CosArray cosArray) {
        PDFNameTreeLeaf pDFNameTreeLeaf = (PDFNameTreeLeaf)PDFCosFactory.newDictionary(pDFDocument, "PDFNameTreeLeaf");
        pDFNameTreeLeaf.getCosDictionary().put(ASName.k_Names, cosArray);
        pDFNameTreeLeaf.resetLimits();
        return pDFNameTreeLeaf;
    }

    int inRange(ASString aSString) {
        int n = 0;
        ASString aSString2 = this.getLimitLower();
        if (aSString2 != null && (n = aSString.compareTo(aSString2)) <= 0) {
            return n;
        }
        ASString aSString3 = this.getLimitUpper();
        if (aSString3 != null && (n = aSString.compareTo(aSString3)) >= 0) {
            return n;
        }
        return 0;
    }

    CosObject getValue(ASString aSString) {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Names);
        for (int i = 0; i < cosArray.size(); i += 2) {
            ASString aSString2 = cosArray.getString(i);
            if (aSString2.compareTo(aSString) != 0) continue;
            return cosArray.get(i + 1);
        }
        return null;
    }

    boolean isEmpty() {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Names);
        if (cosArray == null || cosArray instanceof CosNull) {
            return true;
        }
        return cosArray.isEmpty();
    }

    boolean deleteValue(ASString aSString) {
        if (this.inRange(aSString) != 0) {
            return false;
        }
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Names);
        int n = cosArray.size();
        for (int i = 0; i < n; i += 2) {
            ASString aSString2 = cosArray.getString(i);
            if (aSString2.compareTo(aSString) != 0) continue;
            cosArray.remove(i);
            cosArray.remove(i);
            if (cosArray.size() != 0) {
                this.resetLimits();
            }
            return true;
        }
        return false;
    }

    PDFNameTreeNode addValue(ASString aSString, CosObject cosObject) {
        return this.putValue(aSString, cosObject, false);
    }

    PDFNameTreeNode replaceValue(ASString aSString, CosObject cosObject) {
        return this.putValue(aSString, cosObject, true);
    }

    PDFNameTreeNode putValue(ASString aSString, CosObject cosObject, boolean bl) {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Names);
        if (cosArray == null) {
            CosArray cosArray2 = this.getPDFDocument().getDocument().newArray();
            cosArray2.addString(aSString);
            cosArray2.add(cosObject);
            this.setValue(ASName.k_Names, cosArray2);
            this.setLimits(aSString, aSString);
            return null;
        }
        boolean bl2 = false;
        int n = cosArray.size();
        for (int i = 0; i < n && !bl2; i += 2) {
            CosString cosString = (CosString)cosArray.get(i);
            int n2 = cosString.stringValue().compareTo(aSString);
            if (n2 < 0) continue;
            if (!bl && n2 == 0) {
                throw new PDFInvalidParameterException("Embedded file already associated with this name, " + aSString);
            }
            if (bl && n2 == 0) {
                cosArray.setString(i, aSString);
                cosArray.set(i + 1, cosObject);
            } else {
                cosArray.add(i, cosObject);
                cosArray.addString(i, aSString);
            }
            bl2 = true;
        }
        if (!bl2) {
            cosArray.addString(aSString);
            cosArray.add(cosObject);
        }
        this.resetLimits();
        return this.split();
    }

    void resetLimits() {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Names);
        if (cosArray == null) {
            return;
        }
        this.setLimitLower(cosArray.getString(0));
        this.setLimitUpper(cosArray.getString(cosArray.size() - 2));
    }

    private CosArray split(CosArray cosArray) {
        int n = cosArray.size() >> 1;
        if (n <= 4) {
            return null;
        }
        n = n >> 1 << 1;
        return cosArray.splitBefore(n);
    }

    PDFNameTreeNode split() {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_Names);
        CosArray cosArray2 = this.split(cosArray);
        if (cosArray2 == null) {
            return null;
        }
        this.resetLimits();
        PDFNameTreeLeaf pDFNameTreeLeaf = PDFNameTreeLeaf.create(this.getPDFDocument(), cosArray2);
        return pDFNameTreeLeaf;
    }

    Iterator iterator() {
        return new PDFNameTreeLeafKeyIterator();
    }

    class PDFNameTreeLeafKeyIterator
    implements Iterator {
        private Iterator mIterator;

        PDFNameTreeLeafKeyIterator() {
            CosArray cosArray = (CosArray)PDFNameTreeLeaf.this.getValue(ASName.k_Names);
            this.mIterator = cosArray.iterator();
        }

        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        public Object next() {
            ASString aSString = ((CosString)this.mIterator.next()).stringValue();
            this.mIterator.next();
            return aSString;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

