/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.pdf.exceptions.XMPException;
import com.adobe.pdf.exceptions.XMPParseException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PDFMetadata
extends PDFCosObject
implements PDFInstantiate {
    private static final byte[] xmptag = new byte[]{60, 120, 58, 120, 109, 112, 109, 101, 116, 97};
    private static final byte[] xmpendtag = new byte[]{60, 47, 120, 58, 120, 109, 112, 109, 101, 116, 97};
    private static final byte[] closetag = new byte[]{62};

    PDFMetadata(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFMetadata", cosObject);
    }

    public static PDFMetadata create(PDFDocument pDFDocument, InputStream inputStream, int n) throws IOException {
        ByteStream byteStream = new ByteStream(inputStream);
        if (byteStream.limit() <= 0L) {
            throw new IllegalArgumentException("Empty InputStream");
        }
        byte[] byArray = new byte[]{120, 58, 120, 109, 112, 109, 101, 116, 97};
        if (!byteStream.exists(byArray, 1024L)) {
            throw new XMPParseException("No x:xmp marker");
        }
        PDFMetadata pDFMetadata = (PDFMetadata)PDFCosFactory.newStream(pDFDocument, "PDFMetadata");
        pDFMetadata.setDictionaryNameValue(ASName.k_Type, ASName.k_Metadata);
        pDFMetadata.setDictionaryNameValue(ASName.k_Subtype, ASName.k_XML);
        pDFMetadata.setData(inputStream, n);
        return pDFMetadata;
    }

    public InputStream getData() throws IOException {
        CosStream cosStream = this.getCosStream();
        ByteStream byteStream = cosStream.getStream();
        ByteStream byteStream2 = new ByteStream(byteStream);
        long l = byteStream2.indexOf(xmptag);
        if (l != -1L) {
            long l2 = byteStream2.indexOf(xmpendtag);
            long l3 = -1L;
            if (l2 != -1L) {
                byteStream2.setPosition(l2);
                l3 = byteStream2.indexOf(closetag);
            }
            if (l3 == -1L) {
                l3 = byteStream2.limit() - 1L;
            }
            byteStream = byteStream.slice(l, l3 - l + 1L);
        }
        return byteStream;
    }

    public void setData(InputStream inputStream, int n) throws IOException {
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        try {
            Utility.transformToXML(new DataCopier(), inputStream, outputByteBuffer);
        }
        catch (SAXException sAXException) {
            throw new XMPParseException(sAXException.getMessage());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XMPParseException(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new XMPParseException(transformerException.getMessage());
        }
        for (int i = 0; i < n; ++i) {
            outputByteBuffer.write(32);
        }
        this.getCosStream().newData(outputByteBuffer.getBuffer());
    }

    private static class DataCopier
    extends DefaultHandler
    implements XMLReader {
        ContentHandler mOutputHandler = null;

        DataCopier() {
        }

        public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setEntityResolver(EntityResolver entityResolver) {
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public void setDTDHandler(DTDHandler dTDHandler) {
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.mOutputHandler = contentHandler;
        }

        public ContentHandler getContentHandler() {
            return this.mOutputHandler;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public void parse(InputSource inputSource) throws IOException, SAXException {
            SAXParser sAXParser;
            if (this.mOutputHandler == null) {
                throw new SAXException("No content handler");
            }
            this.mOutputHandler.startDocument();
            InputStream inputStream = inputSource.getByteStream();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            try {
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMPException("internal error copying metadata");
            }
            sAXParser.parse(inputStream, (DefaultHandler)this);
            this.mOutputHandler.endDocument();
        }

        public void parse(String string) throws IOException, SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.mOutputHandler.startElement(string, string2, string3, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.mOutputHandler.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.mOutputHandler.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.mOutputHandler.processingInstruction(string, string2);
        }
    }
}

