/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;

public final class PDFLineJoin {
    private final int lineJoin;
    public static final PDFLineJoin MITER_JOIN = new PDFLineJoin(0);
    public static final PDFLineJoin ROUND_JOIN = new PDFLineJoin(1);
    public static final PDFLineJoin BEVEL_JOIN = new PDFLineJoin(2);

    private PDFLineJoin(int n) {
        this.lineJoin = n;
    }

    public String toString() {
        String string = null;
        switch (this.lineJoin) {
            case 0: {
                string = "miter join";
                break;
            }
            case 1: {
                string = "round join";
                break;
            }
            case 2: {
                string = "bevel join";
            }
        }
        return string;
    }

    int getValue() {
        return this.lineJoin;
    }

    public static final PDFLineJoin getLineJoinForValue(int n) {
        PDFLineJoin pDFLineJoin = null;
        switch (n) {
            case 0: {
                pDFLineJoin = MITER_JOIN;
                break;
            }
            case 1: {
                pDFLineJoin = ROUND_JOIN;
                break;
            }
            case 2: {
                pDFLineJoin = BEVEL_JOIN;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("illegal line join value");
            }
        }
        return pDFLineJoin;
    }
}

