/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;

public final class PDFLineCap {
    private final int lineCap;
    public static final PDFLineCap BUTT_CAP = new PDFLineCap(0);
    public static final PDFLineCap ROUND_CAP = new PDFLineCap(1);
    public static final PDFLineCap PROJECTING_SQUARE_CAP = new PDFLineCap(2);

    private PDFLineCap(int n) {
        this.lineCap = n;
    }

    public String toString() {
        String string = null;
        switch (this.lineCap) {
            case 0: {
                string = "butt cap";
                break;
            }
            case 1: {
                string = "round cap";
                break;
            }
            case 2: {
                string = "projecting square cap";
            }
        }
        return string;
    }

    int getValue() {
        return this.lineCap;
    }

    public static final PDFLineCap getLineCapForValue(int n) {
        PDFLineCap pDFLineCap = null;
        switch (n) {
            case 0: {
                pDFLineCap = BUTT_CAP;
                break;
            }
            case 1: {
                pDFLineCap = ROUND_CAP;
                break;
            }
            case 2: {
                pDFLineCap = PROJECTING_SQUARE_CAP;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("illegal line cap value");
            }
        }
        return pDFLineCap;
    }
}

