/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFFieldList;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xfa.PDFFormSupport;
import com.adobe.internal.xfdf.PDF2XFDFFormsReader;
import com.adobe.internal.xfdf.XFDF2PDFFormReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PDFInteractiveForm
extends PDFCosObject
implements PDFInstantiate {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

    PDFInteractiveForm(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFInteractiveForm", cosObject);
    }

    public void exportFormData(OutputStream outputStream) throws SAXException, TransformerConfigurationException, TransformerException {
        Utility.transformToXML(new PDF2XFDFFormsReader(this), null, outputStream);
    }

    public void importFormData(InputStream inputStream) throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        XFDF2PDFFormReader xFDF2PDFFormReader = new XFDF2PDFFormReader(this);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)xFDF2PDFFormReader);
    }

    public PDFFieldList getFieldList() {
        return (PDFFieldList)PDFFieldList.instantiate(this.getValue(ASName.k_Fields));
    }

    public void setNeedAppearances(boolean bl) {
        this.setDictionaryBooleanValue(ASName.k_NeedAppearances, bl);
    }

    public boolean hasXFA() {
        return this.dictionaryContains(ASName.k_XFA);
    }

    public CosObject getXFA() {
        return this.getCosDictionary().get(ASName.k_XFA);
    }

    public void importXFAData(InputStream inputStream) throws SAXException, TransformerConfigurationException, TransformerException {
        PDFFormSupport.importXFAData(this, inputStream);
    }

    public ByteStream exportXFAData() throws SAXException, TransformerConfigurationException, TransformerException {
        return PDFFormSupport.exportXFAData(this);
    }

    public CosObject putXFA(CosObject cosObject) {
        return this.getCosDictionary().put(ASName.k_XFA, cosObject);
    }
}

