/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCIDFont;
import com.adobe.internal.pdf.PDFCIDFontWidths;
import com.adobe.internal.pdf.PDFCIDVerticalMetrics;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFFont;
import com.adobe.internal.pdf.PDFFontFactory;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFToUnicodeCMap;
import com.adobe.internal.pdf.PDFType0FontEncoding;
import com.adobe.internal.pdf.PDFWritingMode;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASRectangle;
import com.adobe.pdf.exceptions.PDFException;

public class PDFFontType0
extends PDFFont
implements PDFInstantiate {
    PDFFontType0(CosObject cosObject) {
        super(cosObject);
    }

    public String toString() {
        return "Type0 Font: " + super.toString();
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFFontType0", cosObject);
    }

    public PDFType0FontEncoding getEncoding() {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_Encoding);
        return (PDFType0FontEncoding)PDFType0FontEncoding.instantiate(cosObject);
    }

    public PDFCIDFont getDescendantFont() {
        CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_DescendantFonts);
        return (PDFCIDFont)PDFFontFactory.instantiate(cosArray.get(0));
    }

    public PDFToUnicodeCMap getToUnicodeCMap() {
        if (this.getCosDictionary().containsKey(ASName.k_ToUnicode)) {
            CosObject cosObject = this.getCosDictionary().get(ASName.k_ToUnicode);
            return (PDFToUnicodeCMap)PDFToUnicodeCMap.instantiate(cosObject);
        }
        return null;
    }

    public PDFWritingMode getWritingMode() {
        return this.getEncoding().getWMode();
    }

    public int getCharCodeSize() {
        return 2;
    }

    public double getGlyphWidth(int n) {
        PDFCIDFont pDFCIDFont = this.getDescendantFont();
        PDFCIDFontWidths pDFCIDFontWidths = pDFCIDFont.getW();
        if (pDFCIDFontWidths != null && pDFCIDFontWidths.containsWidth(n)) {
            return pDFCIDFontWidths.getWidth(n);
        }
        return pDFCIDFont.getDW();
    }

    public double getGlyphHeight(int n) {
        PDFCIDFont pDFCIDFont = this.getDescendantFont();
        PDFCIDVerticalMetrics pDFCIDVerticalMetrics = pDFCIDFont.getW2();
        if (pDFCIDVerticalMetrics != null && pDFCIDVerticalMetrics.containsMetric(n)) {
            return pDFCIDVerticalMetrics.getVerticalDisplacement(n);
        }
        return pDFCIDFont.getDW2()[2];
    }

    public double getGlyphDisplacement(int n) {
        if (this.getWritingMode() == PDFWritingMode.HORIZONTAL) {
            return this.getGlyphWidth(n);
        }
        return this.getGlyphHeight(n);
    }

    public double getAscent() {
        return this.getDescendantFont().getFontDescriptor().getAscent();
    }

    public double getDescent() {
        return this.getDescendantFont().getFontDescriptor().getDescent();
    }

    public ASRectangle getBBox() {
        return this.getDescendantFont().getFontDescriptor().getFontBBox();
    }

    public char[] getUnicode(int n) {
        PDFToUnicodeCMap pDFToUnicodeCMap = this.getToUnicodeCMap();
        if (pDFToUnicodeCMap != null) {
            PDFType0FontEncoding pDFType0FontEncoding = this.getEncoding();
            ASName aSName = null;
            if (pDFType0FontEncoding.isPredefinedCMap()) {
                aSName = pDFType0FontEncoding.getCMapName();
                if (aSName == ASName.k_Identity_H || aSName == ASName.k_Identity_V) {
                    return pDFToUnicodeCMap.toUnicode(n);
                }
                throw new PDFException("need to handle other encodings");
            }
            throw new PDFException("need to handle custom cmap");
        }
        throw new PDFException("need to handle composite fonts using pre-defined cmaps");
    }

    public int getCharCode(char c) {
        PDFToUnicodeCMap pDFToUnicodeCMap = this.getToUnicodeCMap();
        if (pDFToUnicodeCMap != null) {
            PDFType0FontEncoding pDFType0FontEncoding = this.getEncoding();
            ASName aSName = null;
            if (pDFType0FontEncoding.isPredefinedCMap()) {
                aSName = pDFType0FontEncoding.getCMapName();
                if (aSName == ASName.k_Identity_H || aSName == ASName.k_Identity_V) {
                    return pDFToUnicodeCMap.fromUnicode(c);
                }
                throw new PDFException("need to handle other encodings");
            }
            throw new PDFException("need to handle custom cmap");
        }
        throw new PDFException("need to handle composite fonts using pre-defined cmaps");
    }
}

