/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.exceptions.PDFFontException;

public final class PDFFontStretch {
    private final ASName stretch;
    public static final PDFFontStretch ULTRA_CONDENSED = new PDFFontStretch(ASName.k_UltraCondensed);
    public static final PDFFontStretch EXTRA_CONDENSED = new PDFFontStretch(ASName.k_ExtraCondensed);
    public static final PDFFontStretch CONDENSED = new PDFFontStretch(ASName.k_Condensed);
    public static final PDFFontStretch SEMI_CONDENSED = new PDFFontStretch(ASName.k_SemiCondensed);
    public static final PDFFontStretch NORMAL = new PDFFontStretch(ASName.k_Normal);
    public static final PDFFontStretch SEMI_EXPANDED = new PDFFontStretch(ASName.k_SemiExpanded);
    public static final PDFFontStretch EXPANDED = new PDFFontStretch(ASName.k_Expanded);
    public static final PDFFontStretch EXTRA_EXPANDED = new PDFFontStretch(ASName.k_ExtraExpanded);
    public static final PDFFontStretch ULTRA_EXPANDED = new PDFFontStretch(ASName.k_UltraExpanded);

    private PDFFontStretch(ASName aSName) {
        this.stretch = aSName;
    }

    public String toString() {
        return this.stretch.toString();
    }

    ASName getValue() {
        return this.stretch;
    }

    public static final PDFFontStretch getFontStretchForValue(ASName aSName) {
        PDFFontStretch pDFFontStretch = null;
        if (aSName == ASName.k_UltraCondensed) {
            pDFFontStretch = ULTRA_CONDENSED;
        } else if (aSName == ASName.k_ExtraCondensed) {
            pDFFontStretch = EXTRA_CONDENSED;
        } else if (aSName == ASName.k_Condensed) {
            pDFFontStretch = CONDENSED;
        } else if (aSName == ASName.k_SemiCondensed) {
            pDFFontStretch = SEMI_CONDENSED;
        } else if (aSName == ASName.k_Normal) {
            pDFFontStretch = NORMAL;
        } else if (aSName == ASName.k_SemiExpanded) {
            pDFFontStretch = SEMI_EXPANDED;
        } else if (aSName == ASName.k_Expanded) {
            pDFFontStretch = EXPANDED;
        } else if (aSName == ASName.k_ExtraExpanded) {
            pDFFontStretch = EXTRA_EXPANDED;
        } else if (aSName == ASName.k_UltraExpanded) {
            pDFFontStretch = ULTRA_EXPANDED;
        } else {
            throw new PDFFontException("illegal font stretch value");
        }
        return pDFFontStretch;
    }
}

