/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFFont;
import com.adobe.internal.pdf.PDFFontDescriptor;
import com.adobe.internal.pdf.PDFSimpleFontEncoding;
import com.adobe.internal.pdf.PDFToUnicodeCMap;
import com.adobe.internal.pdf.PDFWritingMode;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASRectangle;
import com.adobe.internal.pdf.cos.util.encodings.CharSetEncoding;
import com.adobe.internal.pdf.cos.util.encodings.Encoding;
import com.adobe.internal.pdf.cos.util.encodings.StandardCharSetEncodings;
import com.adobe.internal.pdf.cos.util.encodings.StandardEncoding;
import com.adobe.internal.pdf.cos.util.exceptions.PDFFontException;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;
import java.util.HashMap;

public abstract class PDFFontSimple
extends PDFFont {
    private static HashMap encodedWidthsTables = new HashMap(16);
    private HashMap unicodeIndexedWidths = new HashMap();
    private static HashMap standardFontsNames = new HashMap();
    static final int[] widthsCourier;
    static final int[] widthsCourierOblique;
    static final int[] widthsCourierBold;
    static final int[] widthsCourierBoldOblique;
    static final int[] widthsHelvetica;
    static final int[] widthsHelveticaOblique;
    static final int[] widthsHelveticaBold;
    static final int[] widthsHelveticaBoldOblique;
    static final int[] widthsTimesRoman;
    static final int[] widthsTimesItalic;
    static final int[] widthsTimesBold;
    static final int[] widthsTimesBoldItalic;
    static final int[] widthsSymbol;
    static final int[] widthsZapfDingbats;
    private static HashMap standardFontsWidths;
    static final ASName[] widthsGlyphOrdering;
    private static HashMap glyphNameToUnicodeMap;
    private static HashMap unicodeToGlyphNameMap;

    PDFFontSimple(CosObject cosObject) {
        super(cosObject);
    }

    public String toString() {
        return super.toString();
    }

    public int getFirstChar() {
        CosDictionary cosDictionary = this.getCosDictionary();
        if (cosDictionary.containsKey(ASName.k_FirstChar)) {
            return cosDictionary.getInt(ASName.k_FirstChar);
        }
        if (this.isStandardFont()) {
            return this.getStandardFontChar(ASName.k_FirstChar);
        }
        throw new PDFFontException("simple font dictionary missing required FirstChar entry");
    }

    public int getLastChar() {
        CosDictionary cosDictionary = this.getCosDictionary();
        if (cosDictionary.containsKey(ASName.k_LastChar)) {
            return cosDictionary.getInt(ASName.k_LastChar);
        }
        if (this.isStandardFont()) {
            return this.getStandardFontChar(ASName.k_LastChar);
        }
        throw new PDFFontException("simple font dictionary missing required LastChar entry");
    }

    public int[] getWidths() {
        CosDictionary cosDictionary = this.getCosDictionary();
        if (cosDictionary.containsKey(ASName.k_Widths)) {
            int n = this.getLastChar() - this.getFirstChar() + 1;
            int[] nArray = new int[n];
            CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_Widths);
            int n2 = cosArray.size();
            if (n2 < n) {
                throw new PDFFontException("invalid widths table in font dictionary");
            }
            for (int i = 0; i < n2; ++i) {
                nArray[i] = cosArray.getInt(i);
            }
            return nArray;
        }
        if (this.isStandardFont()) {
            return this.getStandardFontWidths();
        }
        throw new PDFFontException("simple font dictionary missing required Widths entry");
    }

    public PDFFontDescriptor getFontDescriptor() {
        CosDictionary cosDictionary = this.getCosDictionary();
        if (cosDictionary.containsKey(ASName.k_FontDescriptor)) {
            CosDictionary cosDictionary2 = this.getCosDictionary().getCosDictionary(ASName.k_FontDescriptor);
            return PDFFontDescriptor.instantiate(cosDictionary2);
        }
        if (this.isStandardFont()) {
            return this.getStandardFontFontDescriptor();
        }
        return null;
    }

    public PDFSimpleFontEncoding getEncoding() {
        if (this.getCosDictionary().containsKey(ASName.k_Encoding)) {
            CosObject cosObject = this.getCosDictionary().get(ASName.k_Encoding);
            PDFSimpleFontEncoding pDFSimpleFontEncoding = (PDFSimpleFontEncoding)PDFSimpleFontEncoding.instantiate(cosObject);
            if (pDFSimpleFontEncoding.getFontBaseEncoding() == null) {
                ASName aSName;
                CharSetEncoding charSetEncoding = null;
                charSetEncoding = this.isStandardFont() ? ((aSName = this.getStandardFontProperName()) == ASName.k_Symbol ? StandardCharSetEncodings.get(ASName.k_SymbolEncoding) : (aSName == ASName.k_ZapfDingbats ? StandardCharSetEncodings.get(ASName.k_ZapfDingbatsEncoding) : StandardCharSetEncodings.get(ASName.k_StandardEncoding))) : StandardCharSetEncodings.get(ASName.k_StandardEncoding);
                pDFSimpleFontEncoding.setFontBaseEncoding(charSetEncoding);
            }
            return pDFSimpleFontEncoding;
        }
        return null;
    }

    public PDFToUnicodeCMap getToUnicodeCMap() {
        if (this.getCosDictionary().containsKey(ASName.k_ToUnicode)) {
            CosObject cosObject = this.getCosDictionary().get(ASName.k_ToUnicode);
            return (PDFToUnicodeCMap)PDFToUnicodeCMap.instantiate(cosObject);
        }
        return null;
    }

    public PDFWritingMode getWritingMode() {
        return PDFWritingMode.HORIZONTAL;
    }

    public double getGlyphWidth(int n) {
        if (n >= this.getFirstChar() && n <= this.getLastChar()) {
            int[] nArray = this.getWidths();
            if (nArray.length == 1) {
                return nArray[0];
            }
            return nArray[n - this.getFirstChar()];
        }
        PDFFontDescriptor pDFFontDescriptor = this.getFontDescriptor();
        if (pDFFontDescriptor != null) {
            return pDFFontDescriptor.getMissingWidth();
        }
        return 0.0;
    }

    public int getCharCodeSize() {
        return 1;
    }

    public double getGlyphHeight(int n) {
        return this.getAscent() + this.getDescent();
    }

    public double getGlyphDisplacement(int n) {
        return this.getGlyphWidth(n);
    }

    public double getAscent() {
        return this.getFontDescriptor().getAscent();
    }

    public double getDescent() {
        return this.getFontDescriptor().getDescent();
    }

    public ASRectangle getBBox() {
        return this.getFontDescriptor().getFontBBox();
    }

    public char[] getUnicode(int n) {
        PDFToUnicodeCMap pDFToUnicodeCMap = this.getToUnicodeCMap();
        if (pDFToUnicodeCMap != null) {
            return pDFToUnicodeCMap.toUnicode(n);
        }
        PDFSimpleFontEncoding pDFSimpleFontEncoding = this.getEncoding();
        if (pDFSimpleFontEncoding != null) {
            return pDFSimpleFontEncoding.toUnicode((byte)n);
        }
        StandardEncoding standardEncoding = StandardEncoding.getEncoding();
        return standardEncoding.toUnicode((byte)n);
    }

    public int getCharCode(char c) {
        PDFToUnicodeCMap pDFToUnicodeCMap = this.getToUnicodeCMap();
        if (pDFToUnicodeCMap != null) {
            return pDFToUnicodeCMap.fromUnicode(c);
        }
        PDFSimpleFontEncoding pDFSimpleFontEncoding = this.getEncoding();
        if (pDFSimpleFontEncoding != null) {
            return pDFSimpleFontEncoding.fromUnicode(c);
        }
        StandardEncoding standardEncoding = StandardEncoding.getEncoding();
        return standardEncoding.fromUnicode(c);
    }

    boolean isStandardFont() {
        return standardFontsNames.containsKey(this.getBaseFont());
    }

    private boolean isStandardFontOverridden() {
        CosDictionary cosDictionary = this.getCosDictionary();
        boolean bl = cosDictionary.containsKey(ASName.k_FirstChar);
        boolean bl2 = cosDictionary.containsKey(ASName.k_LastChar);
        boolean bl3 = cosDictionary.containsKey(ASName.k_Widths);
        boolean bl4 = cosDictionary.containsKey(ASName.k_FontDescriptor);
        return this.isStandardFont() && bl && bl2 && bl3 && bl4;
    }

    private ASName getStandardFontProperName() {
        Object var1_1 = null;
        if (this.isStandardFont()) {
            return (ASName)standardFontsNames.get(this.getBaseFont());
        }
        return null;
    }

    private int getStandardFontChar(ASName aSName) {
        if (aSName == ASName.k_FirstChar) {
            return 0;
        }
        if (aSName == ASName.k_LastChar) {
            return 255;
        }
        throw new PDFInvalidParameterException("invalid argument");
    }

    private int[] getStandardFontWidths() {
        ASName aSName;
        Object object;
        ASName aSName2 = this.getStandardFontProperName();
        int[] nArray = (int[])standardFontsWidths.get(aSName2);
        if (nArray.length == 1) {
            return nArray;
        }
        if (aSName2 == ASName.k_Symbol || aSName2 == ASName.k_ZapfDingbats) {
            return nArray;
        }
        Encoding encoding = this.getEncoding();
        if (encoding != null) {
            object = ((PDFSimpleFontEncoding)encoding).getBaseEncoding();
            aSName = object != null ? ((CharSetEncoding)object).getName() : ASName.k_StandardEncoding;
        } else {
            aSName = ASName.k_StandardEncoding;
            encoding = StandardCharSetEncodings.get(aSName);
        }
        object = this.getBaseFont() + "+" + aSName;
        if (!encodedWidthsTables.containsKey(object)) {
            int[] nArray2 = new int[256];
            for (int i = 0; i < 256; ++i) {
                ASName aSName3;
                int n;
                char[] cArray = encoding.toUnicode((byte)i);
                char c = cArray[0];
                int n2 = 0;
                if (c != '\ufffd' && (n = this.getGlyphNameIndex(aSName3 = (ASName)unicodeToGlyphNameMap.get(new Integer(c)))) != -1) {
                    n2 = nArray[n];
                }
                nArray2[i] = n2;
            }
            encodedWidthsTables.put(object, nArray2);
        }
        return (int[])encodedWidthsTables.get(object);
    }

    private PDFFontDescriptor getStandardFontFontDescriptor() {
        return PDFFontDescriptor.createForStandardFont(this.getStandardFontProperName());
    }

    private double getStandardFontGlyphDisplacement(int n) {
        return this.getStandardFontWidths()[n];
    }

    private int getGlyphNameIndex(ASName aSName) {
        for (int i = 0; i < widthsGlyphOrdering.length; ++i) {
            if (widthsGlyphOrdering[i] != aSName) continue;
            return i;
        }
        return -1;
    }

    /*
     * Opcode count of 16193 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        standardFontsNames.put(ASName.k_Times_Roman, ASName.k_Times_Roman);
        standardFontsNames.put(ASName.k_TimesNewRomanPSMT, ASName.k_Times_Roman);
        standardFontsNames.put(ASName.k_TimesNewRoman, ASName.k_Times_Roman);
        standardFontsNames.put(ASName.k_TimesNewRomanPS, ASName.k_Times_Roman);
        standardFontsNames.put(ASName.k_Times_Bold, ASName.k_Times_Bold);
        standardFontsNames.put(ASName.k_TimesNewRomanPS_BoldMT, ASName.k_Times_Bold);
        standardFontsNames.put(ASName.k_TimesNewRomanCommaBold, ASName.k_Times_Bold);
        standardFontsNames.put(ASName.k_TimesNewRomanPS_Bold, ASName.k_Times_Bold);
        standardFontsNames.put(ASName.k_TimesNewRoman_Bold, ASName.k_Times_Bold);
        standardFontsNames.put(ASName.k_Times_Italic, ASName.k_Times_Italic);
        standardFontsNames.put(ASName.k_TimesNewRomanPS_ItalicMT, ASName.k_Times_Italic);
        standardFontsNames.put(ASName.k_TimesNewRomanCommaItalic, ASName.k_Times_Italic);
        standardFontsNames.put(ASName.k_TimesNewRomanPS_Italic, ASName.k_Times_Italic);
        standardFontsNames.put(ASName.k_TimesNewRoman_Italic, ASName.k_Times_Italic);
        standardFontsNames.put(ASName.k_Times_BoldItalic, ASName.k_Times_BoldItalic);
        standardFontsNames.put(ASName.k_TimesNewRomanPS_BoldItalicMT, ASName.k_Times_BoldItalic);
        standardFontsNames.put(ASName.k_TimesNewRomanCommaBoldItalic, ASName.k_Times_BoldItalic);
        standardFontsNames.put(ASName.k_TimesNewRomanPS_BoldItalic, ASName.k_Times_BoldItalic);
        standardFontsNames.put(ASName.k_TimesNewRoman_BoldItalic, ASName.k_Times_BoldItalic);
        standardFontsNames.put(ASName.k_Helvetica, ASName.k_Helvetica);
        standardFontsNames.put(ASName.k_ArialMT, ASName.k_Helvetica);
        standardFontsNames.put(ASName.k_Arial, ASName.k_Helvetica);
        standardFontsNames.put(ASName.k_Helvetica_Bold, ASName.k_Helvetica_Bold);
        standardFontsNames.put(ASName.k_Arial_BoldMT, ASName.k_Helvetica_Bold);
        standardFontsNames.put(ASName.k_ArialCommaBold, ASName.k_Helvetica_Bold);
        standardFontsNames.put(ASName.k_Arial_Bold, ASName.k_Helvetica_Bold);
        standardFontsNames.put(ASName.k_HelveticaCommaBold, ASName.k_Helvetica_Bold);
        standardFontsNames.put(ASName.k_Helvetica_Oblique, ASName.k_Helvetica_Oblique);
        standardFontsNames.put(ASName.k_Arial_ItalicMT, ASName.k_Helvetica_Oblique);
        standardFontsNames.put(ASName.k_ArialCommaItalic, ASName.k_Helvetica_Oblique);
        standardFontsNames.put(ASName.k_Arial_Italic, ASName.k_Helvetica_Oblique);
        standardFontsNames.put(ASName.k_HelveticaCommaItalic, ASName.k_Helvetica_Oblique);
        standardFontsNames.put(ASName.k_Helvetica_Italic, ASName.k_Helvetica_Oblique);
        standardFontsNames.put(ASName.k_Helvetica_BoldOblique, ASName.k_Helvetica_BoldOblique);
        standardFontsNames.put(ASName.k_Arial_BoldItalicMT, ASName.k_Helvetica_BoldOblique);
        standardFontsNames.put(ASName.k_ArialCommaBoldItalic, ASName.k_Helvetica_BoldOblique);
        standardFontsNames.put(ASName.k_Arial_BoldItalic, ASName.k_Helvetica_BoldOblique);
        standardFontsNames.put(ASName.k_HelveticaCommaBoldItalic, ASName.k_Helvetica_BoldOblique);
        standardFontsNames.put(ASName.k_Helvetica_BoldItalic, ASName.k_Helvetica_BoldOblique);
        standardFontsNames.put(ASName.k_Courier, ASName.k_Courier);
        standardFontsNames.put(ASName.k_CourierNew, ASName.k_Courier);
        standardFontsNames.put(ASName.k_CourierNewPSMT, ASName.k_Courier);
        standardFontsNames.put(ASName.k_Courier_Bold, ASName.k_Courier_Bold);
        standardFontsNames.put(ASName.k_CourierNewCommaBold, ASName.k_Courier_Bold);
        standardFontsNames.put(ASName.k_CourierCommaBold, ASName.k_Courier_Bold);
        standardFontsNames.put(ASName.k_CourierNewPS_BoldMT, ASName.k_Courier_Bold);
        standardFontsNames.put(ASName.k_CourierNew_Bold, ASName.k_Courier_Bold);
        standardFontsNames.put(ASName.k_Courier_Oblique, ASName.k_Courier_Oblique);
        standardFontsNames.put(ASName.k_CourierNewCommaItalic, ASName.k_Courier_Oblique);
        standardFontsNames.put(ASName.k_CourierCommaItalic, ASName.k_Courier_Oblique);
        standardFontsNames.put(ASName.k_CourierNewPS_ItalicMT, ASName.k_Courier_Oblique);
        standardFontsNames.put(ASName.k_CourierNew_Italic, ASName.k_Courier_Oblique);
        standardFontsNames.put(ASName.k_Courier_BoldOblique, ASName.k_Courier_BoldOblique);
        standardFontsNames.put(ASName.k_CourierNewCommaBoldItalic, ASName.k_Courier_BoldOblique);
        standardFontsNames.put(ASName.k_CourierCommaBoldItalic, ASName.k_Courier_BoldOblique);
        standardFontsNames.put(ASName.k_CourierNewPS_BoldItalicMT, ASName.k_Courier_BoldOblique);
        standardFontsNames.put(ASName.k_CourierNew_BoldItalic, ASName.k_Courier_BoldOblique);
        standardFontsNames.put(ASName.k_Symbol, ASName.k_Symbol);
        standardFontsNames.put(ASName.k_ZapfDingbats, ASName.k_ZapfDingbats);
        widthsCourier = new int[]{600};
        widthsCourierOblique = new int[]{600};
        widthsCourierBold = new int[]{600};
        widthsCourierBoldOblique = new int[]{600};
        widthsHelvetica = new int[]{667, 1000, 667, 667, 667, 667, 667, 667, 667, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 500, 667, 556, 0, 556, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 667, 556, 0, 0, 0, 0, 0, 469, 584, 389, 1015, 556, 556, 278, 260, 334, 334, 278, 278, 333, 260, 350, 500, 333, 500, 333, 556, 0, 333, 278, 278, 737, 556, 556, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 556, 278, 333, 278, 500, 556, 500, 556, 0, 556, 167, 556, 0, 611, 333, 0, 584, 556, 556, 333, 333, 556, 333, 333, 222, 278, 278, 278, 278, 0, 0, 222, 500, 222, 0, 0, 584, 0, 0, 584, 222, 833, 333, 0, 584, 556, 584, 556, 556, 0, 556, 556, 556, 556, 556, 556, 944, 333, 556, 556, 834, 834, 333, 370, 365, 611, 556, 0, 556, 537, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 556, 556, 611, 355, 333, 333, 333, 222, 222, 222, 191, 333, 737, 0, 333, 500, 500, 0, 556, 278, 556, 556, 278, 278, 0, 556, 0, 278, 0, 556, 556, 834, 333, 333, 1000, 556, 333, 556, 556, 556, 556, 556, 556, 0, 500, 722, 500, 500, 500, 500, 556, 500, 500, 556};
        widthsHelveticaOblique = new int[]{667, 1000, 667, 667, 667, 667, 667, 667, 667, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 500, 667, 556, 0, 556, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 667, 556, 0, 0, 0, 0, 0, 469, 584, 389, 1015, 556, 556, 278, 260, 334, 334, 278, 278, 333, 260, 350, 500, 333, 500, 333, 556, 0, 333, 278, 278, 737, 556, 556, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 556, 278, 333, 278, 500, 556, 500, 556, 0, 556, 167, 556, 0, 611, 333, 0, 584, 556, 556, 333, 333, 556, 333, 333, 222, 278, 278, 278, 278, 0, 0, 222, 500, 222, 0, 0, 584, 0, 0, 584, 222, 833, 333, 0, 584, 556, 584, 556, 556, 0, 556, 556, 556, 556, 556, 556, 944, 333, 556, 556, 834, 834, 333, 370, 365, 611, 556, 0, 556, 537, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 556, 556, 611, 355, 333, 333, 333, 222, 222, 222, 191, 333, 737, 0, 333, 500, 500, 0, 556, 278, 556, 556, 278, 278, 0, 556, 0, 278, 0, 556, 556, 834, 333, 333, 1000, 556, 333, 556, 556, 556, 556, 556, 556, 0, 500, 722, 500, 500, 500, 500, 556, 500, 500, 556};
        widthsHelveticaBold = new int[]{722, 1000, 722, 722, 722, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 556, 722, 611, 0, 611, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 722, 556, 0, 0, 0, 0, 0, 584, 584, 389, 975, 556, 611, 278, 280, 389, 389, 333, 333, 333, 280, 350, 556, 333, 556, 333, 556, 0, 333, 333, 278, 737, 556, 611, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 611, 333, 333, 333, 611, 556, 611, 556, 0, 556, 167, 611, 0, 611, 333, 0, 584, 556, 556, 333, 333, 611, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 556, 278, 0, 0, 584, 0, 0, 584, 278, 889, 333, 0, 584, 611, 584, 611, 556, 0, 611, 556, 611, 611, 611, 611, 944, 333, 611, 556, 834, 834, 333, 370, 365, 611, 611, 0, 611, 556, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 611, 611, 611, 474, 500, 500, 500, 278, 278, 278, 238, 389, 737, 0, 333, 556, 556, 0, 556, 333, 556, 556, 278, 278, 0, 556, 0, 333, 0, 611, 556, 834, 333, 333, 1000, 556, 333, 611, 611, 611, 611, 611, 556, 0, 556, 778, 556, 556, 556, 556, 556, 500, 500, 556};
        widthsHelveticaBoldOblique = new int[]{722, 1000, 722, 722, 722, 722, 722, 722, 722, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 722, 278, 0, 278, 278, 278, 0, 278, 556, 722, 611, 0, 611, 833, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 667, 778, 722, 667, 667, 0, 611, 667, 722, 722, 722, 722, 722, 667, 944, 667, 667, 667, 667, 611, 611, 556, 556, 556, 333, 556, 889, 556, 722, 556, 0, 0, 0, 0, 0, 584, 584, 389, 975, 556, 611, 278, 280, 389, 389, 333, 333, 333, 280, 350, 556, 333, 556, 333, 556, 0, 333, 333, 278, 737, 556, 611, 556, 556, 0, 400, 333, 584, 556, 333, 278, 0, 556, 556, 556, 556, 556, 556, 1000, 1000, 556, 584, 611, 333, 333, 333, 611, 556, 611, 556, 0, 556, 167, 611, 0, 611, 333, 0, 584, 556, 556, 333, 333, 611, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 556, 278, 0, 0, 584, 0, 0, 584, 278, 889, 333, 0, 584, 611, 584, 611, 556, 0, 611, 556, 611, 611, 611, 611, 944, 333, 611, 556, 834, 834, 333, 370, 365, 611, 611, 0, 611, 556, 333, 333, 889, 278, 278, 1000, 584, 584, 0, 611, 611, 611, 474, 500, 500, 500, 278, 278, 278, 238, 389, 737, 0, 333, 556, 556, 0, 556, 333, 556, 556, 278, 278, 0, 556, 0, 333, 0, 611, 556, 834, 333, 333, 1000, 556, 333, 611, 611, 611, 611, 611, 556, 0, 556, 778, 556, 556, 556, 556, 556, 500, 500, 556};
        widthsTimesRoman = new int[]{722, 889, 722, 722, 722, 722, 722, 722, 667, 667, 667, 722, 611, 611, 611, 611, 611, 722, 556, 722, 0, 722, 333, 0, 333, 333, 333, 0, 333, 389, 722, 611, 0, 611, 889, 722, 722, 722, 889, 722, 722, 722, 722, 722, 722, 556, 722, 667, 556, 556, 0, 611, 556, 722, 722, 722, 722, 722, 722, 944, 722, 722, 722, 722, 611, 611, 444, 444, 444, 333, 444, 667, 444, 778, 444, 0, 0, 0, 0, 0, 469, 541, 500, 921, 444, 500, 278, 200, 480, 480, 333, 333, 333, 200, 350, 444, 333, 444, 333, 500, 0, 333, 278, 250, 760, 500, 500, 500, 500, 0, 400, 333, 564, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 1000, 1000, 500, 564, 500, 333, 333, 333, 556, 500, 556, 500, 0, 500, 167, 500, 0, 500, 333, 0, 564, 500, 500, 333, 333, 500, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 500, 278, 0, 0, 564, 0, 0, 564, 278, 778, 333, 0, 564, 500, 564, 500, 500, 0, 500, 500, 500, 500, 500, 500, 722, 333, 500, 500, 750, 750, 300, 276, 310, 500, 500, 0, 500, 453, 333, 333, 833, 250, 250, 1000, 564, 564, 0, 500, 444, 444, 408, 444, 444, 444, 333, 333, 333, 180, 333, 760, 0, 333, 389, 389, 0, 500, 278, 500, 500, 278, 250, 0, 500, 0, 278, 0, 500, 500, 750, 300, 333, 980, 500, 300, 500, 500, 500, 500, 500, 500, 0, 500, 722, 500, 500, 500, 500, 500, 444, 444, 500};
        widthsTimesItalic = new int[]{611, 889, 611, 611, 611, 611, 611, 611, 611, 667, 667, 722, 611, 611, 611, 611, 611, 722, 611, 722, 0, 722, 333, 0, 333, 333, 333, 0, 333, 444, 667, 556, 0, 556, 833, 667, 667, 722, 944, 722, 722, 722, 722, 722, 722, 611, 722, 611, 500, 500, 0, 556, 611, 722, 722, 722, 722, 722, 611, 833, 611, 556, 556, 556, 556, 556, 500, 500, 500, 333, 500, 667, 500, 778, 500, 0, 0, 0, 0, 0, 422, 541, 500, 920, 500, 500, 278, 275, 400, 400, 389, 389, 333, 275, 350, 444, 333, 444, 333, 500, 0, 333, 333, 250, 760, 500, 500, 500, 500, 0, 400, 333, 675, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 889, 889, 500, 675, 500, 333, 389, 278, 500, 500, 500, 500, 0, 500, 167, 500, 0, 500, 333, 0, 675, 500, 500, 333, 333, 500, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 444, 278, 0, 0, 675, 0, 0, 675, 278, 722, 333, 0, 675, 500, 675, 500, 500, 0, 500, 500, 500, 500, 500, 500, 667, 333, 500, 500, 750, 750, 300, 276, 310, 500, 500, 0, 500, 523, 333, 333, 833, 250, 250, 1000, 675, 675, 0, 500, 500, 500, 420, 556, 556, 556, 333, 333, 333, 214, 389, 760, 0, 333, 389, 389, 0, 500, 333, 500, 500, 278, 250, 0, 500, 0, 278, 0, 500, 500, 750, 300, 333, 980, 500, 300, 500, 500, 500, 500, 500, 500, 0, 444, 667, 444, 444, 444, 444, 500, 389, 389, 500};
        widthsTimesBold = new int[]{722, 1000, 722, 722, 722, 722, 722, 722, 667, 722, 722, 722, 667, 667, 667, 667, 667, 722, 611, 778, 0, 778, 389, 0, 389, 389, 389, 0, 389, 500, 778, 667, 0, 667, 944, 722, 722, 778, 1000, 778, 778, 778, 778, 778, 778, 611, 778, 722, 556, 556, 0, 667, 611, 722, 722, 722, 722, 722, 722, 1000, 722, 722, 722, 722, 667, 667, 500, 500, 500, 333, 500, 722, 500, 833, 500, 0, 0, 0, 0, 0, 581, 520, 500, 930, 500, 556, 278, 220, 394, 394, 333, 333, 333, 220, 350, 444, 333, 444, 333, 500, 0, 333, 333, 250, 747, 500, 556, 500, 500, 0, 400, 333, 570, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 1000, 1000, 500, 570, 500, 333, 333, 333, 556, 500, 556, 500, 0, 500, 167, 500, 0, 556, 333, 0, 570, 500, 500, 333, 333, 556, 333, 333, 278, 278, 278, 278, 278, 0, 0, 333, 556, 278, 0, 0, 570, 0, 0, 570, 278, 833, 333, 0, 570, 556, 570, 556, 500, 0, 556, 500, 500, 500, 500, 500, 722, 333, 500, 500, 750, 750, 300, 300, 330, 500, 500, 0, 556, 540, 333, 333, 1000, 250, 250, 1000, 570, 570, 0, 556, 500, 500, 555, 500, 500, 500, 333, 333, 333, 278, 444, 747, 0, 333, 389, 389, 0, 500, 333, 500, 500, 278, 250, 0, 500, 0, 333, 0, 556, 500, 750, 300, 333, 1000, 500, 300, 556, 556, 556, 556, 556, 500, 0, 500, 722, 500, 500, 500, 500, 500, 444, 444, 500};
        widthsTimesBoldItalic = new int[]{667, 944, 667, 667, 667, 667, 667, 667, 667, 667, 667, 722, 667, 667, 667, 667, 667, 722, 667, 722, 0, 778, 389, 0, 389, 389, 389, 0, 389, 500, 667, 611, 0, 611, 889, 722, 722, 722, 944, 722, 722, 722, 722, 722, 722, 611, 722, 667, 556, 556, 0, 611, 611, 722, 722, 722, 722, 722, 667, 889, 667, 611, 611, 611, 611, 611, 500, 500, 500, 333, 500, 722, 500, 778, 500, 0, 0, 0, 0, 0, 570, 570, 500, 832, 500, 500, 278, 220, 348, 348, 333, 333, 333, 220, 350, 444, 333, 444, 333, 500, 0, 333, 333, 250, 747, 500, 500, 500, 500, 0, 400, 333, 570, 500, 333, 278, 0, 444, 444, 444, 444, 444, 500, 1000, 1000, 500, 570, 500, 389, 389, 333, 556, 500, 556, 500, 0, 500, 167, 500, 0, 500, 333, 0, 570, 500, 500, 333, 333, 556, 333, 333, 278, 278, 278, 278, 278, 0, 0, 278, 500, 278, 0, 0, 570, 0, 0, 606, 278, 778, 333, 0, 606, 576, 570, 556, 500, 0, 556, 500, 500, 500, 500, 500, 722, 333, 500, 500, 750, 750, 300, 266, 300, 500, 500, 0, 500, 500, 333, 333, 833, 250, 250, 1000, 570, 570, 0, 500, 500, 500, 555, 500, 500, 500, 333, 333, 333, 278, 389, 747, 0, 333, 389, 389, 0, 500, 333, 500, 500, 278, 250, 0, 500, 0, 278, 0, 500, 500, 750, 300, 333, 1000, 500, 300, 556, 556, 556, 556, 556, 500, 0, 444, 667, 500, 444, 444, 444, 500, 389, 389, 500};
        widthsSymbol = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 333, 713, 500, 549, 833, 778, 439, 333, 333, 500, 549, 250, 549, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 278, 278, 549, 549, 549, 444, 549, 722, 667, 722, 612, 611, 763, 603, 722, 333, 631, 722, 686, 889, 722, 722, 768, 741, 556, 592, 611, 690, 439, 768, 645, 795, 611, 333, 863, 333, 658, 500, 500, 631, 549, 549, 494, 439, 521, 411, 603, 329, 603, 549, 549, 576, 521, 549, 549, 521, 549, 603, 439, 576, 713, 686, 493, 686, 494, 480, 200, 480, 549, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 620, 247, 549, 167, 713, 500, 753, 753, 753, 753, 1042, 987, 603, 987, 603, 400, 549, 411, 549, 549, 713, 494, 460, 549, 549, 549, 549, 1000, 603, 1000, 658, 823, 686, 795, 987, 768, 768, 823, 768, 768, 713, 713, 713, 713, 713, 713, 713, 768, 713, 790, 790, 890, 823, 549, 250, 713, 603, 603, 1042, 987, 603, 987, 603, 494, 329, 790, 790, 786, 713, 384, 384, 384, 384, 384, 384, 494, 494, 494, 494, 0, 329, 274, 686, 686, 686, 384, 384, 384, 384, 384, 384, 494, 494, 494, 0, 790};
        widthsZapfDingbats = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 278, 974, 961, 974, 980, 719, 789, 790, 791, 690, 960, 939, 549, 855, 911, 933, 911, 945, 974, 755, 846, 762, 761, 571, 677, 763, 760, 759, 754, 494, 552, 537, 577, 692, 786, 788, 788, 790, 793, 794, 816, 823, 789, 841, 823, 833, 816, 831, 923, 744, 723, 749, 790, 792, 695, 776, 768, 792, 759, 707, 708, 682, 701, 826, 815, 789, 789, 707, 687, 696, 689, 786, 787, 713, 791, 785, 791, 873, 761, 762, 762, 759, 759, 892, 892, 788, 784, 438, 138, 277, 415, 392, 392, 668, 668, 0, 0, 0, 0, 790, 668, 537, 537, 668, 668, 537, 537, 537, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 732, 544, 544, 910, 667, 760, 760, 776, 595, 694, 626, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 788, 894, 838, 1016, 458, 748, 924, 748, 918, 927, 928, 928, 834, 873, 828, 924, 924, 917, 930, 931, 463, 883, 836, 836, 867, 867, 696, 696, 874, 0, 874, 760, 946, 771, 865, 771, 888, 967, 888, 831, 873, 927, 970, 918, 0, 410, 509, 334, 509, 390, 234, 276, 390, 410, 317, 317, 276, 334, 234};
        standardFontsWidths = new HashMap();
        standardFontsWidths.put(ASName.k_Times_Roman, widthsTimesRoman);
        standardFontsWidths.put(ASName.k_Times_Bold, widthsTimesBold);
        standardFontsWidths.put(ASName.k_Times_Italic, widthsTimesItalic);
        standardFontsWidths.put(ASName.k_Times_BoldItalic, widthsTimesBoldItalic);
        standardFontsWidths.put(ASName.k_Helvetica, widthsHelvetica);
        standardFontsWidths.put(ASName.k_Helvetica_Bold, widthsHelveticaBold);
        standardFontsWidths.put(ASName.k_Helvetica_Oblique, widthsHelveticaOblique);
        standardFontsWidths.put(ASName.k_Helvetica_BoldOblique, widthsHelveticaBoldOblique);
        standardFontsWidths.put(ASName.k_Courier, widthsCourier);
        standardFontsWidths.put(ASName.k_Courier_Bold, widthsCourierBold);
        standardFontsWidths.put(ASName.k_Courier_Oblique, widthsCourierOblique);
        standardFontsWidths.put(ASName.k_Courier_BoldOblique, widthsCourierBoldOblique);
        standardFontsWidths.put(ASName.k_Symbol, widthsSymbol);
        standardFontsWidths.put(ASName.k_ZapfDingbats, widthsZapfDingbats);
        widthsGlyphOrdering = new ASName[]{ASName.create("A"), ASName.create("AE"), ASName.create("Aacute"), ASName.create("Acircumflex"), ASName.create("Adieresis"), ASName.create("Agrave"), ASName.create("Aring"), ASName.create("Atilde"), ASName.create("B"), ASName.create("C"), ASName.create("Ccedilla"), ASName.create("D"), ASName.create("E"), ASName.create("Eacute"), ASName.create("Ecircumflex"), ASName.create("Edieresis"), ASName.create("Egrave"), ASName.create("Eth"), ASName.create("F"), ASName.create("G"), ASName.create("Gcaron"), ASName.create("H"), ASName.create("I"), ASName.create("IJ"), ASName.create("Iacute"), ASName.create("Icircumflex"), ASName.create("Idieresis"), ASName.create("Idot"), ASName.create("Igrave"), ASName.create("J"), ASName.create("K"), ASName.create("L"), ASName.create("LL"), ASName.create("Lslash"), ASName.create("M"), ASName.create("N"), ASName.create("Ntilde"), ASName.create("O"), ASName.create("OE"), ASName.create("Oacute"), ASName.create("Ocircumflex"), ASName.create("Odieresis"), ASName.create("Ograve"), ASName.create("Oslash"), ASName.create("Otilde"), ASName.create("P"), ASName.create("Q"), ASName.create("R"), ASName.create("S"), ASName.create("Scaron"), ASName.create("Scedilla"), ASName.create("T"), ASName.create("Thorn"), ASName.create("U"), ASName.create("Uacute"), ASName.create("Ucircumflex"), ASName.create("Udieresis"), ASName.create("Ugrave"), ASName.create("V"), ASName.create("W"), ASName.create("X"), ASName.create("Y"), ASName.create("Yacute"), ASName.create("Ydieresis"), ASName.create("Z"), ASName.create("Zcaron"), ASName.create("a"), ASName.create("aacute"), ASName.create("acircumflex"), ASName.create("acute"), ASName.create("adieresis"), ASName.create("ae"), ASName.create("agrave"), ASName.create("ampersand"), ASName.create("aring"), ASName.create("arrowboth"), ASName.create("arrowdown"), ASName.create("arrowleft"), ASName.create("arrowright"), ASName.create("arrowup"), ASName.create("asciicircum"), ASName.create("asciitilde"), ASName.create("asterisk"), ASName.create("at"), ASName.create("atilde"), ASName.create("b"), ASName.create("backslash"), ASName.create("bar"), ASName.create("braceleft"), ASName.create("braceright"), ASName.create("bracketleft"), ASName.create("bracketright"), ASName.create("breve"), ASName.create("brokenbar"), ASName.create("bullet"), ASName.create("c"), ASName.create("caron"), ASName.create("ccedilla"), ASName.create("cedilla"), ASName.create("cent"), ASName.create("center"), ASName.create("circumflex"), ASName.create("colon"), ASName.create("comma"), ASName.create("copyright"), ASName.create("currency"), ASName.create("d"), ASName.create("dagger"), ASName.create("daggerdbl"), ASName.create("dectab"), ASName.create("degree"), ASName.create("dieresis"), ASName.create("divide"), ASName.create("dollar"), ASName.create("dotaccent"), ASName.create("dotlessi"), ASName.create("down"), ASName.create("e"), ASName.create("eacute"), ASName.create("ecircumflex"), ASName.create("edieresis"), ASName.create("egrave"), ASName.create("eight"), ASName.create("ellipsis"), ASName.create("emdash"), ASName.create("endash"), ASName.create("equal"), ASName.create("eth"), ASName.create("exclam"), ASName.create("exclamdown"), ASName.create("f"), ASName.create("fi"), ASName.create("five"), ASName.create("fl"), ASName.create("florin"), ASName.create("format"), ASName.create("four"), ASName.create("fraction"), ASName.create("g"), ASName.create("gcaron"), ASName.create("germandbls"), ASName.create("grave"), ASName.create("graybox"), ASName.create("greater"), ASName.create("guillemotleft"), ASName.create("guillemotright"), ASName.create("guilsinglleft"), ASName.create("guilsinglright"), ASName.create("h"), ASName.create("hungarumlaut"), ASName.create("hyphen"), ASName.create("i"), ASName.create("iacute"), ASName.create("icircumflex"), ASName.create("idieresis"), ASName.create("igrave"), ASName.create("ij"), ASName.create("indent"), ASName.create("j"), ASName.create("k"), ASName.create("l"), ASName.create("largebullet"), ASName.create("left"), ASName.create("less"), ASName.create("lira"), ASName.create("ll"), ASName.create("logicalnot"), ASName.create("lslash"), ASName.create("m"), ASName.create("macron"), ASName.create("merge"), ASName.create("minus"), ASName.create("mu"), ASName.create("multiply"), ASName.create("n"), ASName.create("nine"), ASName.create("notegraphic"), ASName.create("ntilde"), ASName.create("numbersign"), ASName.create("o"), ASName.create("oacute"), ASName.create("ocircumflex"), ASName.create("odieresis"), ASName.create("oe"), ASName.create("ogonek"), ASName.create("ograve"), ASName.create("one"), ASName.create("onehalf"), ASName.create("onequarter"), ASName.create("onesuperior"), ASName.create("ordfeminine"), ASName.create("ordmasculine"), ASName.create("oslash"), ASName.create("otilde"), ASName.create("overscore"), ASName.create("p"), ASName.create("paragraph"), ASName.create("parenleft"), ASName.create("parenright"), ASName.create("percent"), ASName.create("period"), ASName.create("periodcentered"), ASName.create("perthousand"), ASName.create("plus"), ASName.create("plusminus"), ASName.create("prescription"), ASName.create("q"), ASName.create("question"), ASName.create("questiondown"), ASName.create("quotedbl"), ASName.create("quotedblbase"), ASName.create("quotedblleft"), ASName.create("quotedblright"), ASName.create("quoteleft"), ASName.create("quoteright"), ASName.create("quotesinglbase"), ASName.create("quotesingle"), ASName.create("r"), ASName.create("registered"), ASName.create("return"), ASName.create("ring"), ASName.create("s"), ASName.create("scaron"), ASName.create("scedilla"), ASName.create("section"), ASName.create("semicolon"), ASName.create("seven"), ASName.create("six"), ASName.create("slash"), ASName.create("space"), ASName.create("square"), ASName.create("sterling"), ASName.create("stop"), ASName.create("t"), ASName.create("tab"), ASName.create("thorn"), ASName.create("three"), ASName.create("threequarters"), ASName.create("threesuperior"), ASName.create("tilde"), ASName.create("trademark"), ASName.create("two"), ASName.create("twosuperior"), ASName.create("u"), ASName.create("uacute"), ASName.create("ucircumflex"), ASName.create("udieresis"), ASName.create("ugrave"), ASName.create("underscore"), ASName.create("up"), ASName.create("v"), ASName.create("w"), ASName.create("x"), ASName.create("y"), ASName.create("yacute"), ASName.create("ydieresis"), ASName.create("yen"), ASName.create("z"), ASName.create("zcaron"), ASName.create("zero")};
        glyphNameToUnicodeMap = new HashMap(223);
        glyphNameToUnicodeMap.put(ASName.create(".notdef"), new Integer(65533));
        glyphNameToUnicodeMap.put(ASName.create("NUL"), new Integer(0));
        glyphNameToUnicodeMap.put(ASName.create("SOH"), new Integer(1));
        glyphNameToUnicodeMap.put(ASName.create("STX"), new Integer(2));
        glyphNameToUnicodeMap.put(ASName.create("ETX"), new Integer(3));
        glyphNameToUnicodeMap.put(ASName.create("EOT"), new Integer(4));
        glyphNameToUnicodeMap.put(ASName.create("ENQ"), new Integer(5));
        glyphNameToUnicodeMap.put(ASName.create("ACK"), new Integer(6));
        glyphNameToUnicodeMap.put(ASName.create("BEL"), new Integer(7));
        glyphNameToUnicodeMap.put(ASName.create("BS"), new Integer(8));
        glyphNameToUnicodeMap.put(ASName.create("HT"), new Integer(9));
        glyphNameToUnicodeMap.put(ASName.create("LF"), new Integer(10));
        glyphNameToUnicodeMap.put(ASName.create("VT"), new Integer(11));
        glyphNameToUnicodeMap.put(ASName.create("FF"), new Integer(12));
        glyphNameToUnicodeMap.put(ASName.create("CR"), new Integer(13));
        glyphNameToUnicodeMap.put(ASName.create("SO"), new Integer(14));
        glyphNameToUnicodeMap.put(ASName.create("SI"), new Integer(15));
        glyphNameToUnicodeMap.put(ASName.create("DLE"), new Integer(16));
        glyphNameToUnicodeMap.put(ASName.create("DC1"), new Integer(17));
        glyphNameToUnicodeMap.put(ASName.create("DC2"), new Integer(18));
        glyphNameToUnicodeMap.put(ASName.create("DC3"), new Integer(19));
        glyphNameToUnicodeMap.put(ASName.create("DC4"), new Integer(20));
        glyphNameToUnicodeMap.put(ASName.create("NAK"), new Integer(21));
        glyphNameToUnicodeMap.put(ASName.create("SYN"), new Integer(22));
        glyphNameToUnicodeMap.put(ASName.create("ETB"), new Integer(23));
        glyphNameToUnicodeMap.put(ASName.create("CAN"), new Integer(24));
        glyphNameToUnicodeMap.put(ASName.create("EM"), new Integer(25));
        glyphNameToUnicodeMap.put(ASName.create("SUB"), new Integer(26));
        glyphNameToUnicodeMap.put(ASName.create("ESC"), new Integer(27));
        glyphNameToUnicodeMap.put(ASName.create("FS"), new Integer(28));
        glyphNameToUnicodeMap.put(ASName.create("GS"), new Integer(29));
        glyphNameToUnicodeMap.put(ASName.create("RS"), new Integer(30));
        glyphNameToUnicodeMap.put(ASName.create("US"), new Integer(31));
        glyphNameToUnicodeMap.put(ASName.create("space"), new Integer(32));
        glyphNameToUnicodeMap.put(ASName.create("exclam"), new Integer(33));
        glyphNameToUnicodeMap.put(ASName.create("quotedbl"), new Integer(34));
        glyphNameToUnicodeMap.put(ASName.create("numbersign"), new Integer(35));
        glyphNameToUnicodeMap.put(ASName.create("dollar"), new Integer(36));
        glyphNameToUnicodeMap.put(ASName.create("percent"), new Integer(37));
        glyphNameToUnicodeMap.put(ASName.create("ampersand"), new Integer(38));
        glyphNameToUnicodeMap.put(ASName.create("quotesingle"), new Integer(39));
        glyphNameToUnicodeMap.put(ASName.create("parenleft"), new Integer(40));
        glyphNameToUnicodeMap.put(ASName.create("parenright"), new Integer(41));
        glyphNameToUnicodeMap.put(ASName.create("asterisk"), new Integer(42));
        glyphNameToUnicodeMap.put(ASName.create("plus"), new Integer(43));
        glyphNameToUnicodeMap.put(ASName.create("comma"), new Integer(44));
        glyphNameToUnicodeMap.put(ASName.create("hyphen"), new Integer(45));
        glyphNameToUnicodeMap.put(ASName.create("period"), new Integer(46));
        glyphNameToUnicodeMap.put(ASName.create("slash"), new Integer(47));
        glyphNameToUnicodeMap.put(ASName.create("zero"), new Integer(48));
        glyphNameToUnicodeMap.put(ASName.create("one"), new Integer(49));
        glyphNameToUnicodeMap.put(ASName.create("two"), new Integer(50));
        glyphNameToUnicodeMap.put(ASName.create("three"), new Integer(51));
        glyphNameToUnicodeMap.put(ASName.create("four"), new Integer(52));
        glyphNameToUnicodeMap.put(ASName.create("five"), new Integer(53));
        glyphNameToUnicodeMap.put(ASName.create("six"), new Integer(54));
        glyphNameToUnicodeMap.put(ASName.create("seven"), new Integer(55));
        glyphNameToUnicodeMap.put(ASName.create("eight"), new Integer(56));
        glyphNameToUnicodeMap.put(ASName.create("nine"), new Integer(57));
        glyphNameToUnicodeMap.put(ASName.create("colon"), new Integer(58));
        glyphNameToUnicodeMap.put(ASName.create("semicolon"), new Integer(59));
        glyphNameToUnicodeMap.put(ASName.create("less"), new Integer(60));
        glyphNameToUnicodeMap.put(ASName.create("equal"), new Integer(61));
        glyphNameToUnicodeMap.put(ASName.create("greater"), new Integer(62));
        glyphNameToUnicodeMap.put(ASName.create("question"), new Integer(63));
        glyphNameToUnicodeMap.put(ASName.create("at"), new Integer(64));
        glyphNameToUnicodeMap.put(ASName.create("A"), new Integer(65));
        glyphNameToUnicodeMap.put(ASName.create("B"), new Integer(66));
        glyphNameToUnicodeMap.put(ASName.create("C"), new Integer(67));
        glyphNameToUnicodeMap.put(ASName.create("D"), new Integer(68));
        glyphNameToUnicodeMap.put(ASName.create("E"), new Integer(69));
        glyphNameToUnicodeMap.put(ASName.create("F"), new Integer(70));
        glyphNameToUnicodeMap.put(ASName.create("G"), new Integer(71));
        glyphNameToUnicodeMap.put(ASName.create("H"), new Integer(72));
        glyphNameToUnicodeMap.put(ASName.create("I"), new Integer(73));
        glyphNameToUnicodeMap.put(ASName.create("J"), new Integer(74));
        glyphNameToUnicodeMap.put(ASName.create("K"), new Integer(75));
        glyphNameToUnicodeMap.put(ASName.create("L"), new Integer(76));
        glyphNameToUnicodeMap.put(ASName.create("M"), new Integer(77));
        glyphNameToUnicodeMap.put(ASName.create("N"), new Integer(78));
        glyphNameToUnicodeMap.put(ASName.create("O"), new Integer(79));
        glyphNameToUnicodeMap.put(ASName.create("P"), new Integer(80));
        glyphNameToUnicodeMap.put(ASName.create("Q"), new Integer(81));
        glyphNameToUnicodeMap.put(ASName.create("R"), new Integer(82));
        glyphNameToUnicodeMap.put(ASName.create("S"), new Integer(83));
        glyphNameToUnicodeMap.put(ASName.create("T"), new Integer(84));
        glyphNameToUnicodeMap.put(ASName.create("U"), new Integer(85));
        glyphNameToUnicodeMap.put(ASName.create("V"), new Integer(86));
        glyphNameToUnicodeMap.put(ASName.create("W"), new Integer(87));
        glyphNameToUnicodeMap.put(ASName.create("X"), new Integer(88));
        glyphNameToUnicodeMap.put(ASName.create("Y"), new Integer(89));
        glyphNameToUnicodeMap.put(ASName.create("Z"), new Integer(90));
        glyphNameToUnicodeMap.put(ASName.create("bracketleft"), new Integer(91));
        glyphNameToUnicodeMap.put(ASName.create("backslash"), new Integer(92));
        glyphNameToUnicodeMap.put(ASName.create("bracketright"), new Integer(93));
        glyphNameToUnicodeMap.put(ASName.create("asciicircum"), new Integer(94));
        glyphNameToUnicodeMap.put(ASName.create("underscore"), new Integer(95));
        glyphNameToUnicodeMap.put(ASName.create("grave"), new Integer(96));
        glyphNameToUnicodeMap.put(ASName.create("a"), new Integer(97));
        glyphNameToUnicodeMap.put(ASName.create("b"), new Integer(98));
        glyphNameToUnicodeMap.put(ASName.create("c"), new Integer(99));
        glyphNameToUnicodeMap.put(ASName.create("d"), new Integer(100));
        glyphNameToUnicodeMap.put(ASName.create("e"), new Integer(101));
        glyphNameToUnicodeMap.put(ASName.create("f"), new Integer(102));
        glyphNameToUnicodeMap.put(ASName.create("g"), new Integer(103));
        glyphNameToUnicodeMap.put(ASName.create("h"), new Integer(104));
        glyphNameToUnicodeMap.put(ASName.create("i"), new Integer(105));
        glyphNameToUnicodeMap.put(ASName.create("j"), new Integer(106));
        glyphNameToUnicodeMap.put(ASName.create("k"), new Integer(107));
        glyphNameToUnicodeMap.put(ASName.create("l"), new Integer(108));
        glyphNameToUnicodeMap.put(ASName.create("m"), new Integer(109));
        glyphNameToUnicodeMap.put(ASName.create("n"), new Integer(110));
        glyphNameToUnicodeMap.put(ASName.create("o"), new Integer(111));
        glyphNameToUnicodeMap.put(ASName.create("p"), new Integer(112));
        glyphNameToUnicodeMap.put(ASName.create("q"), new Integer(113));
        glyphNameToUnicodeMap.put(ASName.create("r"), new Integer(114));
        glyphNameToUnicodeMap.put(ASName.create("s"), new Integer(115));
        glyphNameToUnicodeMap.put(ASName.create("t"), new Integer(116));
        glyphNameToUnicodeMap.put(ASName.create("u"), new Integer(117));
        glyphNameToUnicodeMap.put(ASName.create("v"), new Integer(118));
        glyphNameToUnicodeMap.put(ASName.create("w"), new Integer(119));
        glyphNameToUnicodeMap.put(ASName.create("x"), new Integer(120));
        glyphNameToUnicodeMap.put(ASName.create("y"), new Integer(121));
        glyphNameToUnicodeMap.put(ASName.create("z"), new Integer(122));
        glyphNameToUnicodeMap.put(ASName.create("braceleft"), new Integer(123));
        glyphNameToUnicodeMap.put(ASName.create("bar"), new Integer(124));
        glyphNameToUnicodeMap.put(ASName.create("braceright"), new Integer(125));
        glyphNameToUnicodeMap.put(ASName.create("asciitilde"), new Integer(126));
        glyphNameToUnicodeMap.put(ASName.create("tilde"), new Integer(771));
        glyphNameToUnicodeMap.put(ASName.create("exclamdown"), new Integer(161));
        glyphNameToUnicodeMap.put(ASName.create("cent"), new Integer(162));
        glyphNameToUnicodeMap.put(ASName.create("sterling"), new Integer(163));
        glyphNameToUnicodeMap.put(ASName.create("currency"), new Integer(164));
        glyphNameToUnicodeMap.put(ASName.create("yen"), new Integer(165));
        glyphNameToUnicodeMap.put(ASName.create("brokenbar"), new Integer(166));
        glyphNameToUnicodeMap.put(ASName.create("section"), new Integer(167));
        glyphNameToUnicodeMap.put(ASName.create("dieresis"), new Integer(168));
        glyphNameToUnicodeMap.put(ASName.create("copyright"), new Integer(169));
        glyphNameToUnicodeMap.put(ASName.create("ordfeminine"), new Integer(170));
        glyphNameToUnicodeMap.put(ASName.create("guillemotleft"), new Integer(171));
        glyphNameToUnicodeMap.put(ASName.create("logicalnot"), new Integer(172));
        glyphNameToUnicodeMap.put(ASName.create("registered"), new Integer(174));
        glyphNameToUnicodeMap.put(ASName.create("macron"), new Integer(175));
        glyphNameToUnicodeMap.put(ASName.create("degree"), new Integer(176));
        glyphNameToUnicodeMap.put(ASName.create("plusminus"), new Integer(177));
        glyphNameToUnicodeMap.put(ASName.create("twosuperior"), new Integer(178));
        glyphNameToUnicodeMap.put(ASName.create("threesuperior"), new Integer(179));
        glyphNameToUnicodeMap.put(ASName.create("acute"), new Integer(180));
        glyphNameToUnicodeMap.put(ASName.create("mu"), new Integer(181));
        glyphNameToUnicodeMap.put(ASName.create("paragraph"), new Integer(182));
        glyphNameToUnicodeMap.put(ASName.create("periodcentered"), new Integer(183));
        glyphNameToUnicodeMap.put(ASName.create("cedilla"), new Integer(184));
        glyphNameToUnicodeMap.put(ASName.create("onesuperior"), new Integer(185));
        glyphNameToUnicodeMap.put(ASName.create("ordmasculine"), new Integer(186));
        glyphNameToUnicodeMap.put(ASName.create("guillemotright"), new Integer(187));
        glyphNameToUnicodeMap.put(ASName.create("onequarter"), new Integer(188));
        glyphNameToUnicodeMap.put(ASName.create("onehalf"), new Integer(189));
        glyphNameToUnicodeMap.put(ASName.create("threequarters"), new Integer(190));
        glyphNameToUnicodeMap.put(ASName.create("questiondown"), new Integer(191));
        glyphNameToUnicodeMap.put(ASName.create("Agrave"), new Integer(192));
        glyphNameToUnicodeMap.put(ASName.create("Aacute"), new Integer(193));
        glyphNameToUnicodeMap.put(ASName.create("Acircumflex"), new Integer(194));
        glyphNameToUnicodeMap.put(ASName.create("Atilde"), new Integer(195));
        glyphNameToUnicodeMap.put(ASName.create("Adieresis"), new Integer(196));
        glyphNameToUnicodeMap.put(ASName.create("Aring"), new Integer(197));
        glyphNameToUnicodeMap.put(ASName.create("AE"), new Integer(198));
        glyphNameToUnicodeMap.put(ASName.create("Ccedilla"), new Integer(199));
        glyphNameToUnicodeMap.put(ASName.create("Egrave"), new Integer(200));
        glyphNameToUnicodeMap.put(ASName.create("Eacute"), new Integer(201));
        glyphNameToUnicodeMap.put(ASName.create("Ecircumflex"), new Integer(202));
        glyphNameToUnicodeMap.put(ASName.create("Edieresis"), new Integer(203));
        glyphNameToUnicodeMap.put(ASName.create("Igrave"), new Integer(204));
        glyphNameToUnicodeMap.put(ASName.create("Iacute"), new Integer(205));
        glyphNameToUnicodeMap.put(ASName.create("Icircumflex"), new Integer(206));
        glyphNameToUnicodeMap.put(ASName.create("Idieresis"), new Integer(207));
        glyphNameToUnicodeMap.put(ASName.create("Eth"), new Integer(208));
        glyphNameToUnicodeMap.put(ASName.create("Ntilde"), new Integer(209));
        glyphNameToUnicodeMap.put(ASName.create("Ograve"), new Integer(210));
        glyphNameToUnicodeMap.put(ASName.create("Oacute"), new Integer(211));
        glyphNameToUnicodeMap.put(ASName.create("Ocircumflex"), new Integer(212));
        glyphNameToUnicodeMap.put(ASName.create("Otilde"), new Integer(213));
        glyphNameToUnicodeMap.put(ASName.create("Odieresis"), new Integer(214));
        glyphNameToUnicodeMap.put(ASName.create("multiply"), new Integer(215));
        glyphNameToUnicodeMap.put(ASName.create("Oslash"), new Integer(216));
        glyphNameToUnicodeMap.put(ASName.create("Ugrave"), new Integer(217));
        glyphNameToUnicodeMap.put(ASName.create("Uacute"), new Integer(218));
        glyphNameToUnicodeMap.put(ASName.create("Ucircumflex"), new Integer(219));
        glyphNameToUnicodeMap.put(ASName.create("Udieresis"), new Integer(220));
        glyphNameToUnicodeMap.put(ASName.create("Yacute"), new Integer(221));
        glyphNameToUnicodeMap.put(ASName.create("Thorn"), new Integer(222));
        glyphNameToUnicodeMap.put(ASName.create("germandbls"), new Integer(223));
        glyphNameToUnicodeMap.put(ASName.create("agrave"), new Integer(224));
        glyphNameToUnicodeMap.put(ASName.create("aacute"), new Integer(225));
        glyphNameToUnicodeMap.put(ASName.create("acircumflex"), new Integer(226));
        glyphNameToUnicodeMap.put(ASName.create("atilde"), new Integer(227));
        glyphNameToUnicodeMap.put(ASName.create("adieresis"), new Integer(228));
        glyphNameToUnicodeMap.put(ASName.create("aring"), new Integer(229));
        glyphNameToUnicodeMap.put(ASName.create("ae"), new Integer(230));
        glyphNameToUnicodeMap.put(ASName.create("ccedilla"), new Integer(231));
        glyphNameToUnicodeMap.put(ASName.create("egrave"), new Integer(232));
        glyphNameToUnicodeMap.put(ASName.create("eacute"), new Integer(233));
        glyphNameToUnicodeMap.put(ASName.create("ecircumflex"), new Integer(234));
        glyphNameToUnicodeMap.put(ASName.create("edieresis"), new Integer(235));
        glyphNameToUnicodeMap.put(ASName.create("igrave"), new Integer(236));
        glyphNameToUnicodeMap.put(ASName.create("iacute"), new Integer(237));
        glyphNameToUnicodeMap.put(ASName.create("icircumflex"), new Integer(238));
        glyphNameToUnicodeMap.put(ASName.create("idieresis"), new Integer(239));
        glyphNameToUnicodeMap.put(ASName.create("eth"), new Integer(240));
        glyphNameToUnicodeMap.put(ASName.create("ntilde"), new Integer(241));
        glyphNameToUnicodeMap.put(ASName.create("ograve"), new Integer(242));
        glyphNameToUnicodeMap.put(ASName.create("oacute"), new Integer(243));
        glyphNameToUnicodeMap.put(ASName.create("ocircumflex"), new Integer(244));
        glyphNameToUnicodeMap.put(ASName.create("otilde"), new Integer(245));
        glyphNameToUnicodeMap.put(ASName.create("odieresis"), new Integer(246));
        glyphNameToUnicodeMap.put(ASName.create("divide"), new Integer(247));
        glyphNameToUnicodeMap.put(ASName.create("oslash"), new Integer(248));
        glyphNameToUnicodeMap.put(ASName.create("ugrave"), new Integer(249));
        glyphNameToUnicodeMap.put(ASName.create("uacute"), new Integer(250));
        glyphNameToUnicodeMap.put(ASName.create("ucircumflex"), new Integer(251));
        glyphNameToUnicodeMap.put(ASName.create("udieresis"), new Integer(252));
        glyphNameToUnicodeMap.put(ASName.create("yacute"), new Integer(253));
        glyphNameToUnicodeMap.put(ASName.create("thorn"), new Integer(254));
        glyphNameToUnicodeMap.put(ASName.create("ydieresis"), new Integer(255));
        unicodeToGlyphNameMap = new HashMap(223);
        unicodeToGlyphNameMap.put(new Integer(65533), ASName.create(".notdef"));
        unicodeToGlyphNameMap.put(new Integer(0), ASName.create("NUL"));
        unicodeToGlyphNameMap.put(new Integer(1), ASName.create("SOH"));
        unicodeToGlyphNameMap.put(new Integer(2), ASName.create("STX"));
        unicodeToGlyphNameMap.put(new Integer(3), ASName.create("ETX"));
        unicodeToGlyphNameMap.put(new Integer(4), ASName.create("EOT"));
        unicodeToGlyphNameMap.put(new Integer(5), ASName.create("ENQ"));
        unicodeToGlyphNameMap.put(new Integer(6), ASName.create("ACK"));
        unicodeToGlyphNameMap.put(new Integer(7), ASName.create("BEL"));
        unicodeToGlyphNameMap.put(new Integer(8), ASName.create("BS"));
        unicodeToGlyphNameMap.put(new Integer(9), ASName.create("HT"));
        unicodeToGlyphNameMap.put(new Integer(10), ASName.create("LF"));
        unicodeToGlyphNameMap.put(new Integer(11), ASName.create("VT"));
        unicodeToGlyphNameMap.put(new Integer(12), ASName.create("FF"));
        unicodeToGlyphNameMap.put(new Integer(13), ASName.create("CR"));
        unicodeToGlyphNameMap.put(new Integer(14), ASName.create("SO"));
        unicodeToGlyphNameMap.put(new Integer(15), ASName.create("SI"));
        unicodeToGlyphNameMap.put(new Integer(16), ASName.create("DLE"));
        unicodeToGlyphNameMap.put(new Integer(17), ASName.create("DC1"));
        unicodeToGlyphNameMap.put(new Integer(18), ASName.create("DC2"));
        unicodeToGlyphNameMap.put(new Integer(19), ASName.create("DC3"));
        unicodeToGlyphNameMap.put(new Integer(20), ASName.create("DC4"));
        unicodeToGlyphNameMap.put(new Integer(21), ASName.create("NAK"));
        unicodeToGlyphNameMap.put(new Integer(22), ASName.create("SYN"));
        unicodeToGlyphNameMap.put(new Integer(23), ASName.create("ETB"));
        unicodeToGlyphNameMap.put(new Integer(24), ASName.create("CAN"));
        unicodeToGlyphNameMap.put(new Integer(25), ASName.create("EM"));
        unicodeToGlyphNameMap.put(new Integer(26), ASName.create("SUB"));
        unicodeToGlyphNameMap.put(new Integer(27), ASName.create("ESC"));
        unicodeToGlyphNameMap.put(new Integer(28), ASName.create("FS"));
        unicodeToGlyphNameMap.put(new Integer(29), ASName.create("GS"));
        unicodeToGlyphNameMap.put(new Integer(30), ASName.create("RS"));
        unicodeToGlyphNameMap.put(new Integer(31), ASName.create("US"));
        unicodeToGlyphNameMap.put(new Integer(32), ASName.create("space"));
        unicodeToGlyphNameMap.put(new Integer(33), ASName.create("exclam"));
        unicodeToGlyphNameMap.put(new Integer(34), ASName.create("quotedbl"));
        unicodeToGlyphNameMap.put(new Integer(35), ASName.create("numbersign"));
        unicodeToGlyphNameMap.put(new Integer(36), ASName.create("dollar"));
        unicodeToGlyphNameMap.put(new Integer(37), ASName.create("percent"));
        unicodeToGlyphNameMap.put(new Integer(38), ASName.create("ampersand"));
        unicodeToGlyphNameMap.put(new Integer(39), ASName.create("quotesingle"));
        unicodeToGlyphNameMap.put(new Integer(40), ASName.create("parenleft"));
        unicodeToGlyphNameMap.put(new Integer(41), ASName.create("parenright"));
        unicodeToGlyphNameMap.put(new Integer(42), ASName.create("asterisk"));
        unicodeToGlyphNameMap.put(new Integer(43), ASName.create("plus"));
        unicodeToGlyphNameMap.put(new Integer(44), ASName.create("comma"));
        unicodeToGlyphNameMap.put(new Integer(45), ASName.create("hyphen"));
        unicodeToGlyphNameMap.put(new Integer(46), ASName.create("period"));
        unicodeToGlyphNameMap.put(new Integer(47), ASName.create("slash"));
        unicodeToGlyphNameMap.put(new Integer(48), ASName.create("zero"));
        unicodeToGlyphNameMap.put(new Integer(49), ASName.create("one"));
        unicodeToGlyphNameMap.put(new Integer(50), ASName.create("two"));
        unicodeToGlyphNameMap.put(new Integer(51), ASName.create("three"));
        unicodeToGlyphNameMap.put(new Integer(52), ASName.create("four"));
        unicodeToGlyphNameMap.put(new Integer(53), ASName.create("five"));
        unicodeToGlyphNameMap.put(new Integer(54), ASName.create("six"));
        unicodeToGlyphNameMap.put(new Integer(55), ASName.create("seven"));
        unicodeToGlyphNameMap.put(new Integer(56), ASName.create("eight"));
        unicodeToGlyphNameMap.put(new Integer(57), ASName.create("nine"));
        unicodeToGlyphNameMap.put(new Integer(58), ASName.create("colon"));
        unicodeToGlyphNameMap.put(new Integer(59), ASName.create("semicolon"));
        unicodeToGlyphNameMap.put(new Integer(60), ASName.create("less"));
        unicodeToGlyphNameMap.put(new Integer(61), ASName.create("equal"));
        unicodeToGlyphNameMap.put(new Integer(62), ASName.create("greater"));
        unicodeToGlyphNameMap.put(new Integer(63), ASName.create("question"));
        unicodeToGlyphNameMap.put(new Integer(64), ASName.create("at"));
        unicodeToGlyphNameMap.put(new Integer(65), ASName.create("A"));
        unicodeToGlyphNameMap.put(new Integer(66), ASName.create("B"));
        unicodeToGlyphNameMap.put(new Integer(67), ASName.create("C"));
        unicodeToGlyphNameMap.put(new Integer(68), ASName.create("D"));
        unicodeToGlyphNameMap.put(new Integer(69), ASName.create("E"));
        unicodeToGlyphNameMap.put(new Integer(70), ASName.create("F"));
        unicodeToGlyphNameMap.put(new Integer(71), ASName.create("G"));
        unicodeToGlyphNameMap.put(new Integer(72), ASName.create("H"));
        unicodeToGlyphNameMap.put(new Integer(73), ASName.create("I"));
        unicodeToGlyphNameMap.put(new Integer(74), ASName.create("J"));
        unicodeToGlyphNameMap.put(new Integer(75), ASName.create("K"));
        unicodeToGlyphNameMap.put(new Integer(76), ASName.create("L"));
        unicodeToGlyphNameMap.put(new Integer(77), ASName.create("M"));
        unicodeToGlyphNameMap.put(new Integer(78), ASName.create("N"));
        unicodeToGlyphNameMap.put(new Integer(79), ASName.create("O"));
        unicodeToGlyphNameMap.put(new Integer(80), ASName.create("P"));
        unicodeToGlyphNameMap.put(new Integer(81), ASName.create("Q"));
        unicodeToGlyphNameMap.put(new Integer(82), ASName.create("R"));
        unicodeToGlyphNameMap.put(new Integer(83), ASName.create("S"));
        unicodeToGlyphNameMap.put(new Integer(84), ASName.create("T"));
        unicodeToGlyphNameMap.put(new Integer(85), ASName.create("U"));
        unicodeToGlyphNameMap.put(new Integer(86), ASName.create("V"));
        unicodeToGlyphNameMap.put(new Integer(87), ASName.create("W"));
        unicodeToGlyphNameMap.put(new Integer(88), ASName.create("X"));
        unicodeToGlyphNameMap.put(new Integer(89), ASName.create("Y"));
        unicodeToGlyphNameMap.put(new Integer(90), ASName.create("Z"));
        unicodeToGlyphNameMap.put(new Integer(91), ASName.create("bracketleft"));
        unicodeToGlyphNameMap.put(new Integer(92), ASName.create("backslash"));
        unicodeToGlyphNameMap.put(new Integer(93), ASName.create("bracketright"));
        unicodeToGlyphNameMap.put(new Integer(94), ASName.create("asciicircum"));
        unicodeToGlyphNameMap.put(new Integer(95), ASName.create("underscore"));
        unicodeToGlyphNameMap.put(new Integer(96), ASName.create("grave"));
        unicodeToGlyphNameMap.put(new Integer(97), ASName.create("a"));
        unicodeToGlyphNameMap.put(new Integer(98), ASName.create("b"));
        unicodeToGlyphNameMap.put(new Integer(99), ASName.create("c"));
        unicodeToGlyphNameMap.put(new Integer(100), ASName.create("d"));
        unicodeToGlyphNameMap.put(new Integer(101), ASName.create("e"));
        unicodeToGlyphNameMap.put(new Integer(102), ASName.create("f"));
        unicodeToGlyphNameMap.put(new Integer(103), ASName.create("g"));
        unicodeToGlyphNameMap.put(new Integer(104), ASName.create("h"));
        unicodeToGlyphNameMap.put(new Integer(105), ASName.create("i"));
        unicodeToGlyphNameMap.put(new Integer(106), ASName.create("j"));
        unicodeToGlyphNameMap.put(new Integer(107), ASName.create("k"));
        unicodeToGlyphNameMap.put(new Integer(108), ASName.create("l"));
        unicodeToGlyphNameMap.put(new Integer(109), ASName.create("m"));
        unicodeToGlyphNameMap.put(new Integer(110), ASName.create("n"));
        unicodeToGlyphNameMap.put(new Integer(111), ASName.create("o"));
        unicodeToGlyphNameMap.put(new Integer(112), ASName.create("p"));
        unicodeToGlyphNameMap.put(new Integer(113), ASName.create("q"));
        unicodeToGlyphNameMap.put(new Integer(114), ASName.create("r"));
        unicodeToGlyphNameMap.put(new Integer(115), ASName.create("s"));
        unicodeToGlyphNameMap.put(new Integer(116), ASName.create("t"));
        unicodeToGlyphNameMap.put(new Integer(117), ASName.create("u"));
        unicodeToGlyphNameMap.put(new Integer(118), ASName.create("v"));
        unicodeToGlyphNameMap.put(new Integer(119), ASName.create("w"));
        unicodeToGlyphNameMap.put(new Integer(120), ASName.create("x"));
        unicodeToGlyphNameMap.put(new Integer(121), ASName.create("y"));
        unicodeToGlyphNameMap.put(new Integer(122), ASName.create("z"));
        unicodeToGlyphNameMap.put(new Integer(123), ASName.create("braceleft"));
        unicodeToGlyphNameMap.put(new Integer(124), ASName.create("bar"));
        unicodeToGlyphNameMap.put(new Integer(125), ASName.create("braceright"));
        unicodeToGlyphNameMap.put(new Integer(126), ASName.create("asciitilde"));
        unicodeToGlyphNameMap.put(new Integer(771), ASName.create("tilde"));
        unicodeToGlyphNameMap.put(new Integer(161), ASName.create("exclamdown"));
        unicodeToGlyphNameMap.put(new Integer(162), ASName.create("cent"));
        unicodeToGlyphNameMap.put(new Integer(163), ASName.create("sterling"));
        unicodeToGlyphNameMap.put(new Integer(164), ASName.create("currency"));
        unicodeToGlyphNameMap.put(new Integer(165), ASName.create("yen"));
        unicodeToGlyphNameMap.put(new Integer(166), ASName.create("brokenbar"));
        unicodeToGlyphNameMap.put(new Integer(167), ASName.create("section"));
        unicodeToGlyphNameMap.put(new Integer(168), ASName.create("dieresis"));
        unicodeToGlyphNameMap.put(new Integer(169), ASName.create("copyright"));
        unicodeToGlyphNameMap.put(new Integer(170), ASName.create("ordfeminine"));
        unicodeToGlyphNameMap.put(new Integer(171), ASName.create("guillemotleft"));
        unicodeToGlyphNameMap.put(new Integer(172), ASName.create("logicalnot"));
        unicodeToGlyphNameMap.put(new Integer(174), ASName.create("registered"));
        unicodeToGlyphNameMap.put(new Integer(175), ASName.create("macron"));
        unicodeToGlyphNameMap.put(new Integer(176), ASName.create("degree"));
        unicodeToGlyphNameMap.put(new Integer(177), ASName.create("plusminus"));
        unicodeToGlyphNameMap.put(new Integer(178), ASName.create("twosuperior"));
        unicodeToGlyphNameMap.put(new Integer(179), ASName.create("threesuperior"));
        unicodeToGlyphNameMap.put(new Integer(180), ASName.create("acute"));
        unicodeToGlyphNameMap.put(new Integer(181), ASName.create("mu"));
        unicodeToGlyphNameMap.put(new Integer(182), ASName.create("paragraph"));
        unicodeToGlyphNameMap.put(new Integer(183), ASName.create("periodcentered"));
        unicodeToGlyphNameMap.put(new Integer(184), ASName.create("cedilla"));
        unicodeToGlyphNameMap.put(new Integer(185), ASName.create("onesuperior"));
        unicodeToGlyphNameMap.put(new Integer(186), ASName.create("ordmasculine"));
        unicodeToGlyphNameMap.put(new Integer(187), ASName.create("guillemotright"));
        unicodeToGlyphNameMap.put(new Integer(188), ASName.create("onequarter"));
        unicodeToGlyphNameMap.put(new Integer(189), ASName.create("onehalf"));
        unicodeToGlyphNameMap.put(new Integer(190), ASName.create("threequarters"));
        unicodeToGlyphNameMap.put(new Integer(191), ASName.create("questiondown"));
        unicodeToGlyphNameMap.put(new Integer(192), ASName.create("Agrave"));
        unicodeToGlyphNameMap.put(new Integer(193), ASName.create("Aacute"));
        unicodeToGlyphNameMap.put(new Integer(194), ASName.create("Acircumflex"));
        unicodeToGlyphNameMap.put(new Integer(195), ASName.create("Atilde"));
        unicodeToGlyphNameMap.put(new Integer(196), ASName.create("Adieresis"));
        unicodeToGlyphNameMap.put(new Integer(197), ASName.create("Aring"));
        unicodeToGlyphNameMap.put(new Integer(198), ASName.create("AE"));
        unicodeToGlyphNameMap.put(new Integer(199), ASName.create("Ccedilla"));
        unicodeToGlyphNameMap.put(new Integer(200), ASName.create("Egrave"));
        unicodeToGlyphNameMap.put(new Integer(201), ASName.create("Eacute"));
        unicodeToGlyphNameMap.put(new Integer(202), ASName.create("Ecircumflex"));
        unicodeToGlyphNameMap.put(new Integer(203), ASName.create("Edieresis"));
        unicodeToGlyphNameMap.put(new Integer(204), ASName.create("Igrave"));
        unicodeToGlyphNameMap.put(new Integer(205), ASName.create("Iacute"));
        unicodeToGlyphNameMap.put(new Integer(206), ASName.create("Icircumflex"));
        unicodeToGlyphNameMap.put(new Integer(207), ASName.create("Idieresis"));
        unicodeToGlyphNameMap.put(new Integer(208), ASName.create("Eth"));
        unicodeToGlyphNameMap.put(new Integer(209), ASName.create("Ntilde"));
        unicodeToGlyphNameMap.put(new Integer(210), ASName.create("Ograve"));
        unicodeToGlyphNameMap.put(new Integer(211), ASName.create("Oacute"));
        unicodeToGlyphNameMap.put(new Integer(212), ASName.create("Ocircumflex"));
        unicodeToGlyphNameMap.put(new Integer(213), ASName.create("Otilde"));
        unicodeToGlyphNameMap.put(new Integer(214), ASName.create("Odieresis"));
        unicodeToGlyphNameMap.put(new Integer(215), ASName.create("multiply"));
        unicodeToGlyphNameMap.put(new Integer(216), ASName.create("Oslash"));
        unicodeToGlyphNameMap.put(new Integer(217), ASName.create("Ugrave"));
        unicodeToGlyphNameMap.put(new Integer(218), ASName.create("Uacute"));
        unicodeToGlyphNameMap.put(new Integer(219), ASName.create("Ucircumflex"));
        unicodeToGlyphNameMap.put(new Integer(220), ASName.create("Udieresis"));
        unicodeToGlyphNameMap.put(new Integer(221), ASName.create("Yacute"));
        unicodeToGlyphNameMap.put(new Integer(222), ASName.create("Thorn"));
        unicodeToGlyphNameMap.put(new Integer(223), ASName.create("germandbls"));
        unicodeToGlyphNameMap.put(new Integer(224), ASName.create("agrave"));
        unicodeToGlyphNameMap.put(new Integer(225), ASName.create("aacute"));
        unicodeToGlyphNameMap.put(new Integer(226), ASName.create("acircumflex"));
        unicodeToGlyphNameMap.put(new Integer(227), ASName.create("atilde"));
        unicodeToGlyphNameMap.put(new Integer(228), ASName.create("adieresis"));
        unicodeToGlyphNameMap.put(new Integer(229), ASName.create("aring"));
        unicodeToGlyphNameMap.put(new Integer(230), ASName.create("ae"));
        unicodeToGlyphNameMap.put(new Integer(231), ASName.create("ccedilla"));
        unicodeToGlyphNameMap.put(new Integer(232), ASName.create("egrave"));
        unicodeToGlyphNameMap.put(new Integer(233), ASName.create("eacute"));
        unicodeToGlyphNameMap.put(new Integer(234), ASName.create("ecircumflex"));
        unicodeToGlyphNameMap.put(new Integer(235), ASName.create("edieresis"));
        unicodeToGlyphNameMap.put(new Integer(236), ASName.create("igrave"));
        unicodeToGlyphNameMap.put(new Integer(237), ASName.create("iacute"));
        unicodeToGlyphNameMap.put(new Integer(238), ASName.create("icircumflex"));
        unicodeToGlyphNameMap.put(new Integer(239), ASName.create("idieresis"));
        unicodeToGlyphNameMap.put(new Integer(240), ASName.create("eth"));
        unicodeToGlyphNameMap.put(new Integer(241), ASName.create("ntilde"));
        unicodeToGlyphNameMap.put(new Integer(242), ASName.create("ograve"));
        unicodeToGlyphNameMap.put(new Integer(243), ASName.create("oacute"));
        unicodeToGlyphNameMap.put(new Integer(244), ASName.create("ocircumflex"));
        unicodeToGlyphNameMap.put(new Integer(245), ASName.create("otilde"));
        unicodeToGlyphNameMap.put(new Integer(246), ASName.create("odieresis"));
        unicodeToGlyphNameMap.put(new Integer(247), ASName.create("divide"));
        unicodeToGlyphNameMap.put(new Integer(248), ASName.create("oslash"));
        unicodeToGlyphNameMap.put(new Integer(249), ASName.create("ugrave"));
        unicodeToGlyphNameMap.put(new Integer(250), ASName.create("uacute"));
        unicodeToGlyphNameMap.put(new Integer(251), ASName.create("ucircumflex"));
        unicodeToGlyphNameMap.put(new Integer(252), ASName.create("udieresis"));
        unicodeToGlyphNameMap.put(new Integer(253), ASName.create("yacute"));
        unicodeToGlyphNameMap.put(new Integer(254), ASName.create("thorn"));
        unicodeToGlyphNameMap.put(new Integer(255), ASName.create("ydieresis"));
    }
}

