/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFMetadata;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteStream;

class PDFFontFile
extends PDFCosObject
implements PDFInstantiate {
    PDFFontFile(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFFontFile", cosObject);
    }

    ASName getType() {
        if (this.getCosStream().containsKey(ASName.k_Subtype)) {
            return this.getCosStream().getName(ASName.k_Subtype);
        }
        return null;
    }

    long getLength1() {
        if (this.getCosStream().containsKey(ASName.k_Length1)) {
            return this.getCosStream().getLong(ASName.k_Length1);
        }
        return 0L;
    }

    long getLength2() {
        if (this.getCosStream().containsKey(ASName.k_Length2)) {
            return this.getCosStream().getLong(ASName.k_Length2);
        }
        return 0L;
    }

    long getLength3() {
        if (this.getCosStream().containsKey(ASName.k_Length3)) {
            return this.getCosStream().getLong(ASName.k_Length3);
        }
        return 0L;
    }

    PDFMetadata getMetaData() {
        if (this.getCosStream().containsKey(ASName.k_Metadata)) {
            return (PDFMetadata)PDFMetadata.instantiate(this.getCosStream().get(ASName.k_Metadata));
        }
        return null;
    }

    ByteStream getStream() {
        return this.getCosStream().getStream();
    }

    private boolean isValidFontFile() {
        int n = 0;
        if (this.getCosStream().containsKey(ASName.k_FontFile)) {
            ++n;
        }
        if (this.getCosStream().containsKey(ASName.k_FontFile2)) {
            ++n;
        }
        if (this.getCosStream().containsKey(ASName.k_FontFile3)) {
            ++n;
        }
        return n <= 1;
    }
}

