/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFontDescriptor;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFFontStretch;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASDictionary;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASRectangle;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.PDFStandardFontDescriptors;

public class PDFFontDescriptor {
    private PDFCosFontDescriptor cosDesc;
    private ASDictionary dictDesc;

    private PDFFontDescriptor(CosObject cosObject) {
        this.cosDesc = (PDFCosFontDescriptor)PDFCosFontDescriptor.instantiate(cosObject);
        this.dictDesc = null;
    }

    private PDFFontDescriptor(ASDictionary aSDictionary) {
        this.cosDesc = null;
        this.dictDesc = aSDictionary;
    }

    static PDFFontDescriptor instantiate(CosObject cosObject) {
        return new PDFFontDescriptor(cosObject);
    }

    static PDFFontDescriptor createForStandardFont(ASName aSName) {
        return new PDFFontDescriptor(PDFStandardFontDescriptors.get(aSName));
    }

    ASName getFontName() {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontName();
        }
        return this.dictDesc.getName(ASName.k_FontName);
    }

    ASString getFontFamily() {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontFamily();
        }
        if (this.dictDesc.containsKey(ASName.k_FontFamily)) {
            return this.dictDesc.getString(ASName.k_FontFamily);
        }
        return null;
    }

    PDFFontStretch getFontStretch() {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontStretch();
        }
        if (this.dictDesc.containsKey(ASName.k_FontStretch)) {
            ASName aSName = this.dictDesc.getName(ASName.k_FontStretch);
            return PDFFontStretch.getFontStretchForValue(aSName);
        }
        return null;
    }

    int getFontWeight() {
        int n = 400;
        if (this.cosDesc != null) {
            return this.cosDesc.getFontWeight();
        }
        if (this.dictDesc.containsKey(ASName.k_FontWeight)) {
            return this.dictDesc.getNumber(ASName.k_FontWeight).intValue();
        }
        return n;
    }

    int getFlags() {
        if (this.cosDesc != null) {
            return this.cosDesc.getFlags();
        }
        return this.dictDesc.getNumber(ASName.k_Flags).intValue();
    }

    boolean containsFontBBox() {
        if (this.cosDesc != null) {
            return this.cosDesc.containsFontBBox();
        }
        return this.dictDesc.containsKey(ASName.k_FontBBox);
    }

    ASRectangle getFontBBox() {
        if (this.cosDesc != null) {
            return new ASRectangle(this.cosDesc.getFontBBox().getValues());
        }
        if (this.dictDesc.containsKey(ASName.k_FontBBox)) {
            return (ASRectangle)this.dictDesc.get(ASName.k_FontBBox);
        }
        return null;
    }

    double getItalicAngle() {
        if (this.cosDesc != null) {
            return this.cosDesc.getItalicAngle();
        }
        return this.dictDesc.getNumber(ASName.k_FontBBox).doubleValue();
    }

    boolean containsAscent() {
        if (this.cosDesc != null) {
            return this.cosDesc.containsAscent();
        }
        return this.dictDesc.containsKey(ASName.k_Ascent);
    }

    double getAscent() {
        if (this.cosDesc != null) {
            return this.cosDesc.getAscent();
        }
        if (this.dictDesc.containsKey(ASName.k_Ascent)) {
            return this.dictDesc.getNumber(ASName.k_Ascent).doubleValue();
        }
        return 0.0;
    }

    boolean containsDescent() {
        if (this.cosDesc != null) {
            return this.cosDesc.containsDescent();
        }
        return this.dictDesc.containsKey(ASName.k_Descent);
    }

    double getDescent() {
        if (this.cosDesc != null) {
            return this.cosDesc.getDescent();
        }
        if (this.dictDesc.containsKey(ASName.k_Descent)) {
            return this.dictDesc.getNumber(ASName.k_Descent).doubleValue();
        }
        return 0.0;
    }

    double getLeading() {
        if (this.cosDesc != null) {
            return this.cosDesc.getLeading();
        }
        if (this.dictDesc.containsKey(ASName.k_Leading)) {
            return this.dictDesc.getNumber(ASName.k_Leading).doubleValue();
        }
        return 0.0;
    }

    boolean containsCapHeight() {
        if (this.cosDesc != null) {
            return this.cosDesc.containsCapHeight();
        }
        return this.dictDesc.containsKey(ASName.k_CapHeight);
    }

    double getCapHeight() {
        if (this.cosDesc != null) {
            return this.cosDesc.getCapHeight();
        }
        if (this.dictDesc.containsKey(ASName.k_CapHeight)) {
            return this.dictDesc.getNumber(ASName.k_CapHeight).doubleValue();
        }
        return 0.0;
    }

    double getXHeight() {
        if (this.cosDesc != null) {
            return this.cosDesc.getXHeight();
        }
        if (this.dictDesc.containsKey(ASName.k_XHeight)) {
            return this.dictDesc.getNumber(ASName.k_XHeight).doubleValue();
        }
        return 0.0;
    }

    boolean containsStemV() {
        if (this.cosDesc != null) {
            return this.cosDesc.containsStemV();
        }
        return this.dictDesc.containsKey(ASName.k_StemV);
    }

    double getStemV() {
        if (this.cosDesc != null) {
            return this.cosDesc.getStemV();
        }
        if (this.dictDesc.containsKey(ASName.k_StemV)) {
            return this.dictDesc.getNumber(ASName.k_StemV).doubleValue();
        }
        return 0.0;
    }

    double getStemH() {
        if (this.cosDesc != null) {
            return this.cosDesc.getStemH();
        }
        if (this.dictDesc.containsKey(ASName.k_StemH)) {
            return this.dictDesc.getNumber(ASName.k_StemH).doubleValue();
        }
        return 0.0;
    }

    double getAvgWidth() {
        if (this.cosDesc != null) {
            return this.cosDesc.getAvgWidth();
        }
        if (this.dictDesc.containsKey(ASName.k_AvgWidth)) {
            return this.dictDesc.getNumber(ASName.k_AvgWidth).doubleValue();
        }
        return 0.0;
    }

    double getMaxWidth() {
        if (this.cosDesc != null) {
            return this.cosDesc.getMaxWidth();
        }
        if (this.dictDesc.containsKey(ASName.k_MaxWidth)) {
            return this.dictDesc.getNumber(ASName.k_MaxWidth).doubleValue();
        }
        return 0.0;
    }

    double getMissingWidth() {
        if (this.cosDesc != null) {
            return this.cosDesc.getMissingWidth();
        }
        if (this.dictDesc.containsKey(ASName.k_MissingWidth)) {
            return this.dictDesc.getNumber(ASName.k_MissingWidth).doubleValue();
        }
        return 0.0;
    }

    PDFCosObject getFontFile() {
        return null;
    }

    ByteStream getFontFile2() {
        return null;
    }

    ByteStream getFontFile3() {
        return null;
    }

    ASString getCharSet() {
        return null;
    }
}

