/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFEmbeddedFile;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;

public class PDFFileSpecification
extends PDFCosObject
implements PDFInstantiate {
    PDFFileSpecification(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFFileSpecification", cosObject);
    }

    public static PDFFileSpecification create(PDFDocument pDFDocument, byte[] byArray, PDFEmbeddedFile pDFEmbeddedFile) {
        return PDFFileSpecification.create(pDFDocument, new ASString(byArray), pDFEmbeddedFile);
    }

    public static PDFFileSpecification create(PDFDocument pDFDocument, ASString aSString, PDFEmbeddedFile pDFEmbeddedFile) {
        PDFFileSpecification pDFFileSpecification = (PDFFileSpecification)PDFCosFactory.newDictionary(pDFDocument, "PDFFileSpecification");
        CosDictionary cosDictionary = pDFFileSpecification.getCosDictionary();
        cosDictionary.put(ASName.k_Type, ASName.k_Filespec);
        cosDictionary.put(ASName.k_F, aSString);
        pDFFileSpecification.setEmbeddedFile(pDFEmbeddedFile);
        return pDFFileSpecification;
    }

    public boolean hasFilename() {
        return this.getCosDictionary().containsKey(ASName.k_F);
    }

    public ASString getFilename() {
        return this.getDictionaryStringValue(ASName.k_F);
    }

    public void setFileName(byte[] byArray) {
        this.setDictionaryASStringValue(ASName.k_F, new ASString(byArray));
    }

    public boolean hasEmbeddedFile() {
        CosDictionary cosDictionary = this.getDictionaryDictionaryValue(ASName.k_EF);
        return cosDictionary != null ? cosDictionary.containsKey(ASName.k_F) : false;
    }

    public PDFEmbeddedFile getEmbeddedFile() {
        CosDictionary cosDictionary = this.getDictionaryDictionaryValue(ASName.k_EF);
        return (PDFEmbeddedFile)PDFEmbeddedFile.instantiate(cosDictionary.get(ASName.k_F));
    }

    public PDFEmbeddedFile getOrMakeEmbeddedFile() {
        if (this.hasEmbeddedFile()) {
            return this.getEmbeddedFile();
        }
        return PDFEmbeddedFile.create(this.getPDFDocument());
    }

    public void setEmbeddedFile(PDFEmbeddedFile pDFEmbeddedFile) {
        if (pDFEmbeddedFile != null) {
            CosDictionary cosDictionary = this.hasEmbeddedFile() ? this.getEmbeddedFile().getCosDictionary() : this.getPDFDocument().getDocument().newDictionary();
            cosDictionary.put(ASName.k_F, pDFEmbeddedFile.getCosObject());
            this.getCosDictionary().put(ASName.k_EF, cosDictionary);
        }
    }
}

