/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFField;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;

public class PDFFieldButton
extends PDFField
implements PDFInstantiate {
    final int kPushButton = 131072;
    final int kRadioButton = 65536;
    final int kNoToggleToOff = 32768;

    PDFFieldButton(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFFieldButton", cosObject);
    }

    boolean isPushButton() {
        return (super.getFlags() & 0x20000) != 0;
    }

    public boolean isCheckBox() {
        return !this.isPushButton() && !this.isRadioButton();
    }

    boolean isRadioButton() {
        return (super.getFlags() & 0x10000) != 0;
    }

    public void setStateFromValue() {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_V);
        if (cosObject != null && cosObject instanceof CosName) {
            this.setDictionaryNameValue(ASName.k_AS, ((CosName)cosObject).nameValue());
        }
    }
}

