/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFAnnotation;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFFieldButton;
import com.adobe.internal.pdf.PDFFieldChoice;
import com.adobe.internal.pdf.PDFFieldList;
import com.adobe.internal.pdf.PDFFieldNode;
import com.adobe.internal.pdf.PDFFieldSignature;
import com.adobe.internal.pdf.PDFFieldText;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFText;
import com.adobe.internal.pdf.PDFVariableText;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class PDFField
extends PDFCosObject
implements PDFInstantiate {
    final int kReadOnly = 1;
    final int kRequire = 2;
    final int kNoExport = 4;

    PDFField(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        if (cosObject == null) {
            return null;
        }
        if (!PDFField.isTerminalField((CosDictionary)cosObject)) {
            return PDFFieldNode.instantiate(cosObject);
        }
        ASName aSName = PDFField.getInheritedType((CosDictionary)cosObject);
        if (aSName == ASName.k_Btn) {
            return PDFFieldButton.instantiate(cosObject);
        }
        if (aSName == ASName.k_Tx) {
            return PDFFieldText.instantiate(cosObject);
        }
        if (aSName == ASName.k_Ch) {
            return PDFFieldChoice.instantiate(cosObject);
        }
        if (aSName == ASName.k_Sig) {
            return PDFFieldSignature.instantiate(cosObject);
        }
        return null;
    }

    private static boolean isTerminalField(CosDictionary cosDictionary) {
        if (cosDictionary.get(ASName.k_V) != null) {
            return true;
        }
        if (cosDictionary.get(ASName.k_RV) != null) {
            return true;
        }
        CosObject cosObject = cosDictionary.get(ASName.k_Kids);
        if (cosObject == null) {
            return true;
        }
        CosDictionary cosDictionary2 = (CosDictionary)((CosArray)cosObject).get(0);
        return cosDictionary2.get(ASName.k_Type) != null && cosDictionary2.getName(ASName.k_Type) == ASName.k_Annot && cosDictionary2.get(ASName.k_T) == null;
    }

    static ASName getInheritedType(CosDictionary cosDictionary) {
        if (cosDictionary == null) {
            return null;
        }
        CosName cosName = (CosName)cosDictionary.get(ASName.k_FT);
        if (cosName == null) {
            CosDictionary cosDictionary2 = (CosDictionary)cosDictionary.get(ASName.k_Parent);
            return PDFField.getInheritedType(cosDictionary2);
        }
        return cosName.nameValue();
    }

    ASName getType() {
        return PDFField.getInheritedType(this.getCosDictionary());
    }

    PDFFieldList getChildren() {
        return (PDFFieldList)PDFFieldList.instantiate(this.getValue(ASName.k_Kids));
    }

    PDFField getParent() {
        return (PDFField)PDFField.instantiate(this.getValue(ASName.k_Parent));
    }

    public String getPartialName() {
        return this.getDictionaryTextStringValue(ASName.k_T);
    }

    void setPartialName(String string) {
        this.setDictionaryStringValue(ASName.k_T, string);
    }

    public String getValueRichText() {
        return this.getDictionaryTextStringOrStreamValue(ASName.k_RV);
    }

    String getAlternateName() {
        return this.getDictionaryTextStringValue(ASName.k_TU);
    }

    String getMappingName() {
        return this.getDictionaryTextStringValue(ASName.k_TM);
    }

    String getQualifiedName() {
        PDFField pDFField = this.getParent();
        if (pDFField == null) {
            return this.getPartialName();
        }
        return pDFField.getQualifiedName() + "." + this.getPartialName();
    }

    int getFlags() {
        Number number = this.getDictionaryNumericValue(ASName.k_Ff);
        return number == null ? 0 : number.intValue();
    }

    private CosObject getOptionValue() {
        return super.getCosDictionary().get(ASName.k_Opt);
    }

    public boolean hasOptionList() {
        return super.getCosDictionary().get(ASName.k_Opt) != null;
    }

    public List getOptionList() {
        if (!this.hasOptionList()) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        CosObject cosObject = this.getOptionValue();
        if (cosObject.getType() == 5) {
            CosArray cosArray = (CosArray)this.getOptionValue();
            for (int i = 0; i < cosArray.size(); ++i) {
                PDFText pDFText = new PDFText(cosArray.getCosString(i));
                linkedList.add(pDFText.stringValue());
            }
        } else if (cosObject.getType() == 4) {
            PDFText pDFText = new PDFText(cosObject);
            linkedList.add(pDFText.stringValue());
        }
        return linkedList;
    }

    private List getValueListImpl(ASName aSName) {
        CosObject cosObject = this.getCosDictionary().get(aSName);
        if (cosObject == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (cosObject instanceof CosName) {
            linkedList.add(((CosName)cosObject).nameValue().toString());
        } else if (cosObject instanceof CosArray) {
            CosArray cosArray = (CosArray)cosObject;
            for (int i = 0; i < cosArray.size(); ++i) {
                PDFText pDFText = new PDFText(cosArray.get(i));
                linkedList.add(pDFText.stringValue());
            }
        } else {
            PDFText pDFText = new PDFText(cosObject);
            linkedList.add(pDFText.stringValue());
        }
        return linkedList;
    }

    public List getValueList() {
        return this.getValueListImpl(ASName.k_V);
    }

    List getDefaultValueList() {
        return this.getValueListImpl(ASName.k_DV);
    }

    InputStream getRichText() {
        return this.getDictionaryStreamValue(ASName.k_RV);
    }

    boolean setRichText(InputStream inputStream) {
        return false;
    }

    public void setRichText(PDFText pDFText) {
        this.setDictionaryTextValue(ASName.k_RV, pDFText);
    }

    void setStringValue(String string) {
        this.setDictionaryTextValue(ASName.k_V, PDFText.create(this.getPDFDocument(), string));
    }

    public void setTextValue(PDFText pDFText) {
        this.setDictionaryTextValue(ASName.k_V, pDFText);
    }

    public void removeValue() {
        this.getCosDictionary().remove(ASName.k_V);
    }

    public void setNameValue(ASName aSName) {
        this.setDictionaryNameValue(ASName.k_V, aSName);
    }

    public void setListValue(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        CosArray cosArray = this.getPDFDocument().getDocument().newArray();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                cosArray.addString((String)e);
            }
            if (e instanceof PDFText) {
                cosArray.add(((PDFText)e).getCosObject());
                continue;
            }
            throw new PDFInvalidParameterException("Bad value type in list");
        }
        if (!cosArray.isEmpty()) {
            this.getCosDictionary().put(ASName.k_V, cosArray);
        }
    }

    PDFVariableText getVaribleText() {
        return (PDFVariableText)PDFVariableText.instantiate(this.getCosObject());
    }

    PDFAnnotation getAnnotation() {
        if (this.getCosDictionary().containsKey(ASName.k_Type)) {
            return (PDFAnnotation)PDFAnnotation.instantiate(this.getCosObject());
        }
        return null;
    }

    public boolean noExport() {
        return (this.getFlags() & 4) != 0;
    }
}

