/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.AdobeGlyphList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PDFEncodingDifferences
extends PDFCosObject
implements PDFInstantiate {
    private HashMap diffs = this.initDiffs();

    PDFEncodingDifferences(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFEncodingDifferences", cosObject);
    }

    public boolean contains(int n) {
        return this.diffs.containsKey(new Integer(n));
    }

    public boolean contains(ASName aSName) {
        return this.diffs.containsValue(aSName);
    }

    public ASName toGlyphName(int n) {
        if (this.contains(n)) {
            return (ASName)this.diffs.get(new Integer(n));
        }
        return null;
    }

    public char[] toUnicode(int n) {
        ASName aSName = this.toGlyphName(n);
        if (aSName != null) {
            AdobeGlyphList adobeGlyphList = AdobeGlyphList.get();
            return adobeGlyphList.toUnicode(aSName);
        }
        char[] cArray = new char[]{'\ufffd'};
        return cArray;
    }

    public int fromGlyphName(ASName aSName) {
        if (this.contains(aSName)) {
            Set set = this.diffs.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ASName aSName2 = (ASName)entry.getValue();
                if (aSName2 != aSName) continue;
                Integer n = (Integer)entry.getKey();
                return n;
            }
        }
        return 0;
    }

    private HashMap initDiffs() {
        CosArray cosArray = this.getCosArray();
        HashMap<Integer, ASName> hashMap = new HashMap<Integer, ASName>(cosArray.size() - 1);
        Iterator iterator = cosArray.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CosObject cosObject = (CosObject)iterator.next();
            if (cosObject instanceof CosNumeric) {
                n = ((CosNumeric)cosObject).intValue();
                continue;
            }
            if (!(cosObject instanceof CosName)) continue;
            hashMap.put(new Integer(n++), ((CosName)cosObject).nameValue());
        }
        return hashMap;
    }
}

