/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASDate;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;

public class PDFEmbeddedFileInfo
extends PDFCosObject
implements PDFInstantiate {
    PDFEmbeddedFileInfo(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFEmbeddedFileInfo", cosObject);
    }

    static PDFEmbeddedFileInfo create(PDFDocument pDFDocument, int n, ASDate aSDate, ASDate aSDate2) {
        PDFEmbeddedFileInfo pDFEmbeddedFileInfo = (PDFEmbeddedFileInfo)PDFCosFactory.newDictionary(pDFDocument, "PDFEmbeddedFileInfo");
        CosDictionary cosDictionary = (CosDictionary)pDFEmbeddedFileInfo.getCosObject();
        cosDictionary.put(ASName.k_Size, n);
        cosDictionary.put(ASName.k_CreationDate, aSDate.asString());
        cosDictionary.put(ASName.k_ModDate, aSDate2.asString());
        return pDFEmbeddedFileInfo;
    }

    public boolean hasModificationDate() {
        return this.getCosDictionary().containsKey(ASName.k_ModDate);
    }

    public String getModificationDate() {
        return this.hasModificationDate() ? this.getCosDictionary().getCosString(ASName.k_ModDate).stringValue().toString() : null;
    }

    public void setModificationDate(String string) {
        this.setDictionaryStringValue(ASName.k_ModDate, string);
    }

    public boolean hasCreationDate() {
        return this.getCosDictionary().containsKey(ASName.k_CreationDate);
    }

    public String getCreationDate() {
        return this.hasModificationDate() ? this.getCosDictionary().getCosString(ASName.k_CreationDate).stringValue().toString() : null;
    }

    public void setCreationDate(String string) {
        this.setDictionaryStringValue(ASName.k_CreationDate, string);
    }

    public boolean hasChecksum() {
        return this.getCosDictionary().containsKey(ASName.k_CheckSum);
    }

    public ASString getCheckSum() {
        return this.hasChecksum() ? this.getCosDictionary().getString(ASName.k_CheckSum) : null;
    }

    public void setCheckSum(byte[] byArray) {
        this.setDictionaryASStringValue(ASName.k_CheckSum, new ASString(byArray));
    }

    public boolean hasSize() {
        return this.getCosDictionary().containsKey(ASName.k_Size);
    }

    public int getSize() {
        return this.getCosDictionary().getInt(ASName.k_Size);
    }

    public void setSize(String string) {
        this.setDictionaryIntValue(ASName.k_Size, string);
    }
}

