/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFEmbeddedFileInfo;
import com.adobe.internal.pdf.PDFFilterFlate;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.DataAccess;
import com.adobe.internal.pdf.cos.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PDFEmbeddedFile
extends PDFCosObject
implements PDFInstantiate {
    PDFEmbeddedFile(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFEmbeddedFile", cosObject);
    }

    private static void setAttrs(CosStream cosStream, PDFDocument pDFDocument, PDFEmbeddedFileInfo pDFEmbeddedFileInfo, boolean bl) {
        cosStream.put(ASName.k_Type, ASName.k_EmbeddedFiles);
        if (bl) {
            PDFFilterFlate pDFFilterFlate = PDFFilterFlate.create(pDFDocument);
            cosStream.put(ASName.k_Filter, pDFFilterFlate.getCosObject());
        }
        if (pDFEmbeddedFileInfo != null) {
            cosStream.put(ASName.k_Params, pDFEmbeddedFileInfo.getCosObject());
        }
    }

    static PDFEmbeddedFile create(PDFDocument pDFDocument) {
        PDFEmbeddedFile pDFEmbeddedFile = (PDFEmbeddedFile)PDFCosFactory.newStream(pDFDocument, "PDFEmbeddedFile");
        PDFEmbeddedFile.setAttrs(pDFEmbeddedFile.getCosStream(), pDFDocument, null, false);
        return pDFEmbeddedFile;
    }

    public static PDFEmbeddedFile create(PDFDocument pDFDocument, PDFEmbeddedFileInfo pDFEmbeddedFileInfo, InputStream inputStream, boolean bl) {
        PDFEmbeddedFile pDFEmbeddedFile = (PDFEmbeddedFile)PDFCosFactory.newStream(pDFDocument, inputStream, "PDFEmbeddedFile");
        PDFEmbeddedFile.setAttrs(pDFEmbeddedFile.getCosStream(), pDFDocument, pDFEmbeddedFileInfo, bl);
        return pDFEmbeddedFile;
    }

    static PDFEmbeddedFile create(PDFDocument pDFDocument, PDFEmbeddedFileInfo pDFEmbeddedFileInfo, DataAccess dataAccess, boolean bl) {
        PDFEmbeddedFile pDFEmbeddedFile = (PDFEmbeddedFile)PDFCosFactory.newStream(pDFDocument, dataAccess, "PDFEmbeddedFile");
        PDFEmbeddedFile.setAttrs(pDFEmbeddedFile.getCosStream(), pDFDocument, pDFEmbeddedFileInfo, bl);
        return pDFEmbeddedFile;
    }

    public InputStream getFileData() throws IOException {
        return this.getCosStream().getStream();
    }

    public void getFileData(OutputStream outputStream) throws IOException {
        IO.copy(this.getCosStream().getStream(), outputStream);
    }

    public boolean hasFileInfo() {
        return this.getCosStream().containsKey(ASName.k_Params);
    }

    public PDFEmbeddedFileInfo getFileInfo() {
        if (this.hasFileInfo()) {
            return (PDFEmbeddedFileInfo)PDFEmbeddedFileInfo.instantiate(this.getCosStream().getCosDictionary(ASName.k_Params));
        }
        return null;
    }

    public PDFEmbeddedFileInfo getOrMakeFileInfo() {
        if (this.hasFileInfo()) {
            return this.getFileInfo();
        }
        return new PDFEmbeddedFileInfo(this.getPDFDocument().getDocument().newDictionary());
    }

    public void setFileInfo(PDFEmbeddedFileInfo pDFEmbeddedFileInfo) {
        this.getCosStream().put(ASName.k_Params, pDFEmbeddedFileInfo.getCosObject());
    }

    public boolean hasMIMEType() {
        return this.getCosStream().containsKey(ASName.k_Subtype);
    }

    public String getMIMEType() {
        return this.getCosStream().getName(ASName.k_Subtype).toString();
    }

    public void setMIMEType(String string) {
        this.getCosStream().put(ASName.k_Subtype, ASName.create(string));
    }

    public CosStream getFileStream() {
        return (CosStream)this.getCosObject();
    }

    DataAccess getStream() {
        return this.getCosStream().getStream().getByteBuffer();
    }
}

