/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCatalog;
import com.adobe.internal.pdf.PDFDocumentInfo;
import com.adobe.internal.pdf.PDFFileSpecification;
import com.adobe.internal.pdf.PDFInteractiveForm;
import com.adobe.internal.pdf.PDFMetadata;
import com.adobe.internal.pdf.PDFNameDictionary;
import com.adobe.internal.pdf.PDFNameTree;
import com.adobe.internal.pdf.PDFPageTree;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.DataAccess;
import com.adobe.internal.pdf.cos.util.DataAccessByteRepository;
import com.adobe.internal.pdf.cos.util.OutputByteBuffer;
import com.adobe.internal.pdf.cos.util.Utility;
import com.adobe.internal.xdp.PDF2XDPWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class PDFDocument {
    private CosDocument mCosDocument;

    public PDFDocument(InputStream inputStream) {
        this.mCosDocument = new CosDocument(inputStream);
        this.mCosDocument.setUserData(ASName.k_Client_Data_PDF, this);
    }

    public PDFDocument(DataAccess dataAccess) {
        this.mCosDocument = new CosDocument(dataAccess);
        this.mCosDocument.setUserData(ASName.k_Client_Data_PDF, this);
    }

    public String getVersion() {
        return this.mCosDocument.getVersion();
    }

    PDFCatalog requireCatalog() {
        return (PDFCatalog)PDFCatalog.requireInstance(this.mCosDocument.getRoot());
    }

    PDFDocumentInfo getDocumentInfo() {
        return (PDFDocumentInfo)PDFDocumentInfo.instantiate(this.mCosDocument.getInfo());
    }

    public PDFPageTree requirePages() {
        return this.requireCatalog().requirePages();
    }

    public PDFInteractiveForm getInteractiveForm() {
        return this.requireCatalog().getInteractiveForm();
    }

    private void putEmbeddedFile(ASString aSString, PDFFileSpecification pDFFileSpecification, boolean bl) {
        PDFNameDictionary pDFNameDictionary = this.requireCatalog().getNameDictionary();
        if (pDFNameDictionary == null) {
            pDFNameDictionary = PDFNameDictionary.create(this);
            this.requireCatalog().setValue(ASName.k_Names, pDFNameDictionary.getCosObject());
        }
        pDFNameDictionary.putEmbeddedFile(aSString, pDFFileSpecification, bl);
    }

    public void replaceEmbeddedFile(ASString aSString, PDFFileSpecification pDFFileSpecification) {
        this.putEmbeddedFile(aSString, pDFFileSpecification, true);
    }

    public void addEmbeddedFile(ASString aSString, PDFFileSpecification pDFFileSpecification) {
        this.putEmbeddedFile(aSString, pDFFileSpecification, false);
    }

    public PDFFileSpecification getEmbeddedFile(ASString aSString) {
        PDFNameDictionary pDFNameDictionary = this.requireCatalog().getNameDictionary();
        if (pDFNameDictionary == null) {
            return null;
        }
        return pDFNameDictionary.getEmbeddedFile(aSString);
    }

    public boolean deleteEmbeddedFile(ASString aSString) {
        PDFNameDictionary pDFNameDictionary = this.requireCatalog().getNameDictionary();
        if (pDFNameDictionary == null) {
            return false;
        }
        return pDFNameDictionary.deleteEmbeddedFile(aSString);
    }

    public List getEmbeddedFileKeys() {
        PDFNameDictionary pDFNameDictionary = this.requireCatalog().getNameDictionary();
        if (pDFNameDictionary == null) {
            return null;
        }
        PDFNameTree pDFNameTree = pDFNameDictionary.getEmbeddedFiles();
        if (pDFNameTree == null) {
            return null;
        }
        Iterator iterator = pDFNameTree.keyIterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public void importXFA(DataAccess dataAccess) throws SAXException, TransformerConfigurationException, TransformerException {
        PDFInteractiveForm pDFInteractiveForm = this.getInteractiveForm();
        if (pDFInteractiveForm == null) {
            return;
        }
        ByteStream byteStream = new ByteStream(new DataAccessByteRepository(dataAccess));
        pDFInteractiveForm.importXFAData(byteStream);
    }

    public InputStream exportXMP() throws IOException {
        PDFMetadata pDFMetadata = this.requireCatalog().getMetadata();
        if (pDFMetadata == null) {
            return null;
        }
        return pDFMetadata.getData();
    }

    public void importXMP(InputStream inputStream) throws IOException {
        PDFMetadata pDFMetadata = this.requireCatalog().getMetadata();
        if (pDFMetadata == null) {
            pDFMetadata = PDFMetadata.create(this, inputStream, 2048);
            this.requireCatalog().setMetadata(pDFMetadata);
        } else {
            pDFMetadata.setData(inputStream, 2048);
        }
    }

    boolean isEncrypted() {
        return false;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.mCosDocument.save(outputStream);
    }

    public DataAccess save() throws IOException {
        return this.mCosDocument.save();
    }

    public InputStream save(boolean bl) throws IOException {
        return this.mCosDocument.save(bl);
    }

    public InputStream saveAsXDP() throws TransformerConfigurationException, SAXException, TransformerException {
        OutputByteBuffer outputByteBuffer = new OutputByteBuffer();
        Utility.transformToXML(new PDF2XDPWriter(this), null, outputByteBuffer);
        return new ByteStream(outputByteBuffer.getBuffer());
    }

    public CosDocument getDocument() {
        return this.mCosDocument;
    }
}

