/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNull;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;
import java.util.ArrayList;

public class PDFDestination
extends PDFCosObject
implements PDFInstantiate {
    public static final int DEST_NONE = 0;
    public static final int DEST_NAME = 1;
    public static final int DEST_XYZ = 2;
    public static final int DEST_FIT = 3;
    public static final int DEST_FITH = 4;
    public static final int DEST_FITV = 5;
    public static final int DEST_FITR = 6;
    public static final int DEST_FITB = 7;
    public static final int DEST_FITBH = 8;
    public static final int DEST_FITBV = 9;

    public PDFDestination(CosObject cosObject) {
        super(cosObject);
    }

    public static PDFDestination create(PDFDocument pDFDocument, byte[] byArray) {
        return new PDFDestination(pDFDocument.getDocument().newString(byArray));
    }

    public static PDFDestination create(PDFDocument pDFDocument) {
        CosArray cosArray = pDFDocument.getDocument().newArray(new ArrayList(6));
        CosNull cosNull = pDFDocument.getDocument().newNull();
        for (int i = 0; i < 6; ++i) {
            cosArray.add(cosNull);
        }
        return new PDFDestination(cosArray);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFDestination", cosObject);
    }

    public int getType() {
        int n = 0;
        switch (this.getCosObject().getType()) {
            case 3: 
            case 4: {
                n = 1;
                break;
            }
            case 5: {
                ASName aSName = ((CosArray)this.getCosObject()).getName(1);
                n = aSName != null ? (aSName.equals(ASName.k_XYZ) ? 2 : (aSName.equals(ASName.k_Fit) ? 3 : (aSName.equals(ASName.k_FitH) ? 4 : (aSName.equals(ASName.k_FitV) ? 5 : (aSName.equals(ASName.k_FitR) ? 6 : (aSName.equals(ASName.k_FitB) ? 7 : (aSName.equals(ASName.k_FitBH) ? 8 : (aSName.equals(ASName.k_FitBV) ? 9 : 0)))))))) : 0;
            }
        }
        return n;
    }

    public String getTypeAsString() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return ((CosArray)this.getCosObject()).getName(1).toString();
    }

    public void setType(String string) {
        CosArray cosArray = (CosArray)this.getCosObject();
        cosArray.setName(1, string);
    }

    public String getDestName() {
        CosObject cosObject = this.getCosObject();
        switch (cosObject.getType()) {
            case 3: {
                return ((CosName)cosObject).nameValue().toString();
            }
            case 4: {
                return PDFDocEncoding.toEscapeString(((CosString)cosObject).stringValue().getBytes());
            }
        }
        return null;
    }

    public String getPage() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        CosObject cosObject = ((CosArray)this.getCosObject()).get(0);
        if (cosObject instanceof CosNumeric) {
            return Integer.toString(cosObject.intValue());
        }
        PDFPage pDFPage = (PDFPage)PDFPage.instantiate(cosObject);
        return Integer.toString(pDFPage.getIndex());
    }

    public void setPage(String string, boolean bl) {
        CosArray cosArray = (CosArray)this.getCosObject();
        int n = Integer.valueOf(string);
        if (bl) {
            cosArray.setInt(0, n);
        } else {
            cosArray.set(0, this.getPDFDocument().requirePages().getPage(n).getCosObject());
        }
    }

    public String getLeftOrTop() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        CosObject cosObject = ((CosArray)this.getCosObject()).get(2);
        return cosObject instanceof CosNull ? null : Double.toString(cosObject.doubleValue());
    }

    public void setLeftOrTop(String string) {
        CosArray cosArray = (CosArray)this.getCosObject();
        cosArray.setDouble(2, Double.valueOf(string));
    }

    public String getTopOrBottom() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        CosObject cosObject = ((CosArray)this.getCosObject()).get(3);
        return cosObject instanceof CosNull ? null : Double.toString(cosObject.doubleValue());
    }

    public void setTopOrBottom(String string) {
        CosArray cosArray = (CosArray)this.getCosObject();
        cosArray.setDouble(3, Double.valueOf(string));
    }

    public String getZoomOrRight() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        CosObject cosObject = ((CosArray)this.getCosObject()).get(4);
        return cosObject instanceof CosNull ? null : Double.toString(cosObject.doubleValue());
    }

    public void setZoomOrRight(String string) {
        CosArray cosArray = (CosArray)this.getCosObject();
        cosArray.setDouble(4, Double.valueOf(string));
    }

    public String getTop() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        CosObject cosObject = ((CosArray)this.getCosObject()).get(5);
        return cosObject instanceof CosNull ? null : Double.toString(cosObject.doubleValue());
    }

    public void setTop(String string) {
        CosArray cosArray = (CosArray)this.getCosObject();
        cosArray.setDouble(5, Double.valueOf(string));
    }

    public void finalizeArray() {
        CosArray cosArray = (CosArray)this.getCosObject();
        switch (this.getType()) {
            case 3: 
            case 7: {
                cosArray.remove(cosArray.size() - 1);
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                cosArray.remove(cosArray.size() - 1);
                cosArray.remove(cosArray.size() - 1);
            }
            case 2: {
                cosArray.remove(cosArray.size() - 1);
            }
        }
    }
}

