/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFText;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.CosString;
import com.adobe.internal.pdf.cos.util.ASDate;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import com.adobe.internal.pdf.cos.util.exceptions.PDFInvalidParameterException;
import com.adobe.pdf.exceptions.PDFException;
import java.util.ArrayList;
import java.util.Iterator;

class PDFCosObject {
    protected CosObject mCosObject;

    PDFCosObject(CosObject cosObject) {
        this.mCosObject = cosObject;
    }

    public PDFDocument getPDFDocument() {
        return (PDFDocument)this.mCosObject.getDocument().getUserData(ASName.k_Client_Data_PDF);
    }

    public CosObject getCosObject() {
        return this.mCosObject;
    }

    public CosObject getValue(ASName aSName) {
        if (this.mCosObject == null) {
            return null;
        }
        return ((CosDictionary)this.mCosObject).get(aSName);
    }

    CosObject getValue(int n) {
        if (this.mCosObject == null) {
            return null;
        }
        return ((CosArray)this.mCosObject).get(n);
    }

    public void setValue(ASName aSName, CosObject cosObject) {
        if (this.mCosObject == null) {
            return;
        }
        ((CosDictionary)this.mCosObject).put(aSName, cosObject);
    }

    void addValue(CosObject cosObject) {
        if (this.mCosObject == null) {
            return;
        }
        ((CosArray)this.mCosObject).add(cosObject);
    }

    boolean removeValue(ASName aSName) {
        if (this.mCosObject != null && ((CosDictionary)this.mCosObject).containsKey(aSName)) {
            this.getCosDictionary().remove(aSName);
            return true;
        }
        return false;
    }

    CosDictionary getCosDictionary() {
        if (this.mCosObject instanceof CosDictionary) {
            return (CosDictionary)this.mCosObject;
        }
        throw new PDFException("CosObject is not a CosDictionary");
    }

    public boolean dictionaryContains(ASName aSName) {
        return this.getValue(aSName) != null;
    }

    String getDictionaryTextStringValue(ASName aSName) {
        CosObject cosObject = this.getCosDictionary().get(aSName);
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() != 4) {
            throw new PDFException("attempt to get text string from non-string object");
        }
        PDFText pDFText = new PDFText(cosObject);
        return pDFText.stringValue();
    }

    String getDictionaryTextStringOrStreamValue(ASName aSName) {
        CosObject cosObject = this.getCosDictionary().get(aSName);
        if (cosObject == null) {
            return null;
        }
        PDFText pDFText = new PDFText(cosObject);
        return pDFText.stringValue();
    }

    ASDate getDictionaryDateValue(ASName aSName) {
        CosString cosString = (CosString)this.getCosDictionary().get(aSName);
        if (cosString == null) {
            return null;
        }
        return cosString.asDate();
    }

    ASName getDictionaryNameValue(ASName aSName) {
        CosName cosName = (CosName)this.getCosDictionary().get(aSName);
        if (cosName == null) {
            return null;
        }
        return cosName.nameValue();
    }

    int getDictionaryIntValue(ASName aSName) {
        CosNumeric cosNumeric = (CosNumeric)this.getCosDictionary().get(aSName);
        return cosNumeric.intValue();
    }

    ASString getDictionaryStringValue(ASName aSName) {
        CosString cosString = (CosString)this.getCosDictionary().get(aSName);
        if (cosString == null) {
            return null;
        }
        return cosString.stringValue();
    }

    String getDictionaryIntValueAsString(ASName aSName) {
        CosNumeric cosNumeric = (CosNumeric)this.getCosDictionary().get(aSName);
        return Integer.toString(cosNumeric.intValue());
    }

    double getDictionaryDoubleValue(ASName aSName) {
        CosNumeric cosNumeric = (CosNumeric)this.getCosDictionary().get(aSName);
        return cosNumeric.doubleValue();
    }

    boolean getDictionaryBooleanValue(ASName aSName) {
        return this.getCosDictionary().get(aSName).booleanValue();
    }

    String getDictionaryDoubleValueAsString(ASName aSName) {
        CosNumeric cosNumeric = (CosNumeric)this.getCosDictionary().get(aSName);
        return Double.toString(cosNumeric.doubleValue());
    }

    CosDictionary getDictionaryDictionaryValue(ASName aSName) {
        CosObject cosObject = this.getCosDictionary().get(aSName);
        if (cosObject instanceof CosDictionary) {
            return (CosDictionary)cosObject;
        }
        return null;
    }

    Number getDictionaryNumericValue(ASName aSName) {
        CosNumeric cosNumeric = (CosNumeric)this.getCosDictionary().get(aSName);
        if (cosNumeric == null) {
            return null;
        }
        return cosNumeric.numberValue();
    }

    ByteStream getDictionaryStreamValue(ASName aSName) {
        CosStream cosStream = (CosStream)this.getCosDictionary().get(aSName);
        if (cosStream == null) {
            return null;
        }
        return cosStream.getStream();
    }

    public CosArray getDictionaryArrayValue(ASName aSName) {
        return this.getCosDictionary().getCosArray(aSName);
    }

    void setDictionaryStringValue(ASName aSName, String string) {
        PDFText pDFText = PDFText.createString(this.getPDFDocument(), string);
        this.getCosDictionary().put(aSName, pDFText.getCosObject());
    }

    void setDictionaryASStringValue(ASName aSName, ASString aSString) {
        this.getCosDictionary().put(aSName, this.getPDFDocument().getDocument().newString(aSString));
    }

    void setDictionaryStringOrStreamValue(ASName aSName, String string) {
        PDFText pDFText = PDFText.create(this.getPDFDocument(), string);
        this.getCosDictionary().put(aSName, pDFText.getCosObject());
    }

    void setDictionaryTextValue(ASName aSName, PDFText pDFText) {
        this.getCosDictionary().put(aSName, pDFText.getCosObject());
    }

    void setDictionaryNameValue(ASName aSName, ASName aSName2) {
        this.getCosDictionary().put(aSName, aSName2);
    }

    void setDictionaryNameValue(ASName aSName, String string) {
        ASName aSName2 = ASName.create(string);
        this.getCosDictionary().put(aSName, aSName2);
    }

    void setDictionaryIntValue(ASName aSName, long l) {
        this.getCosDictionary().put(aSName, l);
    }

    void setDictionaryIntValue(ASName aSName, String string) {
        this.getCosDictionary().put(aSName, Integer.valueOf(string));
    }

    void setDictionaryDictionaryValue(ASName aSName, CosDictionary cosDictionary) {
        this.getCosDictionary().put(aSName, cosDictionary);
    }

    void setDictionaryDoubleValue(ASName aSName, double d) {
        this.getCosDictionary().put(aSName, d);
    }

    void setDictionaryDoubleValue(ASName aSName, String string) {
        this.getCosDictionary().put(aSName, Double.valueOf(string));
    }

    void setDictionaryBooleanValue(ASName aSName, boolean bl) {
        this.getCosDictionary().put(aSName, bl);
    }

    void setDictionaryBooleanValue(ASName aSName, String string) {
        this.getCosDictionary().put(aSName, string.equals("true"));
    }

    void setDictionaryArrayValue(ASName aSName, ArrayList arrayList) {
        CosArray cosArray = this.makeCosArray(arrayList);
        this.getCosDictionary().put(aSName, cosArray);
    }

    void setDictionaryArrayValue(ASName aSName, CosArray cosArray) {
        this.getCosDictionary().put(aSName, cosArray);
    }

    void setDictionaryValue(ASName aSName, CosObject cosObject) {
        this.getCosDictionary().put(aSName, cosObject);
    }

    protected CosArray makeCosArray(ArrayList arrayList) {
        CosArray cosArray = this.getPDFDocument().getDocument().newArray();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                cosArray.add(this.getPDFDocument().getDocument().newString((String)e));
                continue;
            }
            if (e instanceof Integer) {
                cosArray.add(this.getPDFDocument().getDocument().newNumeric((Integer)e));
                continue;
            }
            if (e instanceof Number) {
                cosArray.add(this.getPDFDocument().getDocument().newNumeric(((Number)e).doubleValue()));
                continue;
            }
            if (e instanceof CosObject) {
                cosArray.add((CosObject)e);
                continue;
            }
            if (e instanceof ArrayList) {
                CosArray cosArray2 = this.makeCosArray((ArrayList)e);
                cosArray.add(cosArray2);
                continue;
            }
            throw new PDFInvalidParameterException("Invalid value");
        }
        return cosArray;
    }

    public CosArray getCosArray() {
        return (CosArray)this.mCosObject;
    }

    public CosStream getCosStream() {
        return (CosStream)this.mCosObject;
    }
}

